/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.impl;

import org.ujmp.core.Coordinates;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix2D;

public class ArrayDenseIntMatrix2D
extends AbstractDenseIntMatrix2D {
    private static final long serialVersionUID = -3331102463077119410L;
    private final int[][] values;

    public ArrayDenseIntMatrix2D(int[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseIntMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new int[rows][columns];
    }

    public int getInt(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setInt(int value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public int getInt(int row, int column) {
        return this.values[row][column];
    }

    public void setInt(int value, int row, int column) {
        this.values[row][column] = value;
    }

    public final IntMatrix transpose() {
        int[][] result = new int[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix plus(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] + vInt;
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix minus(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] - vInt;
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix times(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] * vInt;
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix divide(double v) {
        int vInt = (int)v;
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] / vInt;
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix plus(IntMatrix m2) {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] + m2.getAsInt(r, c);
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix minus(IntMatrix m2) {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] - m2.getAsInt(r, c);
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix times(IntMatrix m2) {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] * m2.getAsInt(r, c);
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public final IntMatrix divide(IntMatrix m2) {
        int[][] result = new int[this.values.length][this.values[0].length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[r][c] / m2.getAsInt(r, c);
            }
        }
        return new ArrayDenseIntMatrix2D(result);
    }

    public IntMatrix mtimes(IntMatrix matrix) {
        if ((long)this.values[0].length != matrix.getRowCount()) {
            throw new RuntimeException("matrices have wrong size: " + Coordinates.toString(this.getSize()) + " and " + Coordinates.toString(matrix.getSize()));
        }
        int[][] ret = new int[this.values.length][(int)matrix.getColumnCount()];
        int i = this.values.length;
        while (--i >= 0) {
            int j = ret[0].length;
            while (--j >= 0) {
                int sum = 0;
                int k = this.values[0].length;
                while (--k >= 0) {
                    sum = (int)((double)sum + (double)this.values[i][k] * matrix.getAsDouble(k, j));
                }
                ret[i][j] = sum;
            }
        }
        return new ArrayDenseIntMatrix2D(ret);
    }

    public boolean containsNaN() {
        int r = this.values.length;
        while (--r >= 0) {
            int c = this.values[0].length;
            while (--c >= 0) {
                if (!Double.isNaN(this.values[r][c])) continue;
                return true;
            }
        }
        return false;
    }
}

