/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import org.ujmp.core.util.MathUtil;

public class WeakMappedByteBuffer {
    public static final int DEFAULTBUFFERSIZE = 0x800000;
    private WeakReference<ByteBuffer> byteBufferReference = null;
    private final FileChannel fileChannel;
    private final FileChannel.MapMode mapMode;
    private final long pos;
    private final long size;

    public WeakMappedByteBuffer(FileChannel fileChannel, FileChannel.MapMode mapMode, long pos, int size) {
        this.fileChannel = fileChannel;
        this.mapMode = mapMode;
        this.pos = pos;
        this.size = size;
    }

    public static final WeakMappedByteBuffer[] create(RandomAccessFile randomAccessFile) throws IOException {
        long fileLength = randomAccessFile.length();
        FileChannel fc = randomAccessFile.getChannel();
        FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
        int bufferCount = (int)Math.ceil((double)fileLength / 8388608.0);
        WeakMappedByteBuffer[] buffers = new WeakMappedByteBuffer[bufferCount];
        int i = 0;
        for (long filePos = 0L; filePos < fileLength; filePos += 0x800000L) {
            WeakMappedByteBuffer buf = new WeakMappedByteBuffer(fc, mapMode, filePos, MathUtil.longToInt(Math.min(0x800000L, fileLength - filePos)));
            buffers[i++] = buf;
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getOrCreateByteBuffer() {
        try {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = this.byteBufferReference == null ? null : (ByteBuffer)this.byteBufferReference.get();
            if (byteBuffer == null || this.byteBufferReference == null || this.byteBufferReference.get() == null) {
                WeakMappedByteBuffer weakMappedByteBuffer = this;
                synchronized (weakMappedByteBuffer) {
                    if (byteBuffer == null || this.byteBufferReference == null || this.byteBufferReference.get() == null) {
                        byteBuffer = this.fileChannel.map(this.mapMode, this.pos, this.size);
                        this.byteBufferReference = new WeakReference<ByteBuffer>(byteBuffer);
                    }
                }
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer slice() {
        return this.getOrCreateByteBuffer().slice();
    }

    public ByteBuffer duplicate() {
        return this.getOrCreateByteBuffer().duplicate();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.getOrCreateByteBuffer().asReadOnlyBuffer();
    }

    public byte get() {
        return this.getOrCreateByteBuffer().get();
    }

    public ByteBuffer put(byte b) {
        return this.getOrCreateByteBuffer().put(b);
    }

    public byte get(int index) {
        return this.getOrCreateByteBuffer().get(index);
    }

    public ByteBuffer put(int index, byte b) {
        return this.getOrCreateByteBuffer().put(index, b);
    }

    public ByteBuffer compact() {
        return this.getOrCreateByteBuffer().compact();
    }

    public boolean isDirect() {
        return this.getOrCreateByteBuffer().isDirect();
    }

    public char getChar() {
        return this.getOrCreateByteBuffer().getChar();
    }

    public ByteBuffer putChar(char value) {
        return this.getOrCreateByteBuffer().putChar(value);
    }

    public char getChar(int index) {
        return this.getOrCreateByteBuffer().getChar(index);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.getOrCreateByteBuffer().putChar(index, value);
    }

    public CharBuffer asCharBuffer() {
        return this.getOrCreateByteBuffer().asCharBuffer();
    }

    public short getShort() {
        return this.getOrCreateByteBuffer().getShort();
    }

    public ByteBuffer putShort(short value) {
        return this.getOrCreateByteBuffer().putShort(value);
    }

    public short getShort(int index) {
        return this.getOrCreateByteBuffer().getShort(index);
    }

    public ByteBuffer putShort(int index, short value) {
        return this.getOrCreateByteBuffer().putShort(index, value);
    }

    public ShortBuffer asShortBuffer() {
        return this.getOrCreateByteBuffer().asShortBuffer();
    }

    public int getInt() {
        return this.getOrCreateByteBuffer().getInt();
    }

    public ByteBuffer putInt(int value) {
        return this.getOrCreateByteBuffer().putInt(value);
    }

    public int getInt(int index) {
        return this.getOrCreateByteBuffer().getInt(index);
    }

    public ByteBuffer putInt(int index, int value) {
        return this.getOrCreateByteBuffer().putInt(index, value);
    }

    public IntBuffer asIntBuffer() {
        return this.getOrCreateByteBuffer().asIntBuffer();
    }

    public long getLong() {
        return this.getOrCreateByteBuffer().getLong();
    }

    public ByteBuffer putLong(long value) {
        return this.getOrCreateByteBuffer().putLong(value);
    }

    public long getLong(int index) {
        return this.getOrCreateByteBuffer().getLong(index);
    }

    public ByteBuffer putLong(int index, long value) {
        return this.getOrCreateByteBuffer().putLong(index, value);
    }

    public LongBuffer asLongBuffer() {
        return this.getOrCreateByteBuffer().asLongBuffer();
    }

    public float getFloat() {
        return this.getOrCreateByteBuffer().getFloat();
    }

    public ByteBuffer putFloat(float value) {
        return this.getOrCreateByteBuffer().putFloat(value);
    }

    public float getFloat(int index) {
        return this.getOrCreateByteBuffer().getFloat(index);
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.getOrCreateByteBuffer().putFloat(index, value);
    }

    public FloatBuffer asFloatBuffer() {
        return this.getOrCreateByteBuffer().asFloatBuffer();
    }

    public double getDouble() {
        return this.getOrCreateByteBuffer().getDouble();
    }

    public ByteBuffer putDouble(double value) {
        return this.getOrCreateByteBuffer().putDouble(value);
    }

    public double getDouble(int index) {
        return this.getOrCreateByteBuffer().getDouble(index);
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.getOrCreateByteBuffer().putDouble(index, value);
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.getOrCreateByteBuffer().asDoubleBuffer();
    }

    public boolean isReadOnly() {
        return this.getOrCreateByteBuffer().isReadOnly();
    }

    public long capacity() {
        return this.getOrCreateByteBuffer().capacity();
    }

    public void position(int offset) {
        this.getOrCreateByteBuffer().position(offset);
    }

    public void put(byte[] bytes, int offset, int length) {
        this.getOrCreateByteBuffer().put(bytes, offset, length);
    }

    public void get(byte[] dst, int offset, int length) {
        this.getOrCreateByteBuffer().get(dst, offset, length);
    }

    public Buffer rewind() {
        return this.getOrCreateByteBuffer().rewind();
    }

    public Buffer reset() {
        return this.getOrCreateByteBuffer().rewind();
    }
}

