/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jmatio;

import com.jmatio.types.MLDouble;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrixMultiD;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.MathUtil;
import org.ujmp.jmatio.MLDenseDoubleMatrixFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLDenseDoubleMatrix
extends AbstractDenseDoubleMatrixMultiD
implements Wrapper<MLDouble> {
    private static final long serialVersionUID = 5687213209146399315L;
    public static final MLDenseDoubleMatrixFactory Factory = new MLDenseDoubleMatrixFactory();
    private transient MLDouble matrix;
    private int[] pack = null;

    public MLDenseDoubleMatrix(Matrix m) {
        super(m.getSize());
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
            this.matrix = new MLDouble(m.getLabel(), MathUtil.toIntArray(m.getSize()));
        } else {
            this.matrix = new MLDouble("matrix" + System.nanoTime(), MathUtil.toIntArray(m.getSize()));
        }
        this.init();
        for (long[] c : m.availableCoordinates()) {
            this.setAsDouble(m.getAsDouble(c), c);
        }
    }

    public MLDenseDoubleMatrix(long ... size) {
        super(size);
        if (Coordinates.product(size) > 0L) {
            this.matrix = new MLDouble("matrix" + System.nanoTime(), MathUtil.toIntArray(size));
            this.init();
        }
    }

    private void init() {
        int[] dims = this.matrix.getDimensions();
        this.pack = new int[this.matrix.getNDimensions()];
        this.pack[0] = 1;
        for (int i = 1; i < this.pack.length; ++i) {
            this.pack[i] = dims[i - 1] * this.pack[i - 1];
        }
    }

    int getIndex(long ... coords) {
        int index = 0;
        for (int x = 0; x < coords.length; ++x) {
            index = (int)((long)index + coords[x] * (long)this.pack[x]);
        }
        return index;
    }

    public MLDenseDoubleMatrix(MLDouble matrix) {
        super(MathUtil.toLongArray(matrix.getDimensions()));
        this.matrix = matrix;
        this.setLabel(matrix.getName());
        this.init();
    }

    @Override
    public synchronized double getDouble(long ... coordinates) {
        return (Double)this.matrix.get(this.getIndex(coordinates));
    }

    @Override
    public synchronized void setDouble(double value, long ... coordinates) {
        this.matrix.set((Number)value, this.getIndex(coordinates));
    }

    @Override
    public MLDouble getWrappedObject() {
        return this.matrix;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String name = (String)s.readObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = new MLDouble(name, values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.matrix.name);
        s.writeObject(this.toDoubleArray());
    }
}

