/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.ujmp.core.util.io.HttpUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSchUtil {
    public static String remoteWget(String hostname, int port, String username, File keyFile, String passphrase, String url) throws JSchException, IOException {
        return JSchUtil.remoteExecute(hostname, port, username, keyFile, passphrase, "wget -qO - '" + url + "'");
    }

    public static Session forwardLocalPort(String hostname, int port, String username, File keyFile, String passphrase, int localPortToForward, String remoteHostToForwardTo, int remotePortToForwardTo) throws JSchException, IOException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.setPortForwardingL(localPortToForward, remoteHostToForwardTo, remotePortToForwardTo);
        session.connect();
        return session;
    }

    public static void mkdir(String hostname, int port, String username, File keyFile, String passphrase, String destinationFolder) throws JSchException, IOException, SftpException {
        JSchUtil.remoteExecute(hostname, port, username, keyFile, passphrase, "mkdir -p '" + destinationFolder + "'");
    }

    public static void installUJMP(String hostname, int port, String username, File keyFile, String passphrase, String destinationFolder) throws JSchException, IOException, SftpException {
        byte[] data = HttpUtil.getBytesFromUrl("https://oss.sonatype.org/content/repositories/snapshots/org/ujmp/ujmp-core/0.3.0/ujmp-core-0.3.0-20141019.102010-5.jar");
        JSchUtil.mkdir(hostname, port, username, keyFile, passphrase, destinationFolder);
        JSchUtil.uploadFile(hostname, port, username, keyFile, passphrase, data, destinationFolder, "ujmp-core-0.3.0.jar");
    }

    public static void startUJMP(String hostname, int port, String username, File keyFile, String passphrase, String destinationFolder) throws JSchException, IOException, SftpException {
        List<String> files = JSchUtil.ls(hostname, port, username, keyFile, passphrase, destinationFolder);
        String jar = null;
        for (String file : files) {
            if (!file.startsWith("ujmp") || !file.endsWith(".jar")) continue;
            jar = file;
        }
        if (jar == null) {
            throw new RuntimeException("UJMP not found in folder " + destinationFolder);
        }
        String result = JSchUtil.remoteExecute(hostname, port, username, keyFile, passphrase, destinationFolder + "java -jar " + destinationFolder + "/" + jar);
        System.out.println(result);
    }

    public static Session createSession(String hostname, int port, String username, File keyFile, String passphrase) throws JSchException {
        JSch jsch = new JSch();
        if (keyFile != null) {
            jsch.addIdentity(keyFile.getAbsolutePath(), passphrase);
        }
        Session session = jsch.getSession(username, hostname, port);
        UserInfo ui = JSchUtil.createUserInfo(passphrase);
        session.setUserInfo(ui);
        session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
        session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
        session.setConfig("compression_level", "9");
        return session;
    }

    public static String pwd(String hostname, int port, String username, File keyFile, String passphrase) throws JSchException, IOException, SftpException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.connect();
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.connect();
        String pwd = channel.pwd();
        channel.disconnect();
        session.disconnect();
        return pwd;
    }

    public static List<String> ls(String hostname, int port, String username, File keyFile, String passphrase, String path) throws JSchException, IOException, SftpException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.connect();
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.connect();
        Vector vector = channel.ls(path);
        channel.disconnect();
        session.disconnect();
        ArrayList<String> files = new ArrayList<String>();
        for (ChannelSftp.LsEntry lse : vector) {
            files.add(lse.getFilename());
        }
        return files;
    }

    public static void uploadFile(String hostname, int port, String username, File keyFile, String passphrase, File file, String destinationFolder) throws JSchException, IOException, SftpException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.connect();
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.connect();
        channel.cd(destinationFolder);
        channel.put((InputStream)new FileInputStream(file), file.getName());
        channel.disconnect();
        session.disconnect();
    }

    public static void uploadFile(String hostname, int port, String username, File keyFile, String passphrase, byte[] data, String destinationFolder, String destinationFileName) throws JSchException, IOException, SftpException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.connect();
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.connect();
        channel.cd(destinationFolder);
        channel.put((InputStream)new ByteArrayInputStream(data), destinationFileName);
        channel.disconnect();
        session.disconnect();
    }

    public static String remoteExecute(String hostname, int port, String username, File keyFile, String passphrase, String command) throws JSchException, IOException {
        Session session = JSchUtil.createSession(hostname, port, username, keyFile, passphrase);
        session.connect();
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand(command);
        InputStream in = channel.getInputStream();
        channel.setErrStream((OutputStream)System.err);
        channel.connect();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] tmp = new byte[8192];
        while (true) {
            if (in.available() > 0) {
                int i = in.read(tmp, 0, 8192);
                os.write(tmp, 0, i);
                if (i >= 0) continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {}
        }
        channel.disconnect();
        session.disconnect();
        return os.toString();
    }

    public static UserInfo createUserInfo(final String password) {
        UserInfo ui = new UserInfo(){

            public void showMessage(String arg0) {
            }

            public boolean promptYesNo(String arg0) {
                return true;
            }

            public boolean promptPassword(String arg0) {
                return true;
            }

            public boolean promptPassphrase(String arg0) {
                return false;
            }

            public String getPassword() {
                return password;
            }

            public String getPassphrase() {
                return null;
            }
        };
        return ui;
    }

    public static void startOrInstallUJMP(String hostname, int port, String username, File keyFile, String passphrase, String destinationFolder) throws JSchException, IOException, SftpException {
        JSchUtil.mkdir(hostname, port, username, keyFile, passphrase, destinationFolder);
        List<String> files = JSchUtil.ls(hostname, port, username, keyFile, passphrase, destinationFolder);
        String jar = null;
        for (String file : files) {
            if (!file.startsWith("ujmp") || !file.endsWith(".jar")) continue;
            jar = file;
            break;
        }
        if (jar == null) {
            JSchUtil.installUJMP(hostname, port, username, keyFile, passphrase, destinationFolder);
        }
        String result = JSchUtil.remoteExecute(hostname, port, username, keyFile, passphrase, "java -classpath " + destinationFolder + "/" + jar + " org.ujmp.core.UJMP");
        System.out.println(result);
    }
}

