/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DoubleElement {
    public int fIndex;
    public double fValue;

    public DoubleElement(int index, double value) {
        this.fIndex = index;
        this.fValue = value;
    }

    public static DoubleElement[] sort(SortMode sort, Order order, DoubleElement[] dels) {
        List<DoubleElement> list = DoubleElement.toList(dels);
        Collections.sort(list, new DoubleElementComparator(sort, order.isAscending()));
        return list.toArray(new DoubleElement[list.size()]);
    }

    public static int[] indexArray(List<DoubleElement> delist) {
        int[] indexes = new int[delist.size()];
        for (int i = 0; i < delist.size(); ++i) {
            indexes[i] = delist.get((int)i).fIndex;
        }
        return indexes;
    }

    public static double[] valueArray(List<DoubleElement> delist) {
        double[] values = new double[delist.size()];
        for (int i = 0; i < delist.size(); ++i) {
            values[i] = delist.get((int)i).fValue;
        }
        return values;
    }

    public static List<DoubleElement> toList(DoubleElement[] dels) {
        ArrayList<DoubleElement> list = new ArrayList<DoubleElement>(dels.length);
        for (int i = 0; i < dels.length; ++i) {
            list.add(dels[i]);
        }
        return list;
    }

    public static float[] toFloats(List<DoubleElement> dels) {
        float[] floats = new float[dels.size()];
        for (int i = 0; i < dels.size(); ++i) {
            floats[i] = (float)dels.get((int)i).fValue;
        }
        return floats;
    }

    public static class DoubleElementNaNlessComparator
    implements Comparator<DoubleElement> {
        private final Boolean fAscending;
        private final int firstObjReturn;
        private final int secondObjReturn;
        private boolean tiesDetected = false;

        public DoubleElementNaNlessComparator(boolean ascending) {
            this.fAscending = ascending;
            this.firstObjReturn = this.fAscending != false ? -1 : 1;
            this.secondObjReturn = this.fAscending != false ? 1 : -1;
        }

        public boolean isTiesDetected() {
            return this.tiesDetected;
        }

        @Override
        public int compare(DoubleElement element1, DoubleElement element2) {
            int index2;
            int index1;
            double value1 = element1.fValue;
            double value2 = element2.fValue;
            if (value1 < value2) {
                return this.firstObjReturn;
            }
            if (value1 > value2) {
                return this.secondObjReturn;
            }
            if (element1 != element2) {
                this.tiesDetected = true;
            }
            if ((index1 = element1.fIndex) < (index2 = element2.fIndex)) {
                return this.firstObjReturn;
            }
            if (index1 > index2) {
                return this.secondObjReturn;
            }
            return 0;
        }
    }

    public static class DoubleElementComparator
    implements Comparator<DoubleElement> {
        private final boolean fIsAbsolute;
        private final Boolean fAscending;
        private final int firstObjReturn;
        private final int secondObjReturn;

        public DoubleElementComparator(SortMode sort, boolean ascending) {
            this.fIsAbsolute = sort.isAbsolute();
            this.fAscending = ascending;
            this.firstObjReturn = this.fAscending != false ? -1 : 1;
            this.secondObjReturn = this.fAscending != false ? 1 : -1;
        }

        @Override
        public int compare(DoubleElement element1, DoubleElement element2) {
            if (element1 == null) {
                if (element2 == null) {
                    return 0;
                }
                return this.firstObjReturn;
            }
            if (element2 == null) {
                return this.secondObjReturn;
            }
            double value1 = element1.fValue;
            double value2 = element2.fValue;
            if (Double.isNaN(value1)) {
                if (Double.isNaN(value2)) {
                    return 0;
                }
                return this.firstObjReturn;
            }
            if (Double.isNaN(value2)) {
                return this.secondObjReturn;
            }
            if (this.fIsAbsolute) {
                value1 = Math.abs(value1);
                value2 = Math.abs(value2);
            }
            if (value1 < value2) {
                return this.firstObjReturn;
            }
            if (value1 > value2) {
                return this.secondObjReturn;
            }
            return 0;
        }
    }
}

