/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XYVector;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;

public class XYDatasetMultiTmp
implements XYDataset {
    private DatasetGroup fGroup;
    private final String[] fSeriesNames;
    private XYVector[] fXYVectors;

    public XYDatasetMultiTmp(String[] seriesNames, Vector sharedX, Vector[] yss) {
        int i;
        for (i = 0; i < yss.length; ++i) {
            if (yss[0].getSize() == yss[i].getSize()) continue;
            throw new MismatchedSizeException(yss[0], yss[i], i);
        }
        this.fGroup = new DatasetGroup();
        this.fSeriesNames = seriesNames;
        this.fXYVectors = new XYVector[yss.length];
        for (i = 0; i < yss.length; ++i) {
            this.fXYVectors[i] = new XYVector(sharedX, yss[i]);
        }
    }

    public int indexOf(Comparable seriesKey) {
        if (this.fSeriesNames == null || seriesKey == null) {
            return -1;
        }
        for (int i = 0; i < this.fSeriesNames.length; ++i) {
            if (this.fSeriesNames[i] == null || !this.fSeriesNames[i].equals(seriesKey)) continue;
            return i;
        }
        return -1;
    }

    public Comparable getSeriesKey(int series) {
        if (this.fSeriesNames == null) {
            throw new IllegalStateException("Dataset has no series");
        }
        return this.fSeriesNames[series];
    }

    public DatasetGroup getGroup() {
        return this.fGroup;
    }

    public void setGroup(DatasetGroup g) {
        this.fGroup = g;
    }

    public double getYValue(int series, int item) {
        XYVector xy = this.fXYVectors[series];
        return new Float(xy.y.getElement(item)).doubleValue();
    }

    public double getXValue(int series, int item) {
        XYVector xy = this.fXYVectors[series];
        return new Float(xy.x.getElement(item)).doubleValue();
    }

    public int getSeriesCount() {
        return this.fSeriesNames.length;
    }

    public int getItemCount(int series) {
        XYVector xy = this.fXYVectors[series];
        return xy.x.getSize();
    }

    public String getSeriesName(int series) {
        return this.fSeriesNames[series];
    }

    public Number getX(int i, int i1) {
        throw new NotImplementedException();
    }

    public Number getY(int i, int i1) {
        throw new NotImplementedException();
    }

    public void addChangeListener(DatasetChangeListener listener) {
    }

    public void removeChangeListener(DatasetChangeListener listener) {
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }
}

