/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldUtils;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class GFileField
extends JTextField
implements GFieldPlusChooser {
    public GFileField() {
        super(50);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setForeground(GFieldUtils._getColor(text));
    }

    @Override
    public Object getValue() {
        if (this.getText() == null) {
            return null;
        }
        return new File(this.getText());
    }

    @Override
    public void setValue(Object obj) {
        String p = obj == null ? "" : (obj instanceof File ? ((File)obj).getAbsolutePath() : obj.toString());
        this.setText(p);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void processKeyEvent(KeyEvent ev) {
        Document doc = this.getDocument();
        try {
            String text = this.getDocument().getText(0, doc.getLength());
            this.setForeground(GFieldUtils.getFileFieldColor(text));
            super.processKeyEvent(ev);
        }
        catch (BadLocationException e) {
            super.processKeyEvent(ev);
        }
    }
}

