/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import javax.swing.JMenuBar;
import javax.swing.JTable;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapComponent;

public class LeadingEdgePanel {
    private HeatMapComponent heatMap;
    private File resultDirectory;

    public LeadingEdgePanel(Frame parent) {
        this.heatMap = new HeatMapComponent(parent, IExpressionDataUtil.createRandomData(1, 1), null);
        this.heatMap.setFeatureUIString("Gene Set");
        this.heatMap.setSampleUIString("Gene");
        this.heatMap.setShowFeatureAnnotator(false);
        this.heatMap.setShowRowDescriptions(false);
        this.heatMap.setShowSampleAnnotator(false);
        this.heatMap.setShowColorSchemeOptions(false);
        final JTable featureTable = this.heatMap.getFeatureTable();
        featureTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LeadingEdgePanel.this.resultDirectory == null) {
                    return;
                }
                int row = featureTable.rowAtPoint(e.getPoint());
                int column = featureTable.columnAtPoint(e.getPoint());
                if (row != -1 && column == 0) {
                    String value = (String)featureTable.getValueAt(row, column);
                    value = value.replaceAll("_signal", "");
                    File gsetGseaFile = new File(LeadingEdgePanel.this.resultDirectory, value + ".html");
                    URI uri = gsetGseaFile.toURI();
                    try {
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            }
        });
    }

    public void setResultDirectory(File resultDirectory) {
        this.resultDirectory = resultDirectory;
    }

    public void setData(IExpressionData data, ColorScheme cs) {
        this.heatMap.setColorConverter(cs);
        this.heatMap.setExpressionData(data);
    }

    public JMenuBar getMenuBar() {
        this.heatMap.setOptionsDialogOptions(false, false, false);
        return this.heatMap.createMenuBar(false, false, false, false);
    }

    public HeatMapComponent getHeatMapComponent() {
        return this.heatMap;
    }
}

