/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu.jfree;

import edu.mit.broad.genome.StandardException;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.genepattern.io.ImageUtil;
import org.genepattern.menu.PlotAction;
import org.genepattern.uiutil.UIUtil;
import org.jfree.chart.ChartPanel;
import xapps.gsea.GseaFileFilter;

public class JFreeSaveImageAction
extends PlotAction {
    private final Frame parent;

    public JFreeSaveImageAction(Frame parent) {
        if (parent == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.putValue("Name", "Save Image");
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public JMenuItem[] getSubMenuItems() {
        final JMenuItem jpegItem = new JMenuItem("jpeg...");
        final JMenuItem pngItem = new JMenuItem("png...");
        final JMenuItem svgItem = new JMenuItem("svg...");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == jpegItem) {
                    JFreeSaveImageAction.this.save(new String[]{"jpeg", "jpg"});
                } else if (e.getSource() == pngItem) {
                    JFreeSaveImageAction.this.save(new String[]{"png"});
                } else if (e.getSource() == svgItem) {
                    JFreeSaveImageAction.this.save(new String[]{"svg"});
                }
            }
        };
        jpegItem.addActionListener(l);
        pngItem.addActionListener(l);
        svgItem.addActionListener(l);
        return new JMenuItem[]{jpegItem, pngItem, svgItem};
    }

    private void save(String ... formats) {
        final String outputFileFormat = formats[0];
        FileDialog fileDialog = new FileDialog(this.parent, "Save as " + outputFileFormat, 1);
        fileDialog.setMultipleMode(false);
        fileDialog.setModal(true);
        if (SystemUtils.IS_OS_WINDOWS) {
            StringBuilder sb = new StringBuilder("*.").append(outputFileFormat);
            for (int i = 1; i < formats.length; ++i) {
                sb.append(";*.").append(formats[i]);
            }
            fileDialog.setFile(sb.toString());
        } else if (!SystemUtils.IS_OS_MAC_OSX) {
            fileDialog.setFile("image." + formats[0]);
        }
        if (!SystemUtils.IS_OS_MAC_OSX) {
            fileDialog.setFilenameFilter(new GseaFileFilter(formats, outputFileFormat + " image files"));
        }
        fileDialog.setVisible(true);
        File[] files = fileDialog.getFiles();
        if (files != null && files.length > 0) {
            final File outputFile = files[0];
            final ChartPanel plot = (ChartPanel)this.getPlot();
            SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    try {
                        ImageUtil.savePlotImage(plot, outputFile, outputFileFormat);
                    }
                    catch (StandardException se) {
                        UIUtil.showErrorDialog(JFreeSaveImageAction.this.getPlot().getTopLevelAncestor(), se.getMessage());
                    }
                    return null;
                }
            };
            worker.execute();
        }
    }

    private void showError(Exception e, String msg) {
        if (e.getMessage() != null) {
            msg = (String)msg + "\nCause: " + e.getMessage();
        }
        UIUtil.showErrorDialog(this.getPlot().getTopLevelAncestor(), (String)msg);
    }

    public static class SaveImageFileFilter
    extends FileFilter {
        private final List<String> extensions;
        private final String fileFormat;
        private final String description;

        public SaveImageFileFilter(String[] extensions, String description, String fileFormat) {
            this.extensions = Arrays.asList(extensions);
            this.description = description;
            this.fileFormat = fileFormat;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int dotIndex = name.lastIndexOf(".");
            if (dotIndex > 0) {
                String ext = name.substring(dotIndex + 1, name.length());
                return this.extensions.contains(ext.toLowerCase());
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }
    }
}

