/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import java.util.Arrays;

public class MergeJoinBag {
    private int[][] m_pVectToInd;
    private float[][] m_pDistToVal;
    private float m_fltMin;
    private float m_fltMax;

    public int[] getIndVector(int n) {
        return this.m_pVectToInd[n];
    }

    public float[] getValVector(int n) {
        return this.m_pDistToVal[n];
    }

    public MergeJoinBag(int n, int n2) {
        this(n, n2, false);
    }

    public MergeJoinBag(int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            this.m_pVectToInd = null;
        } else {
            this.m_pVectToInd = new int[n][n2];
            for (n3 = 0; n3 < this.m_pVectToInd.length; ++n3) {
                Arrays.fill(this.m_pVectToInd[n3], -1);
            }
        }
        this.m_pDistToVal = new float[n][n2];
        for (n3 = 0; n3 < this.m_pDistToVal.length; ++n3) {
            Arrays.fill(this.m_pDistToVal[n3], Float.MAX_VALUE);
        }
        this.m_fltMin = Float.MAX_VALUE;
        this.m_fltMax = -3.4028235E38f;
    }

    public int getRowCount() {
        return this.m_pDistToVal.length;
    }

    public int getColumnCount() {
        if (this.m_pDistToVal.length <= 0 || this.m_pDistToVal[0] == null) {
            return 0;
        }
        return this.m_pDistToVal[0].length;
    }

    public void Clear() {
        this.m_pVectToInd = null;
        this.m_pDistToVal = null;
    }

    public void AppendTo(int n, int n2, float f) {
        int n3;
        int[] nArray = this.getIndVector(n);
        float[] fArray = this.getValVector(n);
        for (n3 = 0; n3 < fArray.length && !(f <= fArray[n3]); ++n3) {
        }
        if (n3 < fArray.length) {
            if (fArray.length - n3 - 1 > 0) {
                System.arraycopy(fArray, n3, fArray, n3 + 1, fArray.length - n3 - 1);
                System.arraycopy(nArray, n3, nArray, n3 + 1, nArray.length - n3 - 1);
            }
            nArray[n3] = n2;
            fArray[n3] = f;
        }
    }

    public void Assert(int n, int n2, float f) {
        this.m_fltMin = Math.min(this.m_fltMin, f);
        this.m_fltMax = Math.max(this.m_fltMax, f);
        this.AppendTo(n, n2, f);
        this.AppendTo(n2, n, f);
    }

    public void Normalize(float f) {
        float f2 = this.m_fltMax - this.m_fltMin;
        for (int i = 0; i < this.m_pDistToVal.length; ++i) {
            for (int j = 0; j < this.m_pDistToVal[i].length; ++j) {
                this.m_pDistToVal[i][j] = (1.0f - (this.m_pDistToVal[i][j] - this.m_fltMin) / f2) * (1.0f - f) + f;
            }
        }
    }
}

