/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestResume
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestResume.java,v 1.14 2012-02-08 06:19:29 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestResume;

    protected String getLogName() {
        return "TestResume.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testResumePut() throws Exception {
        log.debug("testResumePut()");
        try {
            this.setup();
            String filename = this.generateRandomFilename();
            this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 50000L);
            boolean cancelled = false;
            try {
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            }
            catch (FTPTransferCancelledException ex) {
                log.debug("Caught expected cancellation exception", ex);
                cancelled = true;
            }
            this.ftp.quit();
            TestResume.assertTrue((boolean)cancelled);
            this.setup();
            this.ftp.resume();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            this.ftp.get(this.localDataDir + filename, filename);
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            this.ftp.cancelResume();
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            Object var5_5 = null;
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testResumeGet() throws Exception {
        log.debug("testResumeGet()");
        try {
            this.setup();
            String filename = this.generateRandomFilename();
            this.ftp.setProgressMonitor(new CancelProgressMonitor(this.ftp), 131072L);
            boolean cancelled = false;
            try {
                this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
            }
            catch (FTPTransferCancelledException ex) {
                log.debug("Caught expected cancellation exception", ex);
                cancelled = true;
            }
            this.ftp.quit();
            TestResume.assertTrue((boolean)cancelled);
            this.setup();
            this.ftp.resume();
            this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
            String filename2 = this.generateRandomFilename();
            this.ftp.get(this.localDataDir + filename2, this.remoteBinaryFile);
            this.assertIdentical(this.localDataDir + filename, this.localDataDir + filename2);
            File local = new File(this.localDataDir + filename);
            local.delete();
            local = new File(this.localDataDir + filename2);
            local.delete();
            this.ftp.quit();
            Object var6_6 = null;
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testResumeDownload() throws Exception {
        log.debug("testResumeDownload()");
        try {
            this.connect();
            this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
            this.ftp.chdir(this.testdir);
            this.ftp.setType(FTPTransferType.BINARY);
            String filename = this.generateRandomFilename();
            this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
            long size = this.ftp.size(filename);
            long resumePoint = (long)(Math.random() * (double)size);
            log.debug("Resume point=" + resumePoint);
            this.ftp.resumeNextDownload(resumePoint);
            FileInputStream in = new FileInputStream(this.localDataDir + this.localBinaryFile);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = 0;
            byte[] buf = new byte[4096];
            in.skip(resumePoint);
            while ((count = in.read(buf)) > 0) {
                out.write(buf, 0, count);
            }
            byte[] buf1 = out.toByteArray();
            byte[] buf2 = this.ftp.get(filename);
            this.ftp.delete(filename);
            TestResume.assertEquals((long)buf2.length, (long)(size - resumePoint));
            this.assertIdentical(buf1, buf2);
            this.ftp.quit();
            Object var13_10 = null;
            if (!this.ftp.connected()) return;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            if (!this.ftp.connected()) throw throwable;
            this.ftp.quitImmediately();
            throw throwable;
        }
        this.ftp.quitImmediately();
    }

    protected void setup() throws Exception {
        this.connect();
        if (this.ftp instanceof FTPClient) {
            ((FTPClient)this.ftp).setRetryCount(0);
            log.debug("Set retry count to 0");
        }
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestResume == null ? (class$com$enterprisedt$net$ftp$test$TestResume = TestResume.class$("com.enterprisedt.net.ftp.test.TestResume")) : class$com$enterprisedt$net$ftp$test$TestResume);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestResume.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CancelProgressMonitor
    implements FTPProgressMonitor {
        private boolean cancelled = false;
        private FTPClientInterface ftpClient;

        public CancelProgressMonitor(FTPClientInterface ftp) {
            this.ftpClient = ftp;
        }

        public void bytesTransferred(long bytes) {
            FTPTestCase.log.debug("bytesTransferred(" + bytes + ") called");
            if (!this.cancelled) {
                FTPTestCase.log.debug("Cancelling transfer");
                this.ftpClient.cancelTransfer();
                this.cancelled = true;
            }
        }
    }

    public class TestProgressMonitor
    implements FTPProgressMonitor {
        public void bytesTransferred(long count) {
            FTPTestCase.log.info(count + " bytes transferred");
        }
    }
}

