/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import org.ujmp.core.BaseMatrix;
import org.ujmp.core.Coordinates;
import org.ujmp.core.annotation.HasMetaData;
import org.ujmp.core.calculation.CanPerformCalculations;
import org.ujmp.core.calculation.DivideMatrix;
import org.ujmp.core.calculation.DivideMatrixCalculation;
import org.ujmp.core.calculation.DivideScalar;
import org.ujmp.core.calculation.DivideScalarCalculation;
import org.ujmp.core.calculation.MinusMatrix;
import org.ujmp.core.calculation.MinusMatrixCalculation;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.MinusScalarCalculation;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.calculation.PlusMatrix;
import org.ujmp.core.calculation.PlusMatrixCalculation;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.calculation.TimesMatrix;
import org.ujmp.core.calculation.TimesMatrixCalculation;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Chol;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Eig;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Inv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.doublematrix.calculation.general.decomposition.QR;
import org.ujmp.core.doublematrix.calculation.general.decomposition.SVD;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Solve;
import org.ujmp.core.export.destinationselector.MatrixExportDestinationSelector;
import org.ujmp.core.importer.sourceselector.MatrixImportSourceSelector;
import org.ujmp.core.interfaces.Conversions;
import org.ujmp.core.interfaces.CoordinateFunctions;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.DistanceMeasures;
import org.ujmp.core.interfaces.ExtendedMatrixProperties;
import org.ujmp.core.interfaces.GettersAndSetters;
import org.ujmp.core.matrix.factory.DefaultDenseMatrixFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Matrix
extends BaseMatrix,
CoreObject,
CoordinateFunctions,
GettersAndSetters,
CanPerformCalculations,
DistanceMeasures,
Comparable<Matrix>,
HasMetaData,
Conversions,
ExtendedMatrixProperties {
    public static final DefaultDenseMatrixFactory Factory = new DefaultDenseMatrixFactory();
    public static final TransposeCalculation<Matrix, Matrix> transpose = Transpose.MATRIX;
    public static final PlusMatrixCalculation<Matrix, Matrix, Matrix> plusMatrix = PlusMatrix.MATRIX;
    public static final MinusMatrixCalculation<Matrix, Matrix, Matrix> minusMatrix = MinusMatrix.MATRIX;
    public static final TimesMatrixCalculation<Matrix, Matrix, Matrix> timesMatrix = TimesMatrix.MATRIX;
    public static final DivideMatrixCalculation<Matrix, Matrix, Matrix> divideMatrix = DivideMatrix.MATRIX;
    public static final PlusScalarCalculation<Matrix, Matrix> plusScalar = PlusScalar.MATRIX;
    public static final MinusScalarCalculation<Matrix, Matrix> minusScalar = MinusScalar.MATRIX;
    public static final TimesScalarCalculation<Matrix, Matrix> timesScalar = TimesScalar.MATRIX;
    public static final DivideScalarCalculation<Matrix, Matrix> divideScalar = DivideScalar.MATRIX;
    public static final MtimesCalculation<Matrix, Matrix, Matrix> mtimes = Mtimes.MATRIX;
    public static final SVD<Matrix> svd = SVD.INSTANCE;
    public static final LU<Matrix> lu = LU.INSTANCE;
    public static final QR<Matrix> qr = QR.INSTANCE;
    public static final Inv<Matrix> inv = Inv.INSTANCE;
    public static final Solve<Matrix> solve = Solve.INSTANCE;
    public static final Chol<Matrix> chol = Chol.INSTANCE;
    public static final Eig<Matrix> eig = Eig.INSTANCE;

    @Override
    public Matrix clone();

    public MatrixExportDestinationSelector exportTo();

    public MatrixImportSourceSelector importFrom();

    public void share(String var1, int var2) throws UnknownHostException, IOException;

    public void share(int var1) throws IOException;

    @Override
    public void fireValueChanged();

    public void fireValueChanged(Coordinates var1, Object var2);

    public void fireValueChanged(Coordinates var1, Coordinates var2);

    public void save(File var1) throws IOException;

    public void save(String var1) throws IOException;

    public String toHtml();
}

