/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class IndexOfMin
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8301078828905448159L;

    public IndexOfMin(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    public double getDouble(long ... coordinates) {
        double min = Double.MAX_VALUE;
        long index = -1L;
        switch (this.getDimension()) {
            case 0: {
                for (long r = this.getSource().getSize()[0] - 1L; r != -1L; --r) {
                    long[] lArray = new long[]{r, coordinates[1]};
                    double v = this.getSource().getAsDouble(lArray);
                    if (!(v < min)) continue;
                    min = v;
                    index = r;
                }
                return index;
            }
            case 1: {
                for (long c = this.getSource().getSize()[1] - 1L; c != -1L; --c) {
                    long[] lArray = new long[]{coordinates[0], c};
                    double v = this.getSource().getAsDouble(lArray);
                    if (!(v < min)) continue;
                    min = v;
                    index = c;
                }
                return index;
            }
        }
        return 0.0;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
        }
        return null;
    }
}

