/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.text;

import java.io.File;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.text.English;
import org.ujmp.core.text.German;
import org.ujmp.core.text.TextUtil;
import org.ujmp.core.util.io.IntelligentFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Language {
    ENGLISH(English.ALPHABET, English.ALLOWEDCHARACTERS, English.CHARFREQUENCIES, English.CHARBIGRAMFREQUENCIES, 5.1),
    GERMAN(German.ALPHABET, German.ALLOWEDCHARACTERS, German.CHARFREQUENCIES, German.CHARBIGRAMFREQUENCIES, 6.0);

    private final char[] alphabet;
    private final char[] allowedCharacters;
    private final Matrix charFrequencies;
    private final Matrix charBigramFrequencies;
    private final double averageWordLength;

    private Language(char[] alphabet, char[] allowedCharacters, Matrix charFrequencies, Matrix charBigramFrequencies, double averageWordLength) {
        this.alphabet = alphabet;
        this.allowedCharacters = allowedCharacters;
        this.charFrequencies = charFrequencies;
        this.charBigramFrequencies = charBigramFrequencies;
        this.averageWordLength = averageWordLength;
    }

    public char[] getAlphabet() {
        return this.alphabet;
    }

    public char[] getAllowedCharacters() {
        return this.allowedCharacters;
    }

    public static final Language guess(File file) {
        return Language.guess(IntelligentFileReader.load(file));
    }

    public double getAverageWordLength() {
        return this.averageWordLength;
    }

    public static final Language guess(String string) {
        double bestSim = 0.0;
        Language bestLanguage = null;
        for (Language lang : Language.values()) {
            Matrix count = TextUtil.getCharacterBigramFrequencies(string, lang.getAlphabet());
            double sum = count.getValueSum();
            Matrix freq = count.divide(Calculation.Ret.NEW, true, sum).log(Calculation.Ret.NEW);
            double sim = freq.cosineSimilarityTo(lang.getCharacterBigramFrequencies().log(Calculation.Ret.NEW), true);
            System.out.println((Object)((Object)lang) + ": " + sim);
            if (!(sim > bestSim)) continue;
            bestSim = sim;
            bestLanguage = lang;
        }
        return bestLanguage;
    }

    public Matrix getCharacterFrequencies() {
        return this.charFrequencies;
    }

    public Matrix getCharacterBigramFrequencies() {
        return this.charBigramFrequencies;
    }
}

