/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.ujmp.core.util.UJMPSettings;

public abstract class HttpUtil {
    public static final byte[] getBytesFromUrl(String urlString) throws IOException {
        return HttpUtil.getBytesFromUrl(new URL(urlString));
    }

    public static final byte[] getBytesFromUrl(URL url) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        HttpUtil.download(url, (OutputStream)output);
        output.close();
        return output.toByteArray();
    }

    public static final String getStringFromUrl(String urlString) throws IOException {
        return new String(HttpUtil.getBytesFromUrl(urlString));
    }

    public static void download(String url, File file) throws IOException {
        HttpUtil.download(new URL(url), file);
    }

    public static void download(URL url, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        HttpUtil.download(url, (OutputStream)os);
        os.close();
    }

    public static void download(String url, OutputStream output) throws IOException {
        HttpUtil.download(new URL(url), output);
    }

    public static void download(URL url, OutputStream output) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", UJMPSettings.getInstance().getUserAgent());
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(3000);
        InputStream input = connection.getInputStream();
        byte[] buffer = new byte[8192];
        int n = -1;
        while ((n = input.read(buffer)) != -1) {
            if (n <= 0) continue;
            output.write(buffer, 0, n);
        }
        output.flush();
        input.close();
    }
}

