/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ujmp.core.util.R;
import org.ujmp.gui.MatrixGUIObject;

public class RPanel
extends JPanel {
    private static final long serialVersionUID = -3779245352485347462L;
    private MatrixGUIObject matrix = null;

    public RPanel(MatrixGUIObject m) {
        this.matrix = m;
        this.setLayout(new FlowLayout());
        this.add(new JButton(new ScatterPlotAction()));
        this.add(new JButton(new ImageAction()));
        this.add(new JButton(new HistAction()));
        this.add(new JButton(new PairsPlotAction()));
        this.add(new JButton(new BoxPlotAction()));
        this.add(new JButton(new QQNormAction()));
        this.add(new JButton(new CloseLastFigureAction()));
    }

    class CloseLastFigureAction
    extends AbstractAction {
        private static final long serialVersionUID = 200834911041935616L;

        public CloseLastFigureAction() {
            super("Close last Figure");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().closeLastFigure();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class HistAction
    extends AbstractAction {
        private static final long serialVersionUID = 8662123505287412855L;

        public HistAction() {
            super("Histogram");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().hist(RPanel.this.matrix.getMatrix(), "col=\"blue\"");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class ImageAction
    extends AbstractAction {
        private static final long serialVersionUID = 7429007259920214890L;

        public ImageAction() {
            super("Image");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().image(RPanel.this.matrix.getMatrix(), new String[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class QQNormAction
    extends AbstractAction {
        private static final long serialVersionUID = -7646548720554325669L;

        public QQNormAction() {
            super("QQNorm");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().qqnorm(RPanel.this.matrix.getMatrix(), "col=\"blue\",pch=16");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class PairsPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = -4346940332819549757L;

        public PairsPlotAction() {
            super("Pairs Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().pairs(RPanel.this.matrix.getMatrix(), "col=\"blue\",pch=16");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class BoxPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = -3887385311081144648L;

        public BoxPlotAction() {
            super("Box Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().boxplot(RPanel.this.matrix.getMatrix(), "col=\"blue\"");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class ScatterPlotAction
    extends AbstractAction {
        private static final long serialVersionUID = -5429144529799026446L;

        public ScatterPlotAction() {
            super("Scatter Plot");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                R.getInstance().plot(RPanel.this.matrix.getMatrix(), "col=\"blue\",pch=16");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

