/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import java.util.HashSet;

public class AlgUtils {
    private AlgUtils() {
    }

    public static int unionAllCount(GeneSet[] gsets) {
        HashSet<String> all = new HashSet<String>();
        for (int f = 0; f < gsets.length; ++f) {
            for (int i = 0; i < gsets[f].getNumMembers(); ++i) {
                all.add(gsets[f].getMember(i));
            }
        }
        return all.size();
    }

    public static int getNumOfMembers(Dataset ds, GeneSet gs) {
        int ntrue = 0;
        for (int i = 0; i < ds.getNumRow(); ++i) {
            if (!gs.isMember(ds.getRowName(i))) continue;
            ++ntrue;
        }
        return ntrue;
    }

    public static int getNumOfMembers(RankedList rl, GeneSet gs) {
        int ntrue = 0;
        for (int r = 0; r < rl.getSize(); ++r) {
            if (!gs.isMember(rl.getRankName(r))) continue;
            ++ntrue;
        }
        return ntrue;
    }

    public static int intersectSize(GeneSet a, GeneSet b) {
        HashSet<String> common = new HashSet<String>();
        for (int i = 0; i < a.getNumMembers(); ++i) {
            String member = a.getMember(i);
            if (!b.isMember(member)) continue;
            common.add(member);
        }
        return common.size();
    }
}

