/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;

public class EnrichmentScoreImpl
implements EnrichmentScore {
    private int fNumHits;
    private float fES;
    private int fRankAtES;
    private float fRankScoreAtES;
    private float fNES;
    private float fNP;
    private float fFWER;
    private float fFDR;
    private Vector fESProfile;
    private Vector fESProfile_point_by_point;
    private int[] fHitIndices;

    public EnrichmentScoreImpl(float es, int rankAtEs, float corrAtEs, float nes, float np, float fdr, float fwer, int numHits, int[] hitIndices_opt, Vector runningRaw_opt, Vector runningRaw_ppoint_by_point_opt) {
        this.init(es, rankAtEs, corrAtEs, nes, np, fdr, fwer, numHits, hitIndices_opt, runningRaw_opt, runningRaw_ppoint_by_point_opt);
    }

    public EnrichmentScoreImpl(EnrichmentScore es, float nes, float np, float fdr, float fwer) {
        this.init(es.getES(), es.getRankAtES(), es.getRankScoreAtES(), nes, np, fdr, fwer, es.getNumHits(), es.getHitIndices(), es.getESProfile(), es.getESProfile_point_by_point_opt());
    }

    protected void init(float es, int rankAtEs, float corrAtEs, float nes, float np, float fdr, float fwer, int numHits, int[] hitIndices_opt, Vector runningRaw_opt, Vector runningRaw_ppoint_by_point_opt) {
        this.fES = es;
        this.fRankAtES = rankAtEs;
        this.fRankScoreAtES = corrAtEs;
        this.fNES = nes;
        this.fNP = np;
        this.fFDR = fdr;
        this.fFWER = fwer;
        this.fNumHits = numHits;
        this.fHitIndices = hitIndices_opt;
        this.fESProfile = runningRaw_opt;
        this.fESProfile_point_by_point = runningRaw_ppoint_by_point_opt;
    }

    @Override
    public float getES() {
        return this.fES;
    }

    @Override
    public int getRankAtES() {
        return this.fRankAtES;
    }

    @Override
    public float getRankScoreAtES() {
        return this.fRankScoreAtES;
    }

    @Override
    public float getNES() {
        return this.fNES;
    }

    @Override
    public float getNP() {
        return this.fNP;
    }

    @Override
    public float getFWER() {
        return this.fFWER;
    }

    @Override
    public float getFDR() {
        return this.fFDR;
    }

    @Override
    public Vector getESProfile() {
        if (this.fESProfile != null) {
            this.fESProfile.setImmutable();
        }
        return this.fESProfile;
    }

    @Override
    public Vector getESProfile_point_by_point_opt() {
        return this.fESProfile_point_by_point;
    }

    @Override
    public int getNumHits() {
        return this.fNumHits;
    }

    @Override
    public int[] getHitIndices() {
        return this.fHitIndices;
    }
}

