/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;

public class GeneSetMatrix2GeneSetAction
extends FileObjectAction {
    private Object fFileOrObject;

    public GeneSetMatrix2GeneSetAction() {
        super("GeneSetMatrix2GeneSetAction", "=> Convert the GeneSetMatrix into a single GeneSet", "Convert the GeneSetMatrix into a single GeneSet (eliminates duplicates)", null);
    }

    @Override
    public void setFile(File file) {
        this.fFileOrObject = file;
    }

    @Override
    public void setObject(Object obj) {
        this.fFileOrObject = obj;
    }

    @Override
    public Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFileOrObject != null) {
                GeneSetMatrix gm;
                if (this.fFileOrObject instanceof File) {
                    gm = (GeneSetMatrix)ParserFactory.read((File)this.fFileOrObject);
                } else if (this.fFileOrObject instanceof GeneSetMatrix) {
                    gm = (GeneSetMatrix)this.fFileOrObject;
                } else {
                    throw new IllegalArgumentException("Only GeneSetMatrix or File Objects allowed. Got: " + this.fFileOrObject);
                }
                GeneSet gset = ParserFactory.combineIntoOne(gm);
                File tmp = new File(Application.getVdbManager().getTmpDir(), gset.getName(true));
                ParserFactory.save(gset, tmp);
                Application.getWindowManager().showMessage("Successfully created a GeneSet from the GeneSetMatrix " + gm.getName() + " into: " + tmp.getPath());
            } else {
                Application.getWindowManager().showMessage("No file or object to work on was specified");
            }
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Error creating a GeneSet from GeneSetMatrix", t);
        }
        return widget;
    }
}

