/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.tui.ParamSetDisplay;
import edu.mit.broad.xbench.tui.ToolRunnerControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import xtools.api.Tool;
import xtools.api.param.ParamSet;

public class SingleToolLauncher
extends JPanel
implements Widget,
MouseMotionListener,
ToolRunnerControl.DisplayHook {
    public static final String TITLE = "Tool Launcher";
    public static final Icon ICON = JarResources.getIcon("ToolLauncher.gif");
    private Tool fTool;
    private ParamSet fParamSet;
    private ToolRunnerControl fToolRunner;
    private ParamSetDisplay fDisplay;
    private String fName;
    private boolean fShowTopBufferPanel;
    private Icon fIcon;
    private String fTitle;
    private boolean fMakeNormalTheDefault;
    private boolean fShowGrayHelpText;

    public SingleToolLauncher(Tool tool, ParamSet pset, boolean showTopBufferPanel, boolean makeNormalTheDefault, boolean showGrayHelptext, String optTitle, Icon icon) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        if (pset == null) {
            throw new IllegalArgumentException("Param pset cannot be null");
        }
        this.fTool = tool;
        this.fTitle = optTitle;
        this.fIcon = icon;
        this.fParamSet = pset;
        this.fShowTopBufferPanel = showTopBufferPanel;
        this.fMakeNormalTheDefault = makeNormalTheDefault;
        this.fShowGrayHelpText = showGrayHelptext;
        this.fDisplay = new ParamSetDisplay(this.fTool.getTitle(), this.fIcon, this.fParamSet, this);
        this.fToolRunner = new ToolRunnerControl(this);
        this.fDisplay.addMouseMotionListener(this);
        this.checkTable();
        this.setLayout(new BorderLayout());
        if (this.fShowTopBufferPanel) {
            JPanel topPanel = new JPanel(new FlowLayout(3));
            JLabel label = new JLabel("<html><body>Initialized to: <b>" + this.fTool.getClass().getName() + "</b></body></html>");
            int height = 30;
            topPanel.add(label);
            topPanel.setPreferredSize(new Dimension(this.getWidth(), height));
            this.add((Component)topPanel, "North");
        }
        this.add(Box.createHorizontalStrut(5), "East");
        this.add(Box.createHorizontalStrut(5), "West");
        this.add((Component)new JScrollPane(this.fDisplay.getAsComponent()), "Center");
        this.add((Component)this.fToolRunner, "South");
    }

    @Override
    public void resetParamSet() {
        this.fDisplay.reset();
    }

    @Override
    public Tool getCurrentTool() {
        return this.fTool;
    }

    @Override
    public ParamSet getCurrentParamSet() {
        return this.fParamSet;
    }

    @Override
    public boolean isRecordToolRun() {
        return false;
    }

    @Override
    public JComponent getWrappedComponent() {
        return this;
    }

    @Override
    public String getAssociatedTitle() {
        if (this.fTitle != null) {
            return this.fTitle;
        }
        if (this.fName == null) {
            StringTokenizer tok = new StringTokenizer(this.fTool.getClass().getName(), ".");
            while (tok.hasMoreTokens()) {
                this.fName = tok.nextToken();
            }
        }
        return this.fName;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return Widget.EMPTY_MENU_BAR;
    }

    @Override
    public Icon getAssociatedIcon() {
        return this.fIcon;
    }

    private void checkTable() {
        ParamSet pset = this.fTool.getParamSet();
        boolean ready = pset.isRequiredAllSet();
        this.fToolRunner.setEnabledControls(ready);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkTable();
    }
}

