/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import edu.mit.broad.genome.objects.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TemplateNonAuxBoxModel
implements ComboBoxModel {
    private ComboBoxModel fOrigModel;
    private List objects;
    private int fSelIndex = 0;

    public TemplateNonAuxBoxModel(ComboBoxModel model) {
        model.addListDataListener(new MyListDataListener());
        this.init(model);
    }

    private void init(ComboBoxModel model) {
        this.fOrigModel = model;
        this.objects = new ArrayList();
        for (int i = 0; i < this.fOrigModel.getSize(); ++i) {
            Template template = (Template)this.fOrigModel.getElementAt(i);
            if (template.isContinuous()) {
                this.objects.add(template);
                continue;
            }
            if (template.isAux()) continue;
            this.objects.add(template);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.fOrigModel.addListDataListener(l);
    }

    @Override
    public Object getElementAt(int index) {
        if (this.objects.size() == 0) {
            return null;
        }
        return this.objects.get(index);
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.fOrigModel.removeListDataListener(l);
    }

    @Override
    public Object getSelectedItem() {
        if (this.objects.size() == 0) {
            return null;
        }
        if (this.fSelIndex >= this.objects.size()) {
            return null;
        }
        return this.objects.get(this.fSelIndex);
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.fSelIndex = this.objects.indexOf(obj);
    }

    public static class TemplateContWrapper {
        File sourceFile;

        public int hashCode() {
            return this.sourceFile.hashCode();
        }

        public boolean equals(Object obj) {
            return obj.equals(this.sourceFile);
        }

        public String toString() {
            return this.sourceFile.toString();
        }
    }

    class MyListDataListener
    implements ListDataListener {
        MyListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            TemplateNonAuxBoxModel.this.init(TemplateNonAuxBoxModel.this.fOrigModel);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            TemplateNonAuxBoxModel.this.init(TemplateNonAuxBoxModel.this.fOrigModel);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            TemplateNonAuxBoxModel.this.init(TemplateNonAuxBoxModel.this.fOrigModel);
        }
    }
}

