/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Point;
import javax.swing.JComponent;

public class PixelConverter {
    private JComponent component;
    int rowSize;
    int columnSize;

    public PixelConverter(JComponent component) {
        this.component = component;
    }

    public void setColumnSize(int i) {
        this.columnSize = i;
    }

    public void setRowSize(int i) {
        this.rowSize = i;
    }

    public int getLeftIndex(int left) {
        if (left < this.component.getInsets().left) {
            return 0;
        }
        return (left - this.component.getInsets().left) / this.columnSize;
    }

    public int getTopIndex(int top) {
        if (top < this.component.getInsets().top) {
            return 0;
        }
        return (top - this.component.getInsets().top) / this.rowSize;
    }

    public int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = right / this.columnSize + 1;
        return result > limit ? limit : result;
    }

    public int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.rowSize + 1;
        return result > limit ? limit : result;
    }

    public int columnAtPoint(Point p) {
        return (int)((p.getX() - (double)this.component.getInsets().left) / (double)this.columnSize);
    }

    public int rowAtPoint(Point p) {
        return (int)((p.getY() - (double)this.component.getInsets().top) / (double)this.rowSize);
    }
}

