/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.uiutil;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class FTPList {
    private FileTransferClient ftpClient = new FileTransferClient();
    public String host;

    public FTPList(String host, String username, String password) throws IOException, FTPException, IllegalArgumentException {
        this.host = host;
        this.ftpClient.setRemoteHost(host);
        this.ftpClient.setUserName(username);
        this.ftpClient.setPassword(password);
        this.ftpClient.connect();
        this.ftpClient.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
    }

    public String[] getDirectoryListing(String dir, Comparator comp) throws IOException, FTPException {
        this.ftpClient.changeDirectory(dir);
        String[] fileNames = this.ftpClient.directoryNameList();
        if (comp != null && fileNames != null && fileNames.length > 0) {
            Arrays.parallelSort(fileNames, comp);
        }
        return fileNames;
    }

    public void quit() throws IOException, FTPException {
        this.ftpClient.disconnect();
    }
}

