/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.ParseUtils;
import xtools.api.param.AbstractObjectChooserParam;

abstract class StringChooserAbstractParam
extends AbstractObjectChooserParam {
    StringChooserAbstractParam(String name, String nameEnglish, String desc, String[] defs, String[] hints, boolean reqd) {
        super(name, nameEnglish, String.class, desc, (Object[])defs, (Object[])hints, reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof String[]) {
            super.setValue(value);
        } else if (value instanceof String) {
            super.setValue(this._parse((String)value));
        } else {
            throw new IllegalArgumentException("Invalid type, only String[] and comma-delim parsable String accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    protected String[] _parse(String s) {
        return ParseUtils.string2strings(s, ",");
    }

    public String[] getStrings() {
        Object val = super.getValue();
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (String[])val;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        Object[] ss = (String[])val;
        return StringChooserAbstractParam.format(ss);
    }

    @Override
    public boolean isFileBased() {
        return false;
    }
}

