/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.xbench.RendererFactory2;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.genepattern.uiutil.FTPFile;

public class FTPFileListCellRenderer
extends DefaultListCellRenderer {
    private final String highestVersionId;

    public FTPFileListCellRenderer(String highestVersionId) {
        this.highestVersionId = StringUtils.lowerCase((String)highestVersionId);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof FTPFile) {
            String s = ((FTPFile)value).getName();
            String slc = s.toLowerCase();
            if (slc.contains(this.highestVersionId)) {
                Font font = this.getFont();
                String fontName = font.getFontName();
                int fontSize = font.getSize();
                this.setFont(new Font(fontName, 1, fontSize));
            }
            this.setText(s);
            this.setIcon(RendererFactory2.FTP_FILE_ICON);
        }
        return this;
    }
}

