/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.basic;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class Power
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -6766560469728046231L;

    public Power(Matrix m1, Matrix m2) {
        super(m1, m2);
        if (m2.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[1] = Matrix.Factory.fill(m2.getAsDouble(0L, 0L), m1.getSize());
        }
    }

    public Power(Matrix m1, double v2) {
        this(m1, (Matrix)Matrix.Factory.fill(v2, m1.getSize()));
    }

    public double getDouble(long ... coordinates) {
        return Math.pow(this.getSource().getAsDouble(coordinates), this.getSources()[1].getAsDouble(coordinates));
    }
}

