/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.impl;

import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.stub.AbstractSparseGenericMatrix;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseGenericMatrix<A>
extends AbstractSparseGenericMatrix<A> {
    private static final long serialVersionUID = -7139128532871448340L;
    protected final Map<Coordinates, A> values = new HashMap<Coordinates, A>();
    private int maximumNumberOfEntries = -1;

    public DefaultSparseGenericMatrix(Matrix m) {
        this(m, -1);
    }

    public DefaultSparseGenericMatrix(Matrix m, int maximumNumberOfEntries) {
        super(m.getSize());
        this.maximumNumberOfEntries = maximumNumberOfEntries;
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    public DefaultSparseGenericMatrix(long ... size) {
        super(size);
        this.size = Coordinates.copyOf(size);
    }

    @Override
    public void setSize(long ... size) {
        this.size = size;
    }

    @Override
    public A getObject(long ... coordinates) {
        return this.values.get(Coordinates.wrap(coordinates));
    }

    @Override
    public long getValueCount() {
        return this.values.size();
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        if (MathUtil.isNull(value)) {
            this.values.remove(Coordinates.wrap(coordinates));
        } else {
            while (this.maximumNumberOfEntries > 0 && this.values.size() > this.maximumNumberOfEntries) {
                this.values.remove(this.values.keySet().iterator().next());
            }
            if (Coordinates.isSmallerThan(coordinates, this.size)) {
                if (MathUtil.isNull(value)) {
                    this.values.remove(Coordinates.wrap(coordinates));
                } else {
                    this.values.put(Coordinates.wrap(coordinates).clone(), value);
                }
            }
        }
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.values.keySet());
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.values.containsKey(Coordinates.wrap(coordinates).clone());
    }

    @Override
    public double getAsDouble(long ... coordinates) {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) {
        this.setObject((Object)value, coordinates);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public final void clear() {
        this.values.clear();
    }
}

