/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.intmatrix.calculation.AbstractIntCalculation;

public class ValueToColumn
extends AbstractIntCalculation {
    private static final long serialVersionUID = 1294551769508034360L;
    private int max;
    private final long[] size;

    public ValueToColumn(Matrix matrix, int max) {
        super(matrix);
        if (matrix.getColumnCount() != 1L) {
            throw new RuntimeException("matrix must have one column");
        }
        this.max = max;
        this.size = new long[]{this.getSource().getRowCount(), max + 1};
    }

    public ValueToColumn(Matrix matrix) {
        super(matrix);
        if (matrix.getColumnCount() != 1L) {
            throw new RuntimeException("matrix must have one column");
        }
        for (long[] c : this.getSource().availableCoordinates()) {
            this.max = Math.max(this.max, this.getSource().getAsInt(c));
        }
        this.size = new long[]{this.getSource().getRowCount(), this.max + 1};
    }

    public final long[] getSize() {
        return this.size;
    }

    public int getInt(long ... coordinates) {
        int col = this.getSource().getAsInt(coordinates[0], 0L);
        if ((long)col == coordinates[1]) {
            return 1;
        }
        return 0;
    }
}

