/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerObjectMatrixUDP
extends AbstractSparseObjectMatrix {
    private static final long serialVersionUID = 3907994158174208114L;
    private static final int BUFFERSIZE = 512;
    public static final int GETDOUBLEVALUE = 0;
    public static final int SETDOUBLEVALUE = 1;
    public static final int GETDIMENSIONCOUNT = 2;
    private Matrix matrix = null;
    private DatagramSocket socket = null;
    private DatagramPacket receivedPacket = null;
    private ServerThread thread = null;

    public ServerObjectMatrixUDP(Matrix matrix, int port) {
        super(matrix.getSize());
        this.matrix = matrix;
        try {
            this.receivedPacket = new DatagramPacket(new byte[512], 512);
            this.thread = new ServerThread();
            this.socket = new DatagramSocket(port);
            this.thread.start();
        }
        catch (Exception e) {
            throw new RuntimeException("could not open socket", e);
        }
    }

    @Override
    public long[] getSize() {
        this.size = this.matrix.getSize();
        return this.size;
    }

    @Override
    public final void clear() {
        this.matrix.clear();
    }

    @Override
    public double getAsDouble(long ... coordinates) {
        return this.matrix.getAsDouble(coordinates);
    }

    @Override
    public Object getObject(long ... coordinates) {
        return this.matrix.getAsObject(coordinates);
    }

    @Override
    public long getValueCount() {
        return this.matrix.getValueCount();
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) {
        this.matrix.setAsDouble(value, coordinates);
    }

    @Override
    public void setObject(Object o, long ... coordinates) {
        this.matrix.setAsObject(o, coordinates);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.matrix.containsCoordinates(coordinates);
    }

    @Override
    public boolean isReadOnly() {
        return this.matrix.isReadOnly();
    }

    class ServerThread
    extends Thread {
        public void run() {
            try {
                while (true) {
                    ServerObjectMatrixUDP.this.socket.receive(ServerObjectMatrixUDP.this.receivedPacket);
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ServerObjectMatrixUDP.this.receivedPacket.getData()));
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    int command = ois.readInt();
                    Coordinates coordinates = null;
                    double value = 0.0;
                    switch (command) {
                        case 1: {
                            coordinates = (Coordinates)ois.readObject();
                            value = ois.readDouble();
                            ServerObjectMatrixUDP.this.setAsDouble(value, coordinates.getLongCoordinates());
                            oos.writeInt(1);
                            break;
                        }
                        case 0: {
                            coordinates = (Coordinates)ois.readObject();
                            value = ServerObjectMatrixUDP.this.getAsDouble(coordinates.getLongCoordinates());
                            oos.writeInt(0);
                            oos.writeDouble(value);
                            break;
                        }
                        case 2: {
                            int dimension = ois.readInt();
                            int result = (int)ServerObjectMatrixUDP.this.getSize(dimension);
                            oos.writeInt(2);
                            oos.writeInt(result);
                        }
                    }
                    oos.flush();
                    DatagramPacket sentPacket = new DatagramPacket(bos.toByteArray(), bos.size(), ServerObjectMatrixUDP.this.receivedPacket.getAddress(), ServerObjectMatrixUDP.this.receivedPacket.getPort());
                    ServerObjectMatrixUDP.this.socket.send(sentPacket);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error in data transmission", e);
            }
        }
    }
}

