/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.shortmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.shortmatrix.ShortMatrix;
import org.ujmp.core.shortmatrix.calculation.ShortCalculation;
import org.ujmp.core.shortmatrix.impl.ShortCalculationMatrix;

public abstract class AbstractShortCalculation
extends AbstractCalculation
implements ShortCalculation {
    private static final long serialVersionUID = 7200876039893919030L;

    public AbstractShortCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractShortCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final ShortMatrix calcLink() {
        return new ShortCalculationMatrix(this);
    }

    public final ShortMatrix calcNew() {
        ShortMatrix result = (ShortMatrix)Matrix.Factory.zeros(ValueType.SHORT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsShort(this.getShort(c), c);
        }
        if (this.getMetaData() != null) {
            result.setMetaData(this.getMetaData().clone());
        }
        return result;
    }

    public final Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsShort(this.getShort(c), c);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }

    public void setShort(short value, long ... coordinates) {
    }

    public final ValueType getValueType() {
        return ValueType.SHORT;
    }
}

