/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.table;

import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ujmp.gui.table.ListSelectionEvent64;
import org.ujmp.gui.table.ListSelectionListener64;
import org.ujmp.gui.table.ListSelectionModel64;

public class FastListSelectionModel64
implements ListSelectionModel64 {
    private final int selectionMode = 1;
    private final EventListenerList listenerList = new EventListenerList();
    private long minIndex = -1L;
    private long maxIndex = -1L;
    private boolean valueIsAdjusting = false;

    public final void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public final void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(ListSelectionListener.class, l);
    }

    public final void addListSelectionListener(ListSelectionListener64 l) {
        this.listenerList.add(ListSelectionListener64.class, l);
    }

    public final void removeListSelectionListener(ListSelectionListener64 l) {
        this.listenerList.remove(ListSelectionListener64.class, l);
    }

    public final void addSelectionInterval(int index0, int index1) {
        if (index1 > index0) {
            this.minIndex = Math.min(this.minIndex, (long)index0);
            this.maxIndex = Math.max(this.maxIndex, (long)index1);
            this.fireValueChanged(index0, index1, this.getValueIsAdjusting());
        } else {
            this.minIndex = Math.min(this.minIndex, (long)index1);
            this.maxIndex = Math.max(this.maxIndex, (long)index0);
            this.fireValueChanged(index1, index0, this.getValueIsAdjusting());
        }
    }

    public final void addSelectionInterval(long index0, long index1) {
        if (index1 > index0) {
            this.minIndex = Math.min(this.minIndex, index0);
            this.maxIndex = Math.max(this.maxIndex, index1);
            this.fireValueChanged(index0, index1, this.getValueIsAdjusting());
        } else {
            this.minIndex = Math.min(this.minIndex, index1);
            this.maxIndex = Math.max(this.maxIndex, index0);
            this.fireValueChanged(index1, index0, this.getValueIsAdjusting());
        }
    }

    protected final void fireValueChanged(long firstIndex, long lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected final void fireValueChanged(long firstIndex, long lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == ListSelectionListener64.class) {
                ((ListSelectionListener64)listeners[i + 1]).valueChanged(new ListSelectionEvent64((Object)this, firstIndex, lastIndex, isAdjusting));
                continue;
            }
            if (listeners[i] != ListSelectionListener.class) continue;
            ((ListSelectionListener)listeners[i + 1]).valueChanged(new ListSelectionEvent(this, (int)firstIndex, (int)lastIndex, isAdjusting));
        }
    }

    public final void clearSelection() {
        this.minIndex = -1L;
        this.maxIndex = -1L;
        this.fireValueChanged();
    }

    private final void fireValueChanged() {
        this.fireValueChanged(0L, Long.MAX_VALUE);
    }

    public final int getMinSelectionIndex() {
        return (int)this.minIndex;
    }

    public final long getMinSelectionIndex64() {
        return this.minIndex;
    }

    public final int getAnchorSelectionIndex() {
        return (int)this.minIndex;
    }

    public final long getAnchorSelectionIndex64() {
        return this.minIndex;
    }

    public final int getLeadSelectionIndex() {
        return (int)this.maxIndex;
    }

    public final long getLeadSelectionIndex64() {
        return this.maxIndex;
    }

    public final int getMaxSelectionIndex() {
        return (int)this.maxIndex;
    }

    public final long getMaxSelectionIndex64() {
        return this.maxIndex;
    }

    public final int getSelectionMode() {
        return 1;
    }

    public final boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public final void insertIndexInterval(int index, int length, boolean before) {
        this.minIndex = Math.min(this.minIndex, (long)index);
        this.maxIndex = Math.max(this.maxIndex, (long)(index + length));
        this.fireValueChanged();
    }

    public final void insertIndexInterval(long index, long length, boolean before) {
        this.minIndex = Math.min(this.minIndex, index);
        this.maxIndex = Math.max(this.maxIndex, index + length);
        this.fireValueChanged();
    }

    public final boolean isSelectedIndex(int index) {
        return (long)index >= this.minIndex && (long)index <= this.maxIndex;
    }

    public final boolean isSelectedIndex(long index) {
        return index >= this.minIndex && index <= this.maxIndex;
    }

    public final boolean isSelectionEmpty() {
        return this.minIndex == -1L || this.maxIndex == -1L;
    }

    public final void removeIndexInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, (long)index0);
            this.maxIndex = Math.min(this.maxIndex, (long)index1);
        } else {
            this.minIndex = Math.max(this.minIndex, (long)index1);
            this.maxIndex = Math.min(this.maxIndex, (long)index0);
        }
        this.fireValueChanged();
    }

    public final void removeIndexInterval(long index0, long index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged();
    }

    public final void removeSelectionInterval(int index0, int index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, (long)index0);
            this.maxIndex = Math.min(this.maxIndex, (long)index1);
        } else {
            this.minIndex = Math.max(this.minIndex, (long)index1);
            this.maxIndex = Math.min(this.maxIndex, (long)index0);
        }
        this.fireValueChanged(index0, index1, this.getValueIsAdjusting());
    }

    public final void removeSelectionInterval(long index0, long index1) {
        if (index1 >= index0) {
            this.minIndex = Math.max(this.minIndex, index0);
            this.maxIndex = Math.min(this.maxIndex, index1);
        } else {
            this.minIndex = Math.max(this.minIndex, index1);
            this.maxIndex = Math.min(this.maxIndex, index0);
        }
        this.fireValueChanged(index0, index1, this.getValueIsAdjusting());
    }

    public final void setAnchorSelectionIndex(int index) {
        this.minIndex = Math.min(this.minIndex, (long)index);
        this.fireValueChanged();
    }

    public final void setAnchorSelectionIndex(long index) {
        this.minIndex = Math.min(this.minIndex, index);
        this.fireValueChanged();
    }

    public final void setLeadSelectionIndex(int index) {
        this.maxIndex = Math.max(this.maxIndex, (long)index);
        this.fireValueChanged();
    }

    public final void setLeadSelectionIndex(long index) {
        this.maxIndex = Math.max(this.maxIndex, index);
        this.fireValueChanged();
    }

    public final void setSelectionInterval(int index0, int index1) {
        long oldMinIndex = this.minIndex;
        long oldMaxIndex = this.maxIndex;
        if (index1 > index0) {
            this.minIndex = index0;
            this.maxIndex = index1;
        } else {
            this.minIndex = index1;
            this.maxIndex = index0;
        }
        this.fireValueChanged(Math.min(oldMinIndex, this.minIndex), Math.max(oldMaxIndex, this.maxIndex), this.getValueIsAdjusting());
    }

    public final void setSelectionInterval(long index0, long index1) {
        long oldMinIndex = this.minIndex;
        long oldMaxIndex = this.maxIndex;
        if (index1 > index0) {
            this.minIndex = index0;
            this.maxIndex = index1;
        } else {
            this.minIndex = index1;
            this.maxIndex = index0;
        }
        this.fireValueChanged(Math.min(oldMinIndex, this.minIndex), Math.max(oldMaxIndex, this.maxIndex), this.getValueIsAdjusting());
    }

    public final void setSelectionMode(int selectionMode) {
        throw new UnsupportedOperationException("selection mode may not be changed");
    }

    public final void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }
}

