/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.ujmp.core.Coordinates;
import org.ujmp.core.util.ColorUtil;
import org.ujmp.core.util.UJMPTimer;
import org.ujmp.gui.DefaultMatrixGUIObject;
import org.ujmp.gui.util.DataItem;

public class LoadDataTask
extends TimerTask {
    private static LoadDataTask instance = null;
    private static final Object lock = new Object();
    private List<DefaultMatrixGUIObject> list = new LinkedList<DefaultMatrixGUIObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LoadDataTask getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new LoadDataTask();
                }
            }
        }
        return instance;
    }

    private LoadDataTask() {
        UJMPTimer.newInstance("LoadData").schedule((TimerTask)this, 50L, 50L);
    }

    public void add(DefaultMatrixGUIObject matrixGUIObject) {
        this.list.add(matrixGUIObject);
    }

    public void run() {
        try {
            for (DefaultMatrixGUIObject matrixGUIObject : this.list) {
                try {
                    if (!matrixGUIObject.isColumnCountUpToDate()) {
                        matrixGUIObject.setColumnCount(matrixGUIObject.getMatrix().getColumnCount());
                        matrixGUIObject.setColumnCountUpToDate(true);
                        matrixGUIObject.fireValueChanged(-1L, -1L, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    matrixGUIObject.setColumnCount(0L);
                    matrixGUIObject.setColumnCountUpToDate(true);
                    matrixGUIObject.fireValueChanged(-1L, -1L, null);
                }
                try {
                    if (!matrixGUIObject.isRowCountUpToDate()) {
                        matrixGUIObject.setRowCount(matrixGUIObject.getMatrix().getRowCount());
                        matrixGUIObject.setRowCountUpToDate(true);
                        matrixGUIObject.fireValueChanged(-1L, -1L, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    matrixGUIObject.setRowCount(0L);
                    matrixGUIObject.setRowCountUpToDate(true);
                    matrixGUIObject.fireValueChanged(-1L, -1L, null);
                }
                try {
                    if (!matrixGUIObject.isRowCountUpToDate() || !matrixGUIObject.isColumnCountUpToDate() || matrixGUIObject.getTodo().isEmpty()) continue;
                    long t0 = System.currentTimeMillis();
                    while (matrixGUIObject.isRowCountUpToDate() && matrixGUIObject.isColumnCountUpToDate() && !matrixGUIObject.getTodo().isEmpty() && System.currentTimeMillis() - t0 < 300L) {
                        Coordinates coordinates = matrixGUIObject.getTodo().remove(matrixGUIObject.getTodo().size() - 1);
                        Object object = matrixGUIObject.getMatrix().getAsObject(coordinates.getLongCoordinates());
                        matrixGUIObject.getDataCache().put(coordinates, new DataItem(object, ColorUtil.fromObject(object)));
                    }
                    matrixGUIObject.updateUI();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

