/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideComboBoxButton;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.border.AbstractBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class BasicJideComboBoxUI
extends MetalComboBoxUI {
    private boolean _rollOver = false;
    protected RolloverListener _rolloverListener;

    public static BasicJideComboBoxUI createUI(JComponent jComponent) {
        return new BasicJideComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JideSwingUtilities.installBorder(this.comboBox, this.createComboBoxBorder());
    }

    protected BasicJideComboBoxBorder createComboBoxBorder() {
        return new BasicJideComboBoxBorder();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._rolloverListener == null) {
            this._rolloverListener = this.createRolloverListener();
        }
        this.comboBox.addMouseListener(this._rolloverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this._rolloverListener);
        this._rolloverListener = null;
    }

    protected RolloverListener createRolloverListener() {
        return new RolloverListener();
    }

    @Override
    protected JButton createArrowButton() {
        BasicJideComboBoxButton basicJideComboBoxButton = new BasicJideComboBoxButton(this.comboBox, new BasicJideComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        basicJideComboBoxButton.setMargin(new Insets(1, 3, 0, 4));
        basicJideComboBoxButton.setFocusPainted(this.comboBox.isEditable());
        basicJideComboBoxButton.addMouseListener(this._rolloverListener);
        return basicJideComboBoxButton;
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
        this.arrowButton.removeMouseListener(this._rolloverListener);
    }

    @Override
    public void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(this._rolloverListener);
        this.editor.removeFocusListener(this._rolloverListener);
    }

    @Override
    public void configureEditor() {
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        }
        this.editor.addMouseListener(this._rolloverListener);
        this.editor.addFocusListener(this._rolloverListener);
    }

    @Override
    public void layoutComboBox(Container container, MetalComboBoxUI.MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        Object object;
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof BasicJideComboBoxButton) {
                object = ((BasicJideComboBoxButton)this.arrowButton).getComboIcon();
                Insets insets = this.arrowButton.getInsets();
                Insets insets2 = this.comboBox.getInsets();
                int n = object.getIconWidth() + insets.left + insets.right;
                this.arrowButton.setBounds(this.comboBox.getComponentOrientation().isLeftToRight() ? this.comboBox.getWidth() - insets2.right - n : insets2.left, insets2.top, n, this.comboBox.getHeight() - insets2.top - insets2.bottom);
            } else {
                object = this.comboBox.getInsets();
                int n = this.comboBox.getWidth();
                int n2 = this.comboBox.getHeight();
                this.arrowButton.setBounds(((Insets)object).left, ((Insets)object).top, n - (((Insets)object).left + ((Insets)object).right), n2 - (((Insets)object).top + ((Insets)object).bottom));
            }
        }
        if (this.editor != null) {
            object = this.rectangleForCurrentValue();
            this.editor.setBounds((Rectangle)object);
        }
    }

    public boolean isRollOver() {
        return this._rollOver || (this.editor != null ? this.editor.hasFocus() : this.hasFocus);
    }

    public void setRollOver(boolean bl) {
        this._rollOver = bl;
    }

    protected class BasicJideComboBoxIcon
    implements Icon {
        protected BasicJideComboBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JideSwingUtilities.paintArrow(graphics, component.getForeground(), n, n2, 5, 0);
        }

        @Override
        public int getIconWidth() {
            return 5;
        }

        @Override
        public int getIconHeight() {
            return 3;
        }
    }

    protected class RolloverListener
    extends MouseAdapter
    implements FocusListener {
        protected RolloverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicJideComboBoxUI.this.setRollOver(true);
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (BasicJideComboBoxUI.this.comboBox.isPopupVisible()) {
                PopupMenuListener popupMenuListener = new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        BasicJideComboBoxUI.this.setRollOver(false);
                        ((JPopupMenu)((Object)BasicJideComboBoxUI.this.popup)).removePopupMenuListener(this);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                };
                ((JPopupMenu)((Object)BasicJideComboBoxUI.this.popup)).addPopupMenuListener(popupMenuListener);
                BasicJideComboBoxUI.this.setRollOver(true);
            } else {
                BasicJideComboBoxUI.this.setRollOver(false);
            }
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicJideComboBoxUI.this.comboBox.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicJideComboBoxUI.this.comboBox.repaint();
        }
    }

    protected class BasicJideComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 4633179647696691207L;

        protected BasicJideComboBoxBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            JComboBox jComboBox = (JComboBox)component;
            if (jComboBox.isPopupVisible() || BasicJideComboBoxUI.this.isRollOver()) {
                graphics.setColor(UIDefaultsLookup.getColor("JideButton.borderColor"));
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("TextField.background"));
            }
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(color);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 1;
            insets.left = 1;
            return insets;
        }
    }
}

