/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.test.TestTools;
import com.enterprisedt.util.debug.Logger;
import java.util.Properties;

public class FTPTestTools
extends TestTools {
    protected static Logger log = Logger.getLogger("FTPTestTools");
    protected boolean useDeprecatedConstructors = false;
    protected FTPConnectMode connectMode;
    protected boolean strictReplies = true;
    protected boolean autoPassiveIPSubstitution = false;
    protected boolean integrityCheck = true;

    public void setProperties(Properties props) {
        String connectModeStr;
        super.setProperties(props);
        String strict = props.getProperty("ftptest.strictreplies");
        this.strictReplies = strict == null || !strict.equalsIgnoreCase("false");
        String autoPassive = props.getProperty("ftptest.autopassivesubstitution");
        this.autoPassiveIPSubstitution = autoPassive != null && autoPassive.equalsIgnoreCase("true");
        String deprecatedConstructorsStr = props.getProperty("ftptest.deprecatedconstructors");
        if (deprecatedConstructorsStr != null) {
            this.useDeprecatedConstructors = Boolean.getBoolean(deprecatedConstructorsStr);
        }
        this.connectMode = (connectModeStr = System.getProperty("ftptest.connectmode")) != null && connectModeStr.equalsIgnoreCase("active") ? FTPConnectMode.ACTIVE : FTPConnectMode.PASV;
        String integrityCheckStr = props.getProperty("ftptest.integritycheck", "true");
        if (System.getProperty("ftptest.integritycheck") != null) {
            integrityCheckStr = System.getProperty("ftptest.integritycheck");
        }
        if (integrityCheckStr.equalsIgnoreCase("false")) {
            this.integrityCheck = false;
        }
    }

    public FTPClientInterface connect() throws Exception {
        FTPClient ftp = this.createClient();
        ftp.connect();
        ftp.login(this.user, this.password);
        return ftp;
    }

    private FTPClient createClient() throws Exception {
        FTPClient ftp = null;
        if (!this.useDeprecatedConstructors) {
            ftp = new FTPClient();
            ftp.setRemoteHost(this.host);
            ftp.setTimeout(this.timeout);
        } else {
            ftp = new FTPClient(this.host, 21, this.timeout);
        }
        ftp.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
        ftp.setConnectMode(this.connectMode);
        ftp.setDetectTransferMode(true);
        if (!this.strictReplies) {
            log.warn("Strict replies not enabled");
            ftp.setStrictReturnCodes(false);
        }
        return ftp;
    }

    public FTPClientInterface connect(int lowest, int highest) throws Exception {
        FTPClient ftp = this.createClient();
        ftp.setActivePortRange(lowest, highest);
        ftp.connect();
        ftp.login(this.user, this.password);
        return ftp;
    }

    public void reconnect(FTPClientInterface ftp) throws Exception {
        FTPClient client = (FTPClient)ftp;
        client.connect();
        client.login(this.user, this.password);
    }
}

