/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;

public class DatasetTemplate {
    private Dataset fDataset;
    private Template fTemplate;
    private File fDatasetFile;
    private File fTemplateFile;
    private boolean fAdd2Cache;
    private GeneSet fGeneSpace;
    private File fGeneSpaceFile;

    public DatasetTemplate(Dataset ds, Template t) {
        if (ds == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Param t cannot be null");
        }
        this.fDataset = ds;
        this.fTemplate = t;
    }

    public String getTemplateName() {
        if (this.fTemplate != null) {
            return this.fTemplate.getName();
        }
        return NamingConventions.removeExtension(this.fTemplateFile.getName());
    }

    public Dataset getDataset(boolean add2cache) {
        if (this.fDataset == null) {
            try {
                this.fDataset = ParserFactory.readDataset(this.fDatasetFile, add2cache, add2cache);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (this.fGeneSpace != null) {
            return new DatasetGenerators().extractRows(this.fDataset, this.fGeneSpace);
        }
        if (this.fGeneSpaceFile != null) {
            try {
                this.fGeneSpace = ParserFactory.readGeneSet(this.fGeneSpaceFile, false);
                return new DatasetGenerators().extractRows(this.fDataset, this.fGeneSpace);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return this.fDataset;
    }

    public Dataset getDataset() {
        return this.getDataset(this.fAdd2Cache);
    }

    public Template getTemplate() {
        if (this.fTemplate == null) {
            try {
                this.fTemplate = ParserFactory.readTemplate(this.fTemplateFile, this.fAdd2Cache, this.fAdd2Cache);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return this.fTemplate;
    }
}

