/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Chip2ChipMapper
extends AbstractObject {
    private Chip fTargetChip;

    public static GeneSetMatrix createCombinedGeneSetMatrix(String name, MGeneSetMatrix mgm) {
        if (mgm == null) {
            throw new IllegalArgumentException("Param mgm cannot be null");
        }
        int numMappedSets = mgm.getNumMappedSets();
        ArrayList<ArrayList<String>> memberLists = new ArrayList<ArrayList<String>>(numMappedSets);
        String[] names = new String[numMappedSets];
        for (int j = 0; j < numMappedSets; ++j) {
            GeneSet gset = mgm.getMappedGeneSet(j).getMappedGeneSet(true);
            ArrayList<String> members = new ArrayList<String>(gset.getMembersS());
            Collections.sort(members);
            memberLists.add(members);
            names[j] = gset.getName();
        }
        GeneSet[] gsets = new GeneSet[numMappedSets];
        for (int i = 0; i < numMappedSets; ++i) {
            gsets[i] = new GeneSet(AuxUtils.getAuxNameOnlyNoHash(names[i]), null, (List)memberLists.get(i), false);
        }
        Arrays.sort(gsets, ComparatorFactory.PERSISTENT_OBJECT_BY_NAME);
        return new DefaultGeneSetMatrix(name, gsets);
    }

    public Chip2ChipMapper(Chip targetChip) {
        if (targetChip == null) {
            throw new IllegalArgumentException("Param targetChip cannot be null");
        }
        System.out.println("##### target: " + targetChip.getName());
        this.fTargetChip = targetChip;
        super.initialize(this.fTargetChip.getName());
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public Chip getTargetChip() {
        return this.fTargetChip;
    }

    public Set<String> map(String sourceMember) throws Exception {
        Set<String> probeNames;
        HashSet<String> targetProbeNames = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)sourceMember) && (probeNames = this.fTargetChip.getProbeNames(sourceMember)) != null) {
            targetProbeNames.addAll(probeNames);
        }
        return targetProbeNames;
    }

    public MGeneSetMatrix map(GeneSetMatrix sourceGm, boolean maintainEtiology) throws Exception {
        return new MGeneSetMatrix(sourceGm, maintainEtiology, this.fTargetChip, this);
    }
}

