/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.annotation.SparseClassVectorListener;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.PixelConverter;

public class FeatureAnnotatorPanel
extends JPanel {
    private SparseClassVector classVector;
    private int widthPerClass = 6;
    private PixelConverter pixelConverter;
    private IExpressionData data;
    private int rowSize;
    private int numAnnotations = 0;

    public FeatureAnnotatorPanel(SparseClassVector _classVector, IExpressionData _data, int rowSize, final JComponent c) {
        this.setBackground(Color.WHITE);
        this.classVector = _classVector;
        this.data = _data;
        this.rowSize = rowSize;
        this.classVector.addListener(new SparseClassVectorListener(){

            @Override
            public void classChanged() {
                FeatureAnnotatorPanel.this.numAnnotations = 0;
                for (int i = 0; i < FeatureAnnotatorPanel.this.data.getRowCount(); ++i) {
                    List classNumbers = FeatureAnnotatorPanel.this.classVector.getClassNumbers(i);
                    if (classNumbers == null) continue;
                    FeatureAnnotatorPanel.this.numAnnotations = Math.max(classNumbers.size(), FeatureAnnotatorPanel.this.numAnnotations);
                }
                c.invalidate();
                c.validate();
                c.doLayout();
                Container a = c.getTopLevelAncestor();
                ((Component)a).invalidate();
                ((Component)a).validate();
                ((Component)a).doLayout();
                FeatureAnnotatorPanel.this.repaint();
            }
        });
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.setRowSize(rowSize);
    }

    public void setRowSize(int i) {
        this.rowSize = i;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.numAnnotations * this.widthPerClass + (this.numAnnotations + 1) * 2, this.data.getRowCount() * this.rowSize);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = g.getClipBounds();
        int top = this.pixelConverter.getTopIndex(bounds.y);
        int bottom = this.pixelConverter.getBottomIndex(bounds.y + bounds.height, this.data.getRowCount());
        for (int i = top; i < bottom; ++i) {
            List classNumbers = this.classVector.getClassNumbers(i);
            if (classNumbers == null) continue;
            int xStart = 2;
            for (int j = 0; j < classNumbers.size(); ++j) {
                Integer classNumber = (Integer)classNumbers.get(j);
                g.setColor(this.classVector.getColor(classNumber));
                g.fillRect(xStart, i * this.rowSize, this.widthPerClass, this.rowSize);
                xStart += this.widthPerClass + 2;
            }
        }
    }
}

