/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.module;

import edu.mit.broad.genome.utils.ParseException;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JOptionPane;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.io.FeatureListReader;
import org.genepattern.io.expr.IExpressionDataWriter;
import org.genepattern.io.expr.cls.ClsReader;
import org.genepattern.io.expr.gct.GctWriter;
import org.genepattern.io.expr.res.ResWriter;

public class VisualizerUtil {
    public static ClsReader clsReader = new ClsReader();
    private static FeatureListReader featureListReader = new FeatureListReader();
    private static GctWriter gctWriter = new GctWriter();
    public static ResWriter resWriter = new ResWriter();

    private VisualizerUtil() {
    }

    public static ClassVector readCls(Component parentComponent, String pathname) {
        try {
            return clsReader.read(pathname);
        }
        catch (ParseException | IOException e) {
            VisualizerUtil.fileOperationError("An error occured while reading the file ", e, parentComponent, pathname);
            return null;
        }
    }

    public static List<String> readFeatureList(Component parentComponent, String pathname) {
        try {
            return featureListReader.read(pathname);
        }
        catch (IOException e) {
            VisualizerUtil.fileOperationError("An error occured while reading the file ", e, parentComponent, pathname);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String write(Component parentComponent, IExpressionData data, String formatName, String pathname, boolean checkFileExtension) {
        try {
            String modPathname = pathname;
            IExpressionDataWriter writer = VisualizerUtil.getWriterForFormat(formatName);
            if (checkFileExtension) {
                modPathname = writer.checkFileExtension(modPathname);
            }
            try (OutputStream os = null;){
                os = new BufferedOutputStream(new FileOutputStream(modPathname));
                writer.write(data, os);
            }
            return modPathname;
        }
        catch (IOException ioe) {
            VisualizerUtil.fileOperationError("An error occured while attempting to save the file ", ioe, parentComponent, pathname);
            return null;
        }
    }

    private static void fileOperationError(String baseMsg, Exception e, Component parentComponent, String pathname) {
        String name = new File(pathname).getName().replaceFirst("Axis[0-9]*axis_", "");
        String message = baseMsg + name + ".";
        String exceptionMessage = e.getMessage();
        if (exceptionMessage != null) {
            message = message + "\nCause: " + exceptionMessage;
        }
        JOptionPane.showMessageDialog(parentComponent, message, "Error", 0);
    }

    private static IExpressionDataWriter getWriterForFormat(String formatName) throws IOException {
        if ("gct".equalsIgnoreCase(formatName)) {
            return gctWriter;
        }
        if ("res".equalsIgnoreCase(formatName)) {
            return resWriter;
        }
        throw new IOException("No writer to save the data in " + formatName + " format.");
    }
}

