/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import java.io.File;
import org.apache.ecs.Element;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.UL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBlocks {
    private static final Logger klog = LoggerFactory.getLogger(ReportBlocks.class);

    public static class SimpleBlockListing {
        private ToolReport fReport;
        private Div fDiv;
        private UL fUl;
        private boolean fClosed;

        public SimpleBlockListing(String title, ToolReport report) {
            if (report == null) {
                throw new IllegalArgumentException("Param report cannot be null");
            }
            this.fReport = report;
            this.fDiv = new Div();
            H4 h4 = new H4(title);
            this.fDiv.addElement((Element)h4);
            this.fUl = new UL();
        }

        public void add(String hyperLinkThisTerm, File file) {
            if (this.fClosed) {
                klog.warn("Already closed for: {} {}", (Object)hyperLinkThisTerm, (Object)file);
            }
            this.fUl.addElement((Element)new LI((Element)HtmlFormat.Links.hyper(hyperLinkThisTerm, file, "", this.fReport.getReportDir())));
        }

        public void close() {
            if (this.fClosed) {
                return;
            }
            this.fDiv.addElement((Element)this.fUl);
            this.fReport.getIndexPage().addBlock(this.fDiv, false);
            this.fClosed = true;
        }
    }
}

