/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.xchoosers.TemplateChooserUI;
import edu.mit.broad.xbench.xchoosers.TemplateSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import xtools.api.param.ParamHelper;
import xtools.api.param.StringMultiChooserParam;

public class TemplateSingleChooserParam
extends StringMultiChooserParam
implements ActionListener {
    protected TemplateMode fMode;
    private TemplateChooserUI fTemplateChooser;
    private TemplateSelection fCurrBag;

    public TemplateSingleChooserParam(String name, String nameEnglish, TemplateMode mode, boolean reqd) {
        super(name, nameEnglish, "Phenotype labels for the samples in the expression dataset (cls file)", new String[0], new String[0], reqd);
        this.fMode = mode;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        return this._getSelectionComponent();
    }

    public Template getTemplate() throws Exception {
        return this._getTemplates(null)[0];
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    protected GFieldPlusChooser _getSelectionComponent() {
        if (this.fTemplateChooser == null) {
            this.fTemplateChooser = new TemplateChooserUI(false, this.fMode);
            this.fChooser = new TemplateChooserUI.Field(this);
            this.fChooser.setValue(this.getValueStringRepresentation(true));
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            TemplateSelection bag = this.fTemplateChooser.showChooser(this.fCurrBag);
            if (bag != null) {
                this.fChooser.setText(bag.formatForUI());
            }
            this.fCurrBag = bag;
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Could not query Phenotypes", t);
        }
    }

    private Template[] _getGeneTemplates(String[] ss, Dataset ds) {
        if (ss == null || ss.length == 0) {
            return null;
        }
        try {
            ds.getRowIndex(ss[0]);
            Template[] tss = new Template[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                tss[i] = TemplateFactory.createContinuousTemplate(ss[i], ds);
            }
            return tss;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Template[] _getTemplates(Dataset dsOptX) throws Exception {
        Object[] ss = this.getStrings();
        Printf.out(ss);
        Template[] nn_ts = this._getGeneTemplates((String[])ss, dsOptX);
        if (nn_ts != null) {
            return nn_ts;
        }
        if (ss.length == 0) {
            throw new IllegalArgumentException("No templates specified.  Please load a CLS file and choose the phenotype labels.");
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        Template currMainTemplate = null;
        for (int i = 0; i < ss.length; ++i) {
            if (!this._isPath((String)ss[i])) {
                currMainTemplate = this._getSourceTemplate((String)ss[i], currMainTemplate);
                String auxname = AuxUtils.getAuxNameOnlyNoHash((String)ss[i]);
                this.log.debug("parsing: " + (String)ss[i] + "< and i got auxname>" + auxname + "< currMaintemplate: " + currMainTemplate.getName());
                if (auxname.equals("OVA")) {
                    throw new IllegalArgumentException("Invalid Template option: " + auxname + " multiple templates not allowed in this usage");
                }
                if (auxname.equals("FOVA")) {
                    throw new IllegalArgumentException("Invalid Template option: " + auxname + " multiple templates not allowed in this usage");
                }
                if (auxname.equals("ALL_PAIRS")) {
                    throw new IllegalArgumentException("Invalid Template option: " + auxname + " multiple templates not allowed in this usage");
                }
                File file = ParserFactory.getCache().getSourceFile(currMainTemplate);
                file = AuxUtils.getBaseFileFromAuxFile(file);
                Template t = ParserFactory.readTemplate(new File(file.getPath() + "#" + auxname));
                templates.add(t);
                continue;
            }
            Template t = ParserFactory.readTemplate(new File((String)ss[i]), true, false, true);
            templates.add(t);
            currMainTemplate = t;
        }
        return templates.toArray(new Template[templates.size()]);
    }

    private boolean _isPath(String pathOrName) {
        return pathOrName.indexOf(File.separator) >= 0;
    }

    private Template _getSourceTemplate(String pathOrName, Template currTemplate) throws Exception {
        if (pathOrName.indexOf(File.separatorChar) == -1) {
            if (currTemplate == null) {
                return ParserFactory.readTemplate(new File(SystemUtils.getPwd(), pathOrName));
            }
            return currTemplate;
        }
        return ParserFactory.readTemplate(new File(pathOrName));
    }
}

