/*  $Id: accguide2.inc 665251 2023-03-31 12:37:11Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Aaron Ucko
 *
 * File Description:
 *   Built-in copy of accguide2.txt.
 *
 */

/* time_t value corresponding to Wed Mar 29 13:00:53 EDT 2023; formally
 * expressed as unsigned long so output can stand fully on its own. */
static const unsigned long kBuiltInGuide_Timestamp = 1680109253UL;
static const char* const kBuiltInGuide[] = {
    "# $Id: accguide2.inc 665251 2023-03-31 12:37:11Z ivanov $",
    "version  2 # of file format",
    "",
    "# three-letter-prefix protein accessions (traditionally with five digits)",
    "3+5  AAE  gb_patent_prot",
    "3+5  ??_  unknown # Longer variants (6-9 digits as of June 2018) are RefSeq",
    "3+5  A??  gb_prot",
    "3+7  A??  gb_prot",
    "3+9  A??  gb_prot",
    "3+11 A??  gb_prot",
    "3+5  B??  ddbj_prot",
    "3+7  B??  ddbj_prot",
    "3+9  B??  ddbj_prot",
    "3+11 B??  ddbj_prot",
    "3+5  C??  embl_prot *",
    "3+7  C??  embl_prot *",
    "3+9  C??  embl_prot",
    "3+11 C??  embl_prot",
    "3+5  D??  gb_tpa_prot *",
    "3+7  D??  gb_tpa_prot",
    "3+9  D??  gb_tpa_prot",
    "3+11 D??  gb_tpa_prot",
    "3+5  E??  gb_wgs_prot",
    "3+7  E??  gb_wgsv_prot",
    "3+9  E??  gb_prot",
    "3+11 E??  gb_prot",
    "3+5  F??  ddbj_tpa_prot",
    "3+7  F??  ddbj_tpa_prot",
    "3+9  F??  ddbj_tpa_prot",
    "3+11 F??  ddbj_tpa_prot",
    "3+5  G??  ddbj_wgs_prot",
    "3+7  G??  ddbj_prot",
    "3+9  G??  ddbj_prot",
    "3+11 G??  ddbj_prot",
    "3+5  H??  gb_tpa_wgsv_prot",
    "3+7  H??  gb_tpa_wgsv_prot",
    "3+9  H??  gb_tpa_prot",
    "3+11 H??  gb_tpa_prot",
    "3+5  I??  ddbj_tpa_wgs_prot",
    "3+7  I??  ddbj_tpa_prot",
    "3+9  I??  ddbj_tpa_prot",
    "3+11 I??  ddbj_tpa_prot",
    "3+5  J??  gb_tsa_prot",
    "3+7  J??  gb_prot",
    "3+9  J??  gb_prot",
    "3+11 J??  gb_prot",
    "3+5  K??  gb_wgs_prot",
    "3+7  K??  gb_wgs_prot",
    "3+9  K??  gb_prot",
    "3+11 K??  gb_prot",
    "3+5  L??  ddbj_prot # mixed TSA and TLS",
    "3+7  L??  ddbj_prot",
    "3+9  L??  ddbj_prot",
    "3+11 L??  ddbj_prot",
    "3+5  M??  gb_wgsv_prot",
    "3+7  M??  gb_wgsv_prot",
    "3+9  M??  gb_prot",
    "3+11 M??  gb_prot",
    "3+5  N??  gb_wgsv_prot",
    "3+7  N??  gb_wgsv_prot",
    "3+9  N??  gb_prot",
    "3+11 N??  gb_prot",
    "3+5  O??  gb_wgs_prot",
    "3+7  O??  gb_prot",
    "3+9  O??  gb_prot",
    "3+11 O??  gb_prot",
    "3+5  P??  gb_wgs_prot",
    "3+7  P??  gb_prot",
    "3+9  P??  gb_prot",
    "3+11 P??  gb_prot",
    "3+5  Q??  gb_prot",
    "3+7  Q??  gb_prot",
    "3+9  Q??  gb_prot",
    "3+11 Q??  gb_prot",
    "3+5  R??  gb_wgs_prot",
    "3+7  R??  gb_prot",
    "3+9  R??  gb_prot",
    "3+11 R??  gb_prot",
    "3+5  S??  embl_prot *",
    "3+7  S??  embl_prot",
    "3+9  S??  embl_prot",
    "3+11 S??  embl_prot",
    "3+5  T??  gb_wgs_prot",
    "3+7  T??  gb_prot",
    "3+9  T??  gb_prot",
    "3+11 T??  gb_prot",
    "3+5  U??  gb_prot",
    "3+7  U??  gb_prot",
    "3+9  U??  gb_prot",
    "3+11 U??  gb_prot",
    "3+5  V??  embl_prot *",
    "3+7  V??  embl_prot",
    "3+9  V??  embl_prot",
    "3+11 V??  embl_prot",
    "3+5  W??  gb_prot",
    "3+7  W??  gb_prot",
    "3+9  W??  gb_prot",
    "3+11 W??  gb_prot",
    "3+5  ???  unreserved_prot",
    "3+7  ???  unreserved_prot",
    "3+9  ???  unreserved_prot",
    "3+11 ???  unreserved_prot",
    "",
    "# Genome pipeline accessions",
    "4+9  GPC_  gpipe_chromosome",
    "4+9  GPG_  gpipe_genomic",
    "4+9  GPM_  gpipe_mrna",
    "4+9  GPN_  gpipe_other_nuc",
    "4+9  GPP_  gpipe_prot",
    "4+9  GPR_  gpipe_ncrna",
    "4+9  GPS_  gpipe_scaffold",
    "4+9  ZPC_  gpipe_chromosome",
    "4+9  ZPG_  gpipe_genomic",
    "4+9  ZPM_  gpipe_mrna",
    "4+9  ZPN_  gpipe_other_nuc",
    "4+9  ZPP_  gpipe_prot",
    "4+9  ZPR_  gpipe_ncrna",
    "4+9  ZPS_  gpipe_scaffold",
    "4+9  GP?_  gpipe_unreserved",
    "4+9  ZP?_  gpipe_unreserved",
    "",
    "# whole genome shotgun accessions",
    "4+8   ???_    unknown",
    "4+9   ???_    unknown",
    "4+10  ???_    unknown",
    "4+8   A???    gb_wgs_nuc",
    "4+9   A???    gb_wgs_nuc",
    "4+10  A???    gb_wgs_nuc",
    "4+8   B???    ddbj_wgs_nuc",
    "4+9   B???    ddbj_wgs_nuc",
    "4+10  B???    ddbj_wgs_nuc",
    "4+8   C???    embl_wgs_nuc",
    "4+9   C???    embl_wgs_nuc",
    "4+10  C???    embl_wgs_nuc",
    "4+8   D???    gb_tpa_wgs_nuc",
    "4+9   D???    gb_tpa_wgs_nuc",
    "4+10  D???    gb_tpa_wgs_nuc",
    "4+8   E???    ddbj_tpa_wgs_nuc",
    "4+9   E???    ddbj_tpa_wgs_nuc",
    "4+10  E???    ddbj_tpa_wgs_nuc",
    "4+8   F???    embl_wgs_nuc",
    "4+9   F???    embl_wgs_nuc",
    "4+10  F???    embl_wgs_nuc",
    "4+8   G???    gb_tsa_nuc",
    "4+9   G???    gb_tsa_nuc",
    "4+10  G???    gb_tsa_nuc",
    "4+8   H???    embl_tsa_nuc *",
    "4+9   H???    embl_tsa_nuc",
    "4+10  H???    embl_tsa_nuc",
    "4+8   I???    ddbj_tsa_nuc",
    "4+9   I???    ddbj_tsa_nuc",
    "4+10  I???    ddbj_tsa_nuc",
    "4+8   J???    gb_wgs_nuc",
    "4+9   J???    gb_wgs_nuc",
    "4+10  J???    gb_wgs_nuc",
    "4+8   K???    gb_targeted_nuc",
    "4+9   K???    gb_targeted_nuc",
    "4+10  K???    gb_targeted_nuc",
    "4+8   L???    gb_wgs_nuc",
    "4+9   L???    gb_wgs_nuc",
    "4+10  L???    gb_wgs_nuc",
    "4+8   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   O???    embl_wgs_nuc",
    "4+9   O???    embl_wgs_nuc",
    "4+10  O???    embl_wgs_nuc",
    "4+8   P???    gb_wgs_nuc",
    "4+9   P???    gb_wgs_nuc",
    "4+10  P???    gb_wgs_nuc",
    "4+8   Q???    gb_wgs_nuc",
    "4+9   Q???    gb_wgs_nuc",
    "4+10  Q???    gb_wgs_nuc",
    "4+8   R???    gb_wgs_nuc",
    "4+9   R???    gb_wgs_nuc",
    "4+10  R???    gb_wgs_nuc",
    "4+8   S???    gb_wgs_nuc",
    "4+9   S???    gb_wgs_nuc",
    "4+10  S???    gb_wgs_nuc",
    "4+8   T???    ddbj_targeted_nuc",
    "4+9   T???    ddbj_targeted_nuc",
    "4+10  T???    ddbj_targeted_nuc",
    "4+8   U???    embl_wgs_nuc",
    "4+9   U???    embl_wgs_nuc",
    "4+10  U???    embl_wgs_nuc",
    "4+8   V???    gb_wgs_nuc",
    "4+9   V???    gb_wgs_nuc",
    "4+10  V???    gb_wgs_nuc",
    "4+8   W???    gb_wgs_nuc",
    "4+9   W???    gb_wgs_nuc",
    "4+10  W???    gb_wgs_nuc",
    "4+8   X???    gb_wgs_nuc",
    "4+9   X???    gb_wgs_nuc",
    "4+10  X???    gb_wgs_nuc",
    "4+8   Y???    ddbj_tpa_tsa_nuc",
    "4+9   Y???    ddbj_tpa_tsa_nuc",
    "4+10  Y???    ddbj_tpa_tsa_nuc",
    "4+8   Z???    ddbj_tpa_targeted_nuc",
    "4+9   Z???    ddbj_tpa_targeted_nuc",
    "4+10  Z???    ddbj_tpa_targeted_nuc",
    "4+8   ????    unreserved_nuc",
    "4+9   ????    unreserved_nuc",
    "4+10  ????    unreserved_nuc",
    "6+9   ?????_  unknown",
    "6+10  ?????_  unknown",
    "6+11  ?????_  unknown",
    "6+9   A?????  gb_wgs_nuc",
    "6+10  A?????  gb_wgs_nuc",
    "6+11  A?????  gb_wgs_nuc",
    "6+9   B?????  ddbj_wgs_nuc",
    "6+10  B?????  ddbj_wgs_nuc",
    "6+11  B?????  ddbj_wgs_nuc",
    "6+9   C?????  embl_wgs_nuc *",
    "6+10  C?????  embl_wgs_nuc",
    "6+11  C?????  embl_wgs_nuc",
    "6+9   D?????  gb_tpa_wgs_nuc",
    "6+10  D?????  gb_tpa_wgs_nuc",
    "6+11  D?????  gb_tpa_wgs_nuc",
    "6+9   J?????  gb_wgs_nuc",
    "6+10  J?????  gb_wgs_nuc",
    "6+11  J?????  gb_wgs_nuc",
    "6+9   ??????  unreserved_nuc",
    "6+10  ??????  unreserved_nuc",
    "6+11  ??????  unreserved_nuc",
    "",
    "# Mass sequence Genome for Annotation",
    "5+7   A???? ddbj_other_nuc",
    "5+7   A???? ddbj_mga",
    "",
    "# Named annotation track (new as of September 2008)",
    "3+9  AT_  named_annot_track",
    "",
    "# NCBI reference sequence accessions",
    "3+6  AC_      refseq_chromosome",
    "3+6  AP_      refseq_prot",
    "3+6  NC_      refseq_chromosome",
    "3+6  NG_      refseq_genomic",
    "3+6  NM_      refseq_mrna",
    "3+9  NM_      refseq_mrna",
    "3+6  NP_      refseq_prot",
    "3+9  NP_      refseq_prot",
    "3+6  NR_      refseq_ncrna",
    "3+6  NS_      refseq_genome",
    "3+6  NT_      refseq_contig",
    "3+6  NW_      refseq_wgs_intermed",
    "3+9  NW_      refseq_wgs_intermed",
    "4+5  NZ_?     refseq_contig",
    "5+6  NZ_??    refseq_contig",
    "7+8  NZ_????  refseq_wgs_nuc",
    "7+9  NZ_????  refseq_wgs_nuc",
    "7+10 NZ_????  refseq_wgs_nuc",
    "9+9  NZ_?????? refseq_wgs_nuc",
    "9+10 NZ_?????? refseq_wgs_nuc",
    "9+11 NZ_?????? refseq_wgs_nuc",
    "3+9  WC_      refseq_chromosome_ncbo",
    "3+9  WP_      refseq_unique_prot",
    "3+9  WT_      refseq_contig_ncbo",
    "3+6  XM_      refseq_mrna_predicted",
    "3+9  XM_      refseq_mrna_predicted",
    "3+6  XP_      refseq_prot_predicted",
    "3+9  XP_      refseq_prot_predicted",
    "3+6  XR_      refseq_ncrna_predicted",
    "3+9  XR_      refseq_ncrna_predicted",
    "3+6  YP_      refseq_prot_predicted",
    "3+9  YP_      refseq_prot_predicted",
    "3+8  ZP_      refseq_wgs_prot",
    "3+6  ??_      refseq_unreserved",
    "3+7  ??_      refseq_unreserved",
    "3+8  ??_      refseq_unreserved",
    "3+9  ??_      refseq_unreserved",
    "",
    "# Unusually structured GenBank accessions",
    "4+6  MAP_  gb_optical_map",
    "",
    "# 6-character accessions (mixed, but generally nucleotide)",
    "1+5  A  embl_patent",
    "1+5  B  gb_gss",
    "1+5  C  ddbj_est *",
    "1+5  D  ddbj_dirsub *",
    "1+5  E  ddbj_patent",
    "1+5  F  embl_est *",
    "1+5  G  gb_sts",
    "1+5  H  gb_est",
    "1+5  I  gb_patent",
    "1+5  J  gsdb_dirsub",
    "1+5  K  gsdb_dirsub",
    "1+5  L  gsdb_dirsub *",
    "1+5  M  gsdb_dirsub *",
    "1+5  N  unreserved_nuc *",
    "1+5  O  swissprot",
    "1+5  P  swissprot",
    "1+5  Q  swissprot",
    "1+5  R  gb_est",
    "1+5  S  gb_backbone",
    "1+5  T  gb_est *",
    "1+5  U  gb_dirsub *",
    "1+5  V  embl_dirsub",
    "1+5  W  gb_est",
    "1+5  X  embl_dirsub *",
    "1+5  Y  embl_dirsub *",
    "1+5  Z  embl_dirsub *",
    "1+5  ?  unreserved_nuc",
    "",
    "# two-letter-prefix nucleotide accessions (traditionally with six digits)",
    "2+6  AA  gb_est",
    "2+8  AA  gb_other_nuc",
    "2+10 AA  gb_other_nuc",
    "2+6  AB  ddbj_dirsub *",
    "2+8  AB  ddbj_other_nuc",
    "2+10 AB  ddbj_other_nuc",
    "2+6  AC  gb_htgs",
    "2+8  AC  gb_other_nuc",
    "2+10 AC  gb_other_nuc",
    "2+6  AD  gb_gsdb",
    "2+8  AD  gb_other_nuc",
    "2+10 AD  gb_other_nuc",
    "2+6  AE  gb_genome",
    "2+8  AE  gb_other_nuc",
    "2+10 AE  gb_other_nuc",
    "2+6  AF  gb_dirsub *",
    "2+8  AF  gb_other_nuc",
    "2+10 AF  gb_other_nuc",
    "2+6  AG  ddbj_gss *",
    "2+8  AG  ddbj_other_nuc",
    "2+10 AG  ddbj_other_nuc",
    "2+6  AH  gb_segset",
    "2+8  AH  gb_other_nuc",
    "2+10 AH  gb_other_nuc",
    "2+6  AI  gb_est",
    "2+8  AI  gb_other_nuc",
    "2+10 AI  gb_other_nuc",
    "2+6  AJ  embl_dirsub *",
    "2+8  AJ  embl_other_nuc",
    "2+10 AJ  embl_other_nuc",
    "2+6  AK  ddbj_mrna",
    "2+8  AK  ddbj_other_nuc",
    "2+10 AK  ddbj_other_nuc",
    "2+6  AL  embl_dirsub *",
    "2+8  AL  embl_other_nuc",
    "2+10 AL  embl_other_nuc",
    "2+6  AM  embl_dirsub *",
    "2+8  AM  embl_other_nuc",
    "2+10 AM  embl_other_nuc",
    "2+6  AN  embl_con",
    "2+8  AN  embl_other_nuc",
    "2+10 AN  embl_other_nuc",
    "2+6  AO  unreserved_nuc",
    "2+8  AO  unreserved_nuc",
    "2+10 AO  unreserved_nuc",
    "2+6  AP  ddbj_genome",
    "2+8  AP  ddbj_other_nuc",
    "2+10 AP  ddbj_other_nuc",
    "2+6  AQ  gb_gss",
    "2+8  AQ  gb_other_nuc",
    "2+10 AQ  gb_other_nuc",
    "2+6  AR  gb_patent",
    "2+8  AR  gb_other_nuc",
    "2+10 AR  gb_other_nuc",
    "2+6  AS  gb_other_nuc",
    "2+8  AS  gb_other_nuc",
    "2+10 AS  gb_other_nuc",
    "2+6  AT  ddbj_est",
    "2+8  AT  ddbj_other_nuc",
    "2+10 AT  ddbj_other_nuc",
    "2+6  AU  ddbj_est *",
    "2+8  AU  ddbj_other_nuc",
    "2+10 AU  ddbj_other_nuc",
    "2+6  AV  ddbj_est",
    "2+8  AV  ddbj_other_nuc",
    "2+10 AV  ddbj_other_nuc",
    "2+6  AW  gb_est",
    "2+8  AW  gb_other_nuc",
    "2+10 AW  gb_other_nuc",
    "2+6  AX  embl_patent *",
    "2+8  AX  embl_other_nuc",
    "2+10 AX  embl_other_nuc",
    "2+6  AY  gb_dirsub *",
    "2+8  AY  gb_other_nuc",
    "2+10 AY  gb_other_nuc",
    "2+6  AZ  gb_gss",
    "2+8  AZ  gb_other_nuc",
    "2+10 AZ  gb_other_nuc",
    "2+6  BA  ddbj_con",
    "2+8  BA  ddbj_other_nuc",
    "2+10 BA  ddbj_other_nuc",
    "2+6  BB  ddbj_est",
    "2+8  BB  ddbj_other_nuc",
    "2+10 BB  ddbj_other_nuc",
    "2+6  BC  gb_cdna",
    "2+8  BC  gb_other_nuc",
    "2+10 BC  gb_other_nuc",
    "2+6  BD  ddbj_patent",
    "2+8  BD  ddbj_other_nuc",
    "2+10 BD  ddbj_other_nuc",
    "2+6  BE  gb_est",
    "2+8  BE  gb_other_nuc",
    "2+10 BE  gb_other_nuc",
    "2+6  BF  gb_est",
    "2+8  BF  gb_other_nuc",
    "2+10 BF  gb_other_nuc",
    "2+6  BG  gb_est",
    "2+8  BG  gb_other_nuc",
    "2+10 BG  gb_other_nuc",
    "2+6  BH  gb_gss",
    "2+8  BH  gb_other_nuc",
    "2+10 BH  gb_other_nuc",
    "2+6  BI  gb_est",
    "2+8  BI  gb_other_nuc",
    "2+10 BI  gb_other_nuc",
    "2+6  BJ  ddbj_est",
    "2+8  BJ  ddbj_other_nuc",
    "2+10 BJ  ddbj_other_nuc",
    "2+6  BK  gb_tpa_nuc",
    "2+8  BK  gb_tpa_nuc",
    "2+10 BK  gb_tpa_nuc",
    "2+6  BL  gb_tpa_segset # Formally CON but not necessarily genomic",
    "2+8  BL  gb_tpa_nuc",
    "2+10 BL  gb_tpa_nuc",
    "2+6  BM  gb_est",
    "2+8  BM  gb_other_nuc",
    "2+10 BM  gb_other_nuc",
    "2+6  BN  embl_tpa_nuc",
    "2+8  BN  embl_tpa_nuc",
    "2+10 BN  embl_tpa_nuc",
    "2+6  BO  unreserved_nuc",
    "2+8  BO  unreserved_nuc",
    "2+10 BO  unreserved_nuc",
    "2+6  BP  ddbj_est",
    "2+8  BP  ddbj_other_nuc",
    "2+10 BP  ddbj_other_nuc",
    "2+6  BQ  gb_est",
    "2+8  BQ  gb_other_nuc",
    "2+10 BQ  gb_other_nuc",
    "2+6  BR  ddbj_tpa_nuc",
    "2+8  BR  ddbj_tpa_nuc",
    "2+10 BR  ddbj_tpa_nuc",
    "2+6  BS  ddbj_genome # chimp genomes, specifically",
    "2+8  BS  ddbj_other_nuc",
    "2+10 BS  ddbj_other_nuc",
    "2+6  BT  gb_cdna",
    "2+8  BT  gb_other_nuc",
    "2+10 BT  gb_other_nuc",
    "2+6  BU  gb_est",
    "2+8  BU  gb_other_nuc",
    "2+10 BU  gb_other_nuc",
    "2+6  BV  gb_sts",
    "2+8  BV  gb_other_nuc",
    "2+10 BV  gb_other_nuc",
    "2+6  BW  ddbj_est",
    "2+8  BW  ddbj_other_nuc",
    "2+10 BW  ddbj_other_nuc",
    "2+6  BX  embl_dirsub *",
    "2+8  BX  embl_other_nuc",
    "2+10 BX  embl_other_nuc",
    "2+6  BY  ddbj_est",
    "2+8  BY  ddbj_other_nuc",
    "2+10 BY  ddbj_other_nuc",
    "2+6  BZ  gb_gss",
    "2+8  BZ  gb_other_nuc",
    "2+10 BZ  gb_other_nuc",
    "2+6  CA  gb_est",
    "2+8  CA  gb_other_nuc",
    "2+10 CA  gb_other_nuc",
    "2+6  CB  gb_est",
    "2+8  CB  gb_other_nuc",
    "2+10 CB  gb_other_nuc",
    "2+6  CC  gb_gss",
    "2+8  CC  gb_other_nuc",
    "2+10 CC  gb_other_nuc",
    "2+6  CD  gb_est",
    "2+8  CD  gb_other_nuc",
    "2+10 CD  gb_other_nuc",
    "2+6  CE  gb_gss",
    "2+8  CE  gb_other_nuc",
    "2+10 CE  gb_other_nuc",
    "2+6  CF  gb_est",
    "2+8  CF  gb_other_nuc",
    "2+10 CF  gb_other_nuc",
    "2+6  CG  gb_gss",
    "2+8  CG  gb_other_nuc",
    "2+10 CG  gb_other_nuc",
    "2+6  CH  gb_con",
    "2+8  CH  gb_other_nuc",
    "2+10 CH  gb_other_nuc",
    "2+6  CI  ddbj_est",
    "2+8  CI  ddbj_other_nuc",
    "2+10 CI  ddbj_other_nuc",
    "2+6  CJ  ddbj_est",
    "2+8  CJ  ddbj_other_nuc",
    "2+10 CJ  ddbj_other_nuc",
    "2+6  CK  gb_est",
    "2+8  CK  gb_other_nuc",
    "2+10 CK  gb_other_nuc",
    "2+6  CL  gb_gss",
    "2+8  CL  gb_other_nuc",
    "2+10 CL  gb_other_nuc",
    "2+6  CM  gb_chromosome",
    "2+8  CM  gb_other_nuc",
    "2+10 CM  gb_other_nuc",
    "2+6  CN  gb_est",
    "2+8  CN  gb_other_nuc",
    "2+10 CN  gb_other_nuc",
    "2+6  CO  gb_est",
    "2+8  CO  gb_other_nuc",
    "2+10 CO  gb_other_nuc",
    "2+6  CP  gb_genome *",
    "2+8  CP  gb_other_nuc",
    "2+10 CP  gb_other_nuc",
    "2+6  CQ  embl_patent",
    "2+8  CQ  embl_other_nuc",
    "2+10 CQ  embl_other_nuc",
    "2+6  CR  embl_dirsub *",
    "2+8  CR  embl_other_nuc",
    "2+10 CR  embl_other_nuc",
    "2+6  CS  embl_patent",
    "2+8  CS  embl_other_nuc",
    "2+10 CS  embl_other_nuc",
    "2+6  CT  embl_dirsub *",
    "2+8  CT  embl_other_nuc",
    "2+10 CT  embl_other_nuc",
    "2+6  CU  embl_dirsub *",
    "2+8  CU  embl_other_nuc",
    "2+10 CU  embl_other_nuc",
    "2+6  CV  gb_est",
    "2+8  CV  gb_other_nuc",
    "2+10 CV  gb_other_nuc",
    "2+6  CW  gb_gss",
    "2+8  CW  gb_other_nuc",
    "2+10 CW  gb_other_nuc",
    "2+6  CX  gb_est",
    "2+8  CX  gb_other_nuc",
    "2+10 CX  gb_other_nuc",
    "2+6  CY  gb_genome",
    "2+8  CY  gb_other_nuc",
    "2+10 CY  gb_other_nuc",
    "2+6  CZ  gb_gss",
    "2+8  CZ  gb_other_nuc",
    "2+10 CZ  gb_other_nuc",
    "2+6  DA  ddbj_est",
    "2+8  DA  ddbj_other_nuc",
    "2+10 DA  ddbj_other_nuc",
    "2+6  DB  ddbj_est",
    "2+8  DB  ddbj_other_nuc",
    "2+10 DB  ddbj_other_nuc",
    "2+6  DC  ddbj_est",
    "2+8  DC  ddbj_other_nuc",
    "2+10 DC  ddbj_other_nuc",
    "2+6  DD  ddbj_patent",
    "2+8  DD  ddbj_other_nuc",
    "2+10 DD  ddbj_other_nuc",
    "2+6  DE  ddbj_gss *",
    "2+8  DE  ddbj_other_nuc",
    "2+10 DE  ddbj_other_nuc",
    "2+6  DF  ddbj_con",
    "2+8  DF  ddbj_other_nuc",
    "2+10 DF  ddbj_other_nuc",
    "2+6  DG  ddbj_con",
    "2+8  DG  ddbj_other_nuc",
    "2+10 DG  ddbj_other_nuc",
    "2+6  DH  ddbj_gss",
    "2+8  DH  ddbj_other_nuc",
    "2+10 DH  ddbj_other_nuc",
    "2+6  DI  ddbj_patent # from Korea",
    "2+8  DI  ddbj_other_nuc",
    "2+10 DI  ddbj_other_nuc",
    "2+6  DJ  ddbj_patent",
    "2+8  DJ  ddbj_other_nuc",
    "2+10 DJ  ddbj_other_nuc",
    "2+6  DK  ddbj_est",
    "2+8  DK  ddbj_other_nuc",
    "2+10 DK  ddbj_other_nuc",
    "2+6  DL  ddbj_patent",
    "2+8  DL  ddbj_other_nuc",
    "2+10 DL  ddbj_other_nuc",
    "2+6  DM  ddbj_patent",
    "2+8  DM  ddbj_other_nuc",
    "2+10 DM  ddbj_other_nuc",
    "2+6  DN  gb_est",
    "2+8  DN  gb_other_nuc",
    "2+10 DN  gb_other_nuc",
    "2+6  DO  unreserved_nuc",
    "2+8  DO  unreserved_nuc",
    "2+10 DO  unreserved_nuc",
    "2+6  DP  gb_htgs # HTG scaffolds; look like gb_con, but built on htgs parts",
    "2+8  DP  gb_other_nuc",
    "2+10 DP  gb_other_nuc",
    "2+6  DQ  gb_dirsub *",
    "2+8  DQ  gb_other_nuc",
    "2+10 DQ  gb_other_nuc",
    "2+6  DR  gb_est",
    "2+8  DR  gb_other_nuc",
    "2+10 DR  gb_other_nuc",
    "2+6  DS  gb_con *",
    "2+8  DS  gb_other_nuc",
    "2+10 DS  gb_other_nuc",
    "2+6  DT  gb_est",
    "2+8  DT  gb_other_nuc",
    "2+10 DT  gb_other_nuc",
    "2+6  DU  gb_gss",
    "2+8  DU  gb_other_nuc",
    "2+10 DU  gb_other_nuc",
    "2+6  DV  gb_est",
    "2+8  DV  gb_other_nuc",
    "2+10 DV  gb_other_nuc",
    "2+6  DW  gb_est",
    "2+8  DW  gb_other_nuc",
    "2+10 DW  gb_other_nuc",
    "2+6  DX  gb_gss",
    "2+8  DX  gb_other_nuc",
    "2+10 DX  gb_other_nuc",
    "2+6  DY  gb_est",
    "2+8  DY  gb_other_nuc",
    "2+10 DY  gb_other_nuc",
    "2+6  DZ  gb_patent",
    "2+8  DZ  gb_other_nuc",
    "2+10 DZ  gb_other_nuc",
    "2+6  EA  gb_patent",
    "2+8  EA  gb_other_nuc",
    "2+10 EA  gb_other_nuc",
    "2+6  EB  gb_est",
    "2+8  EB  gb_other_nuc",
    "2+10 EB  gb_other_nuc",
    "2+6  EC  gb_est",
    "2+8  EC  gb_other_nuc",
    "2+10 EC  gb_other_nuc",
    "2+6  ED  gb_gss",
    "2+8  ED  gb_other_nuc",
    "2+10 ED  gb_other_nuc",
    "2+6  EE  gb_est",
    "2+8  EE  gb_other_nuc",
    "2+10 EE  gb_other_nuc",
    "2+6  EF  gb_dirsub *",
    "2+8  EF  gb_other_nuc",
    "2+10 EF  gb_other_nuc",
    "2+6  EG  gb_est",
    "2+8  EG  gb_other_nuc",
    "2+10 EG  gb_other_nuc",
    "2+6  EH  gb_est",
    "2+8  EH  gb_other_nuc",
    "2+10 EH  gb_other_nuc",
    "2+6  EI  gb_gss",
    "2+8  EI  gb_other_nuc",
    "2+10 EI  gb_other_nuc",
    "2+6  EJ  gb_gss",
    "2+8  EJ  gb_other_nuc",
    "2+10 EJ  gb_other_nuc",
    "2+6  EK  gb_gss",
    "2+8  EK  gb_other_nuc",
    "2+10 EK  gb_other_nuc",
    "2+6  EL  gb_est",
    "2+8  EL  gb_other_nuc",
    "2+10 EL  gb_other_nuc",
    "2+6  EM  gb_con",
    "2+8  EM  gb_other_nuc",
    "2+10 EM  gb_other_nuc",
    "2+6  EN  gb_con",
    "2+8  EN  gb_other_nuc",
    "2+10 EN  gb_other_nuc",
    "2+6  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+8  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+10 EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+6  EP  gb_con",
    "2+8  EP  gb_other_nuc",
    "2+10 EP  gb_other_nuc",
    "2+6  EQ  gb_con",
    "2+8  EQ  gb_other_nuc",
    "2+10 EQ  gb_other_nuc",
    "2+6  ER  gb_gss",
    "2+8  ER  gb_other_nuc",
    "2+10 ER  gb_other_nuc",
    "2+6  ES  gb_est",
    "2+8  ES  gb_other_nuc",
    "2+10 ES  gb_other_nuc",
    "2+6  ET  gb_gss",
    "2+8  ET  gb_other_nuc",
    "2+10 ET  gb_other_nuc",
    "2+6  EU  gb_dirsub *",
    "2+8  EU  gb_other_nuc",
    "2+10 EU  gb_other_nuc",
    "2+6  EV  gb_est",
    "2+8  EV  gb_other_nuc",
    "2+10 EV  gb_other_nuc",
    "2+6  EW  gb_est",
    "2+8  EW  gb_other_nuc",
    "2+10 EW  gb_other_nuc",
    "2+6  EX  gb_est",
    "2+8  EX  gb_other_nuc",
    "2+10 EX  gb_other_nuc",
    "2+6  EY  gb_est",
    "2+8  EY  gb_other_nuc",
    "2+10 EY  gb_other_nuc",
    "2+6  EZ  gb_tsa_nuc",
    "2+8  EZ  gb_other_nuc",
    "2+10 EZ  gb_other_nuc",
    "2+6  FA  gb_con",
    "2+8  FA  gb_other_nuc",
    "2+10 FA  gb_other_nuc",
    "2+6  FB  embl_patent",
    "2+8  FB  embl_other_nuc",
    "2+10 FB  embl_other_nuc",
    "2+6  FC  gb_est",
    "2+8  FC  gb_other_nuc",
    "2+10 FC  gb_other_nuc",
    "2+6  FD  gb_est",
    "2+8  FD  gb_other_nuc",
    "2+10 FD  gb_other_nuc",
    "2+6  FE  gb_est",
    "2+8  FE  gb_other_nuc",
    "2+10 FE  gb_other_nuc",
    "2+6  FF  gb_est",
    "2+8  FF  gb_other_nuc",
    "2+10 FF  gb_other_nuc",
    "2+6  FG  gb_est",
    "2+8  FG  gb_other_nuc",
    "2+10 FG  gb_other_nuc",
    "2+6  FH  gb_gss",
    "2+8  FH  gb_other_nuc",
    "2+10 FH  gb_other_nuc",
    "2+6  FI  gb_gss",
    "2+8  FI  gb_other_nuc",
    "2+10 FI  gb_other_nuc",
    "2+6  FJ  gb_dirsub *",
    "2+8  FJ  gb_other_nuc",
    "2+10 FJ  gb_other_nuc",
    "2+6  FK  gb_est",
    "2+8  FK  gb_other_nuc",
    "2+10 FK  gb_other_nuc",
    "2+6  FL  gb_est",
    "2+8  FL  gb_other_nuc",
    "2+10 FL  gb_other_nuc",
    "2+6  FM  embl_dirsub *",
    "2+8  FM  embl_other_nuc",
    "2+10 FM  embl_other_nuc",
    "2+6  FN  embl_dirsub *",
    "2+8  FN  embl_other_nuc",
    "2+10 FN  embl_other_nuc",
    "2+6  FO  embl_dirsub *",
    "2+8  FO  embl_other_nuc",
    "2+10 FO  embl_other_nuc",
    "2+6  FP  embl_dirsub *",
    "2+8  FP  embl_other_nuc",
    "2+10 FP  embl_other_nuc",
    "2+6  FQ  embl_dirsub *",
    "2+8  FQ  embl_other_nuc",
    "2+10 FQ  embl_other_nuc",
    "2+6  FR  embl_dirsub *",
    "2+8  FR  embl_other_nuc",
    "2+10 FR  embl_other_nuc",
    "2+6  FS  ddbj_est",
    "2+8  FS  ddbj_other_nuc",
    "2+10 FS  ddbj_other_nuc",
    "2+6  FT  ddbj_gss",
    "2+8  FT  ddbj_other_nuc",
    "2+10 FT  ddbj_other_nuc",
    "2+6  FU  ddbj_patent",
    "2+8  FU  ddbj_other_nuc",
    "2+10 FU  ddbj_other_nuc",
    "2+6  FV  ddbj_patent",
    "2+8  FV  ddbj_other_nuc",
    "2+10 FV  ddbj_other_nuc",
    "2+6  FW  ddbj_patent",
    "2+8  FW  ddbj_other_nuc",
    "2+10 FW  ddbj_other_nuc",
    "2+6  FX  ddbj_tsa_nuc",
    "2+8  FX  ddbj_other_nuc",
    "2+10 FX  ddbj_other_nuc",
    "2+6  FY  ddbj_est",
    "2+8  FY  ddbj_other_nuc",
    "2+10 FY  ddbj_other_nuc",
    "2+6  FZ  ddbj_patent",
    "2+8  FZ  ddbj_other_nuc",
    "2+10 FZ  ddbj_other_nuc",
    "2+6  GA  ddbj_gss",
    "2+8  GA  ddbj_other_nuc",
    "2+10 GA  ddbj_other_nuc",
    "2+6  GB  ddbj_patent",
    "2+8  GB  ddbj_other_nuc",
    "2+10 GB  ddbj_other_nuc",
    "2+6  GC  gb_patent",
    "2+8  GC  gb_other_nuc",
    "2+10 GC  gb_other_nuc",
    "2+6  GD  gb_est",
    "2+8  GD  gb_other_nuc",
    "2+10 GD  gb_other_nuc",
    "2+6  GE  gb_est",
    "2+8  GE  gb_other_nuc",
    "2+10 GE  gb_other_nuc",
    "2+6  GF  gb_sts",
    "2+8  GF  gb_other_nuc",
    "2+10 GF  gb_other_nuc",
    "2+6  GG  gb_con",
    "2+8  GG  gb_other_nuc",
    "2+10 GG  gb_other_nuc",
    "2+6  GH  gb_est",
    "2+8  GH  gb_other_nuc",
    "2+10 GH  gb_other_nuc",
    "2+6  GI  unreserved_nuc # deliberately skipped",
    "2+8  GI  unreserved_nuc # deliberately skipped",
    "2+10 GI  unreserved_nuc # deliberately skipped",
    "2+6  GJ  gb_tpa_con",
    "2+8  GJ  gb_tpa_nuc",
    "2+10 GJ  gb_tpa_nuc",
    "2+6  GK  gb_tpa_chromosome",
    "2+8  GK  gb_tpa_nuc",
    "2+10 GK  gb_tpa_nuc",
    "2+6  GL  gb_con",
    "2+8  GL  gb_other_nuc",
    "2+10 GL  gb_other_nuc",
    "2+6  GM  embl_patent",
    "2+8  GM  embl_other_nuc",
    "2+10 GM  embl_other_nuc",
    "2+6  GN  embl_patent",
    "2+8  GN  embl_other_nuc",
    "2+10 GN  embl_other_nuc",
    "2+6  GO  gb_est",
    "2+8  GO  gb_other_nuc",
    "2+10 GO  gb_other_nuc",
    "2+6  GP  gb_patent",
    "2+8  GP  gb_other_nuc",
    "2+10 GP  gb_other_nuc",
    "2+6  GQ  gb_dirsub *",
    "2+8  GQ  gb_other_nuc",
    "2+10 GQ  gb_other_nuc",
    "2+6  GR  gb_est",
    "2+8  GR  gb_other_nuc",
    "2+10 GR  gb_other_nuc",
    "2+6  GS  gb_gss",
    "2+8  GS  gb_other_nuc",
    "2+10 GS  gb_other_nuc",
    "2+6  GT  gb_est",
    "2+8  GT  gb_other_nuc",
    "2+10 GT  gb_other_nuc",
    "2+6  GU  gb_dirsub *",
    "2+8  GU  gb_other_nuc",
    "2+10 GU  gb_other_nuc",
    "2+6  GV  gb_patent",
    "2+8  GV  gb_other_nuc",
    "2+10 GV  gb_other_nuc",
    "2+6  GW  gb_est",
    "2+8  GW  gb_other_nuc",
    "2+10 GW  gb_other_nuc",
    "2+6  GX  gb_patent",
    "2+8  GX  gb_other_nuc",
    "2+10 GX  gb_other_nuc",
    "2+6  GY  gb_patent",
    "2+8  GY  gb_other_nuc",
    "2+10 GY  gb_other_nuc",
    "2+6  GZ  gb_patent",
    "2+8  GZ  gb_other_nuc",
    "2+10 GZ  gb_other_nuc",
    "2+6  HA  embl_patent",
    "2+8  HA  embl_other_nuc",
    "2+10 HA  embl_other_nuc",
    "2+6  HB  embl_patent",
    "2+8  HB  embl_other_nuc",
    "2+10 HB  embl_other_nuc",
    "2+6  HC  embl_patent",
    "2+8  HC  embl_other_nuc",
    "2+10 HC  embl_other_nuc",
    "2+6  HD  embl_patent",
    "2+8  HD  embl_other_nuc",
    "2+10 HD  embl_other_nuc",
    "2+6  HE  embl_dirsub *",
    "2+8  HE  embl_other_nuc",
    "2+10 HE  embl_other_nuc",
    "2+6  HF  embl_dirsub *",
    "2+8  HF  embl_other_nuc",
    "2+10 HF  embl_other_nuc",
    "2+6  HG  embl_dirsub *",
    "2+8  HG  embl_other_nuc",
    "2+10 HG  embl_other_nuc",
    "2+6  HH  embl_patent",
    "2+8  HH  embl_other_nuc",
    "2+10 HH  embl_other_nuc",
    "2+6  HI  embl_patent",
    "2+8  HI  embl_other_nuc",
    "2+10 HI  embl_other_nuc",
    "2+6  HJ  gb_patent",
    "2+8  HJ  gb_other_nuc",
    "2+10 HJ  gb_other_nuc",
    "2+6  HK  gb_patent",
    "2+8  HK  gb_other_nuc",
    "2+10 HK  gb_other_nuc",
    "2+6  HL  gb_patent",
    "2+8  HL  gb_other_nuc",
    "2+10 HL  gb_other_nuc",
    "2+6  HM  gb_dirsub *",
    "2+8  HM  gb_other_nuc",
    "2+10 HM  gb_other_nuc",
    "2+6  HN  gb_gss",
    "2+8  HN  gb_other_nuc",
    "2+10 HN  gb_other_nuc",
    "2+6  HO  gb_est",
    "2+8  HO  gb_other_nuc",
    "2+10 HO  gb_other_nuc",
    "2+6  HP  gb_tsa_nuc",
    "2+8  HP  gb_other_nuc",
    "2+10 HP  gb_other_nuc",
    "2+6  HQ  gb_dirsub *",
    "2+8  HQ  gb_other_nuc",
    "2+10 HQ  gb_other_nuc",
    "2+6  HR  gb_gss",
    "2+8  HR  gb_other_nuc",
    "2+10 HR  gb_other_nuc",
    "2+6  HS  gb_est",
    "2+8  HS  gb_other_nuc",
    "2+10 HS  gb_other_nuc",
    "2+6  HT  ddbj_tpa_con",
    "2+8  HT  ddbj_tpa_nuc",
    "2+10 HT  ddbj_tpa_nuc",
    "2+6  HU  ddbj_tpa_chromosome",
    "2+8  HU  ddbj_tpa_nuc",
    "2+10 HU  ddbj_tpa_nuc",
    "2+6  HV  ddbj_patent",
    "2+8  HV  ddbj_other_nuc",
    "2+10 HV  ddbj_other_nuc",
    "2+6  HW  ddbj_patent",
    "2+8  HW  ddbj_other_nuc",
    "2+10 HW  ddbj_other_nuc",
    "2+6  HX  ddbj_est",
    "2+8  HX  ddbj_other_nuc",
    "2+10 HX  ddbj_other_nuc",
    "2+6  HY  ddbj_est",
    "2+8  HY  ddbj_other_nuc",
    "2+10 HY  ddbj_other_nuc",
    "2+6  HZ  ddbj_patent",
    "2+8  HZ  ddbj_other_nuc",
    "2+10 HZ  ddbj_other_nuc",
    "2+6  JA  embl_patent",
    "2+8  JA  embl_other_nuc",
    "2+10 JA  embl_other_nuc",
    "2+6  JB  embl_patent",
    "2+8  JB  embl_other_nuc",
    "2+10 JB  embl_other_nuc",
    "2+6  JC  embl_patent",
    "2+8  JC  embl_other_nuc",
    "2+10 JC  embl_other_nuc",
    "2+6  JD  embl_patent",
    "2+8  JD  embl_other_nuc",
    "2+10 JD  embl_other_nuc",
    "2+6  JE  embl_patent",
    "2+8  JE  embl_other_nuc",
    "2+10 JE  embl_other_nuc",
    "2+6  JF  gb_dirsub",
    "2+8  JF  gb_other_nuc",
    "2+10 JF  gb_other_nuc",
    "2+6  JG  gb_est",
    "2+8  JG  gb_other_nuc",
    "2+10 JG  gb_other_nuc",
    "2+6  JH  gb_con",
    "2+8  JH  gb_other_nuc",
    "2+10 JH  gb_other_nuc",
    "2+6  JI  gb_tsa_nuc",
    "2+8  JI  gb_other_nuc",
    "2+10 JI  gb_other_nuc",
    "2+6  JJ  gb_gss",
    "2+8  JJ  gb_other_nuc",
    "2+10 JJ  gb_other_nuc",
    "2+6  JK  gb_est",
    "2+8  JK  gb_other_nuc",
    "2+10 JK  gb_other_nuc",
    "2+6  JL  gb_tsa_nuc",
    "2+8  JL  gb_other_nuc",
    "2+10 JL  gb_other_nuc",
    "2+6  JM  gb_gss",
    "2+8  JM  gb_other_nuc",
    "2+10 JM  gb_other_nuc",
    "2+6  JN  gb_dirsub *",
    "2+8  JN  gb_other_nuc",
    "2+10 JN  gb_other_nuc",
    "2+6  JO  gb_tsa_nuc",
    "2+8  JO  gb_other_nuc",
    "2+10 JO  gb_other_nuc",
    "2+6  JP  gb_tsa_nuc",
    "2+8  JP  gb_other_nuc",
    "2+10 JP  gb_other_nuc",
    "2+6  JQ  gb_dirsub",
    "2+8  JQ  gb_other_nuc",
    "2+10 JQ  gb_other_nuc",
    "2+6  JR  gb_tsa_nuc",
    "2+8  JR  gb_other_nuc",
    "2+10 JR  gb_other_nuc",
    "2+6  JS  gb_gss",
    "2+8  JS  gb_other_nuc",
    "2+10 JS  gb_other_nuc",
    "2+6  JT  gb_tsa_nuc",
    "2+8  JT  gb_other_nuc",
    "2+10 JT  gb_other_nuc",
    "2+6  JU  gb_tsa_nuc",
    "2+8  JU  gb_other_nuc",
    "2+10 JU  gb_other_nuc",
    "2+6  JV  gb_tsa_nuc",
    "2+8  JV  gb_other_nuc",
    "2+10 JV  gb_other_nuc",
    "2+6  JW  gb_tsa_nuc",
    "2+8  JW  gb_other_nuc",
    "2+10 JW  gb_other_nuc",
    "2+6  JX  gb_dirsub",
    "2+8  JX  gb_other_nuc",
    "2+10 JX  gb_other_nuc",
    "2+6  JY  gb_gss",
    "2+8  JY  gb_other_nuc",
    "2+10 JY  gb_other_nuc",
    "2+6  JZ  gb_est",
    "2+8  JZ  gb_other_nuc",
    "2+10 JZ  gb_other_nuc",
    "2+6  KA  gb_tsa_nuc",
    "2+8  KA  gb_other_nuc",
    "2+10 KA  gb_other_nuc",
    "2+6  KB  gb_con",
    "2+8  KB  gb_other_nuc",
    "2+10 KB  gb_other_nuc",
    "2+6  KC  gb_dirsub",
    "2+8  KC  gb_other_nuc",
    "2+10 KC  gb_other_nuc",
    "2+6  KD  gb_con",
    "2+8  KD  gb_other_nuc",
    "2+10 KD  gb_other_nuc",
    "2+6  KE  gb_con",
    "2+8  KE  gb_other_nuc",
    "2+10 KE  gb_other_nuc",
    "2+6  KF  gb_dirsub *",
    "2+8  KF  gb_other_nuc",
    "2+10 KF  gb_other_nuc",
    "2+6  KG  gb_gss",
    "2+8  KG  gb_other_nuc",
    "2+10 KG  gb_other_nuc",
    "2+6  KH  gb_patent",
    "2+8  KH  gb_other_nuc",
    "2+10 KH  gb_other_nuc",
    "2+6  KI  gb_con",
    "2+8  KI  gb_other_nuc",
    "2+10 KI  gb_other_nuc",
    "2+6  KJ  gb_dirsub *",
    "2+8  KJ  gb_other_nuc",
    "2+10 KJ  gb_other_nuc",
    "2+6  KK  gb_con",
    "2+8  KK  gb_other_nuc",
    "2+10 KK  gb_other_nuc",
    "2+6  KL  gb_con",
    "2+8  KL  gb_other_nuc",
    "2+10 KL  gb_other_nuc",
    "2+6  KM  gb_dirsub *",
    "2+8  KM  gb_other_nuc",
    "2+10 KM  gb_other_nuc",
    "2+6  KN  gb_con",
    "2+8  KN  gb_other_nuc",
    "2+10 KN  gb_other_nuc",
    "2+6  KO  gb_gss",
    "2+8  KO  gb_other_nuc",
    "2+10 KO  gb_other_nuc",
    "2+6  KP  gb_dirsub",
    "2+8  KP  gb_other_nuc",
    "2+10 KP  gb_other_nuc",
    "2+6  KQ  gb_con",
    "2+8  KQ  gb_other_nuc",
    "2+10 KQ  gb_other_nuc",
    "2+6  KR  gb_dirsub",
    "2+8  KR  gb_other_nuc",
    "2+10 KR  gb_other_nuc",
    "2+6  KS  gb_gss",
    "2+8  KS  gb_other_nuc",
    "2+10 KS  gb_other_nuc",
    "2+6  KT  gb_dirsub",
    "2+8  KT  gb_other_nuc",
    "2+10 KT  gb_other_nuc",
    "2+6  KU  gb_dirsub",
    "2+8  KU  gb_other_nuc",
    "2+10 KU  gb_other_nuc",
    "2+6  KV  gb_con",
    "2+8  KV  gb_other_nuc",
    "2+10 KV  gb_other_nuc",
    "2+6  KW  gb_other_nuc",
    "2+8  KW  gb_other_nuc",
    "2+10 KW  gb_other_nuc",
    "2+6  KX  gb_dirsub",
    "2+8  KX  gb_other_nuc",
    "2+10 KX  gb_other_nuc",
    "2+6  KY  gb_dirsub",
    "2+8  KY  gb_other_nuc",
    "2+10 KY  gb_other_nuc",
    "2+6  KZ  gb_con",
    "2+8  KZ  gb_other_nuc",
    "2+10 KZ  gb_other_nuc",
    "2+6  LA  ddbj_tsa_nuc",
    "2+8  LA  ddbj_other_nuc",
    "2+10 LA  ddbj_other_nuc",
    "2+6  LB  ddbj_gss",
    "2+8  LB  ddbj_other_nuc",
    "2+10 LB  ddbj_other_nuc",
    "2+6  LC  ddbj_dirsub",
    "2+8  LC  ddbj_other_nuc",
    "2+10 LC  ddbj_other_nuc",
    "2+6  LD  ddbj_con",
    "2+8  LD  ddbj_other_nuc",
    "2+10 LD  ddbj_other_nuc",
    "2+6  LE  ddbj_tsa_nuc",
    "2+8  LE  ddbj_other_nuc",
    "2+10 LE  ddbj_other_nuc",
    "2+6  LF  ddbj_patent",
    "2+8  LF  ddbj_other_nuc",
    "2+10 LF  ddbj_other_nuc",
    "2+6  LG  ddbj_patent # from Korea",
    "2+8  LG  ddbj_other_nuc",
    "2+10 LG  ddbj_other_nuc",
    "2+6  LH  ddbj_tsa_nuc",
    "2+8  LH  ddbj_other_nuc",
    "2+10 LH  ddbj_other_nuc",
    "2+6  LI  ddbj_tsa_nuc",
    "2+8  LI  ddbj_other_nuc",
    "2+10 LI  ddbj_other_nuc",
    "2+6  LJ  ddbj_tsa_nuc",
    "2+8  LJ  ddbj_other_nuc",
    "2+10 LJ  ddbj_other_nuc",
    "2+6  LK  embl_dirsub *",
    "2+8  LK  embl_other_nuc",
    "2+10 LK  embl_other_nuc",
    "2+6  LL  embl_dirsub",
    "2+8  LL  embl_other_nuc",
    "2+10 LL  embl_other_nuc",
    "2+6  LM  embl_dirsub *",
    "2+8  LM  embl_other_nuc",
    "2+10 LM  embl_other_nuc",
    "2+6  LN  embl_dirsub *",
    "2+8  LN  embl_other_nuc",
    "2+10 LN  embl_other_nuc",
    "2+6  LO  embl_dirsub *",
    "2+8  LO  embl_other_nuc",
    "2+10 LO  embl_other_nuc",
    "2+6  LP  embl_patent",
    "2+8  LP  embl_other_nuc",
    "2+10 LP  embl_other_nuc",
    "2+6  LQ  embl_patent",
    "2+8  LQ  embl_other_nuc",
    "2+10 LQ  embl_other_nuc",
    "2+6  LR  embl_dirsub * # embl_patent?",
    "2+8  LR  embl_other_nuc",
    "2+10 LR  embl_other_nuc",
    "2+6  LS  embl_dirsub # embl_patent?",
    "2+8  LS  embl_other_nuc",
    "2+10 LS  embl_other_nuc",
    "2+6  LT  embl_dirsub *",
    "2+8  LT  embl_other_nuc",
    "2+10 LT  embl_other_nuc",
    "2+6  LU  ddbj_est",
    "2+8  LU  ddbj_other_nuc",
    "2+10 LU  ddbj_other_nuc",
    "2+6  LV  ddbj_patent",
    "2+8  LV  ddbj_other_nuc",
    "2+10 LV  ddbj_other_nuc",
    "2+6  LW  ddbj_other_nuc",
    "2+8  LW  ddbj_other_nuc",
    "2+10 LW  ddbj_other_nuc",
    "2+6  LX  ddbj_patent",
    "2+8  LX  ddbj_other_nuc",
    "2+10 LX  ddbj_other_nuc",
    "2+6  LY  ddbj_patent # from Korea",
    "2+8  LY  ddbj_other_nuc",
    "2+10 LY  ddbj_other_nuc",
    "2+6  LZ  ddbj_patent",
    "2+8  LZ  ddbj_other_nuc",
    "2+10 LZ  ddbj_other_nuc",
    "2+6  MA  ddbj_patent",
    "2+8  MA  ddbj_other_nuc",
    "2+10 MA  ddbj_other_nuc",
    "2+6  MB  ddbj_patent",
    "2+8  MB  ddbj_other_nuc",
    "2+10 MB  ddbj_other_nuc",
    "2+6  MC  ddbj_patent",
    "2+8  MC  ddbj_other_nuc",
    "2+10 MC  ddbj_other_nuc",
    "2+6  MD  ddbj_patent",
    "2+8  MD  ddbj_other_nuc",
    "2+10 MD  ddbj_other_nuc",
    "2+6  ME  ddbj_patent",
    "2+8  ME  ddbj_other_nuc",
    "2+10 ME  ddbj_other_nuc",
    "2+6  MF  gb_dirsub",
    "2+8  MF  gb_other_nuc",
    "2+10 MF  gb_other_nuc",
    "2+6  MG  gb_dirsub",
    "2+8  MG  gb_other_nuc",
    "2+10 MG  gb_other_nuc",
    "2+6  MH  gb_dirsub",
    "2+8  MH  gb_other_nuc",
    "2+10 MH  gb_other_nuc",
    "2+6  MI  gb_patent",
    "2+8  MI  gb_other_nuc",
    "2+10 MI  gb_other_nuc",
    "2+6  MJ  gb_gss",
    "2+8  MJ  gb_other_nuc",
    "2+10 MJ  gb_other_nuc",
    "2+6  MK  gb_dirsub",
    "2+8  MK  gb_other_nuc",
    "2+10 MK  gb_other_nuc",
    "2+6  ML  gb_con",
    "2+8  ML  gb_other_nuc",
    "2+10 ML  gb_other_nuc",
    "2+6  MM  gb_patent",
    "2+8  MM  gb_other_nuc",
    "2+10 MM  gb_other_nuc",
    "2+6  MN  gb_dirsub",
    "2+8  MN  gb_other_nuc",
    "2+10 MN  gb_other_nuc",
    "2+6  MO  gb_patent",
    "2+8  MO  gb_other_nuc",
    "2+10 MO  gb_other_nuc",
    "2+6  MP  embl_patent",
    "2+8  MP  embl_other_nuc",
    "2+10 MP  embl_other_nuc",
    "2+6  MQ  embl_patent",
    "2+8  MQ  embl_other_nuc",
    "2+10 MQ  embl_other_nuc",
    "2+6  MR  embl_patent",
    "2+8  MR  embl_other_nuc",
    "2+10 MR  embl_other_nuc",
    "2+6  MS  embl_patent",
    "2+8  MS  embl_other_nuc",
    "2+10 MS  embl_other_nuc",
    "2+6  MT  gb_dirsub",
    "2+8  MT  gb_other_nuc",
    "2+10 MT  gb_other_nuc",
    "2+6  MU  gb_con",
    "2+8  MU  gb_other_nuc",
    "2+10 MU  gb_other_nuc",
    "2+6  MV  gb_patent",
    "2+8  MV  gb_other_nuc",
    "2+10 MV  gb_other_nuc",
    "2+6  MW  gb_dirsub",
    "2+8  MW  gb_other_nuc",
    "2+10 MW  gb_other_nuc",
    "2+6  MX  gb_patent",
    "2+8  MX  gb_other_nuc",
    "2+10 MX  gb_other_nuc",
    "2+6  MY  gb_patent",
    "2+8  MY  gb_other_nuc",
    "2+10 MY  gb_other_nuc",
    "2+6  MZ  gb_dirsub",
    "2+8  MZ  gb_other_nuc",
    "2+10 MZ  gb_other_nuc",
    "2+6  NC  unreserved_nuc # deliberately skipped",
    "2+8  NC  unreserved_nuc # deliberately skipped",
    "2+10 NC  unreserved_nuc # deliberately skipped",
    "2+6  NG  unreserved_nuc # deliberately skipped",
    "2+8  NG  unreserved_nuc # deliberately skipped",
    "2+10 NG  unreserved_nuc # deliberately skipped",
    "2+6  NM  unreserved_nuc # deliberately skipped",
    "2+8  NM  unreserved_nuc # deliberately skipped",
    "2+10 NM  unreserved_nuc # deliberately skipped",
    "2+6  NP  unreserved_nuc # deliberately skipped",
    "2+8  NP  unreserved_nuc # deliberately skipped",
    "2+10 NP  unreserved_nuc # deliberately skipped",
    "2+6  NR  unreserved_nuc # deliberately skipped",
    "2+8  NR  unreserved_nuc # deliberately skipped",
    "2+10 NR  unreserved_nuc # deliberately skipped",
    "2+6  NS  unreserved_nuc # deliberately skipped",
    "2+8  NS  unreserved_nuc # deliberately skipped",
    "2+10 NS  unreserved_nuc # deliberately skipped",
    "2+6  NT  unreserved_nuc # deliberately skipped",
    "2+8  NT  unreserved_nuc # deliberately skipped",
    "2+10 NT  unreserved_nuc # deliberately skipped",
    "2+6  NW  unreserved_nuc # deliberately skipped",
    "2+8  NW  unreserved_nuc # deliberately skipped",
    "2+10 NW  unreserved_nuc # deliberately skipped",
    "2+6  NZ  unreserved_nuc # deliberately skipped",
    "2+8  NZ  unreserved_nuc # deliberately skipped",
    "2+10 NZ  unreserved_nuc # deliberately skipped",
    "2+6  OA  embl_other_nuc",
    "2+8  OA  embl_other_nuc",
    "2+10 OA  embl_other_nuc",
    "2+6  OB  embl_other_nuc *",
    "2+8  OB  embl_other_nuc",
    "2+10 OB  embl_other_nuc",
    "2+6  OC  embl_other_nuc",
    "2+8  OC  embl_other_nuc",
    "2+10 OC  embl_other_nuc",
    "2+6  OD  embl_other_nuc",
    "2+8  OD  embl_other_nuc",
    "2+10 OD  embl_other_nuc",
    "2+6  OE  embl_other_nuc",
    "2+8  OE  embl_other_nuc",
    "2+10 OE  embl_other_nuc",
    "2+6  OF  ddbj_patent # from Korea",
    "2+8  OF  ddbj_other_nuc",
    "2+10 OF  ddbj_other_nuc",
    "2+6  OG  ddbj_patent",
    "2+8  OG  ddbj_other_nuc",
    "2+10 OG  ddbj_other_nuc",
    "2+6  OH  ddbj_est",
    "2+8  OH  ddbj_other_nuc",
    "2+10 OH  ddbj_other_nuc",
    "2+6  OI  ddbj_patent",
    "2+8  OI  ddbj_other_nuc",
    "2+10 OI  ddbj_other_nuc",
    "2+6  OJ  ddbj_patent",
    "2+8  OJ  ddbj_other_nuc",
    "2+10 OJ  ddbj_other_nuc",
    "2+6  OK  gb_dirsub",
    "2+8  OK  gb_other_nuc",
    "2+10 OK  gb_other_nuc",
    "2+6  OL  gb_dirsub",
    "2+8  OL  gb_other_nuc",
    "2+10 OL  gb_other_nuc",
    "2+6  OM  gb_dirsub",
    "2+8  OM  gb_other_nuc",
    "2+10 OM  gb_other_nuc",
    "2+6  ON  gb_dirsub",
    "2+8  ON  gb_other_nuc",
    "2+10 ON  gb_other_nuc",
    "2+6  OO  gb_patent",
    "2+8  OO  gb_other_nuc",
    "2+10 OO  gb_other_nuc",
    "2+6  OP  gb_dirsub",
    "2+8  OP  gb_other_nuc",
    "2+10 OP  gb_other_nuc",
    "2+6  OQ  gb_dirsub",
    "2+8  OQ  gb_other_nuc",
    "2+10 OQ  gb_other_nuc",
    "2+6  OR  gb_other_nuc",
    "2+8  OR  gb_other_nuc",
    "2+10 OR  gb_other_nuc",
    "2+6  OS  gb_other_nuc",
    "2+8  OS  gb_other_nuc",
    "2+10 OS  gb_other_nuc",
    "2+6  OT  gb_other_nuc",
    "2+8  OT  gb_other_nuc",
    "2+10 OT  gb_other_nuc",
    "2+6  O?  embl_other_nuc",
    "2+8  O?  embl_other_nuc",
    "2+10 O?  embl_other_nuc",
    "2+6  PA  ddbj_patent",
    "2+8  PA  ddbj_other_nuc",
    "2+10 PA  ddbj_other_nuc",
    "2+6  PB  ddbj_patent",
    "2+8  PB  ddbj_other_nuc",
    "2+10 PB  ddbj_other_nuc",
    "2+6  PC  ddbj_patent",
    "2+8  PC  ddbj_other_nuc",
    "2+10 PC  ddbj_other_nuc",
    "2+6  PD  ddbj_patent",
    "2+8  PD  ddbj_other_nuc",
    "2+10 PD  ddbj_other_nuc",
    "2+6  PE  ddbj_patent # from Korea",
    "2+8  PE  ddbj_other_nuc",
    "2+10 PE  ddbj_other_nuc",
    "2+6  TI  unreserved_nuc # deliberately skipped",
    "2+8  TI  unreserved_nuc # deliberately skipped",
    "2+10 TI  unreserved_nuc # deliberately skipped",
    "2+6  WP  unreserved_nuc # deliberately skipped",
    "2+8  WP  unreserved_nuc # deliberately skipped",
    "2+10 WP  unreserved_nuc # deliberately skipped",
    "2+6  XM  unreserved_nuc # deliberately skipped",
    "2+8  XM  unreserved_nuc # deliberately skipped",
    "2+10 XM  unreserved_nuc # deliberately skipped",
    "2+6  XP  unreserved_nuc # deliberately skipped",
    "2+8  XP  unreserved_nuc # deliberately skipped",
    "2+10 XP  unreserved_nuc # deliberately skipped",
    "2+6  XR  unreserved_nuc # deliberately skipped",
    "2+8  XR  unreserved_nuc # deliberately skipped",
    "2+10 XR  unreserved_nuc # deliberately skipped",
    "2+6  YP  unreserved_nuc # deliberately skipped",
    "2+8  YP  unreserved_nuc # deliberately skipped",
    "2+10 YP  unreserved_nuc # deliberately skipped",
    "2+6  ZP  unreserved_nuc # deliberately skipped",
    "2+8  ZP  unreserved_nuc # deliberately skipped",
    "2+10 ZP  unreserved_nuc # deliberately skipped",
    "2+6  ??  unreserved_nuc",
    "2+8  ??  unreserved_nuc",
    "2+10 ??  unreserved_nuc",
    "",
    "# Specially handled type-general Dbtag names; commented out for now in",
    "# favor of a hard-coded list.  (Uncommenting them will override it.)",
    "",
    "#gnl  SRA         general_nuc",
    "#gnl  ti          general_nuc",
    "#gnl  TR_ASSM_CH  general_nuc",
    "#gnl  TRACE_ASSM  general_nuc",
    "#gnl  TRACE_CHGR  general_nuc",
    "",
    "# SPECIAL CASES",
    "# Mostly in the same order as baseline assignments, but embl_tpa_prot",
    "# specials are at the very end because there are so many of them.  To",
    "# keep to a rough limit of 100 ranges per prefix, resort to *_other_nuc",
    "# for some heavily mixed ranges.",
    "",
    "# Some GenBank \"TPA\" 8-character protein accessions are really native.",
    "special2 DAA+5 gb_prot",
    ": 00001 2110-6 34794-5",
    "",
    "# Nominally ddbj_est.",
    "special2 C+5 ddbj_dirsub",
    ": 21595-827 2715-62 83-911 4689-767 75685-936 95573-642 9933-76",
    "",
    "# Nominally ddbj_dirsub.  Split out EST ranges, and give the benefit",
    "# of the doubt to sequences that look like ddbj_con, ddbj_genome,",
    "# ddbj_mrna, or ddbj_other_nuc.",
    "special2 D+5 ddbj_est",
    ": 00922 11487-2469 7812-21053",
    ": 6771-8109 70-83 5-96 8 200 3 5-6 8-15 7-24 7 9 32 4 81-8 90-310 2-8 20-6",
    ": 603-744 9018-624 993-30029 816-1599 2304-958 60-3769 71-4214 6-410 2-589",
    ": 640-5674 6-6684 42187-3617 60143-1376 420-685 708-2388",
    ": 90-3133 71-317 9-24 30 746-58 4179-5034 6-241 3-978 80-6873",
    ": 7099-8048 50-323 5-600 2-9603 5-70813 6447-7996",
    "# EST range counts: 62, 118, 101, 70, 1208, 45, and 91 respectively.",
    "special2 D+5 ddbj_other_nuc",
    ": 15075-7289 21355-6768 36686-42011 4612-9352 50936-60141 70900-6413 8209-89649",
    "",
    "special  F38006         embl_dirsub # Nominally embl_est.",
    "",
    "# Nominally gsdb_dirsub.  Split out EST, GSS, and STS ranges, and",
    "# give the benefit of the doubt to sequences that look like gb_cdna,",
    "# gb_con, gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 L+5 gb_est",
    ": 18857-8 9032-41 143-55 60 202-14 20451-61 5173-249 344-5 7 417-20 49-525",
    ": 6606-848 7444 30148 1968-2015 28-65 3494-675 4957-5007 773-843",
    ": 7453-515 607-59 974-8013 26-243 525-43 741 50-60 3 74 87 40420-4 3576-7 9-80",
    ": 4279-576 6401-582 914-7098 842-965 8818-73 9057-120 76101-31 81201-60",
    "special2 L+5 gb_sts",
    ": 00738-844 6-50 2-91 3-916 94-1014 996-2021 80-91 4198-215 7331-2 863",
    ": 17188-290 8193-255 23479-93 992 7 4693 826 5137 888 8178-418 20-2",
    ": 31430-7 40-89 4798-802 5580-1 6534 7208-88 9872-3 40034 40-1 351-2 1967",
    ": 7214-5 542 54-68 8016 76151 7669-70 4-83 5-6 9 878-83 993",
    "special  L48736-L48796  gb_gss",
    "special  L08881-L15794  gb_other_nuc # 6 EST ranges and 23 STS ranges",
    "",
    "# Nominally gsdb_dirsub.  Split out EST and STS ranges, and give the",
    "# benefit of the doubt to sequences that look like gb_cdna, gb_con,",
    "# gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 M+5 gb_est",
    ": 61953-2300",
    ": 75734-848 50-2 4-5 7 9-63 8-9 72 4 6-81 5 90 2-902 4-5 12 5 7-43 5-6 51 5",
    ": 64-5 88 6111-22 7851-9278 465-80184 5308-6179 8774-9469",
    ": 91216-22 387-403 80-511 2283-4 935 6605-21",
    "special2 M+5 gb_sts",
    ": 23606-10 80369-76 3631-9 4924-34 43 94585-622 35-43 55-62 5212-80 301-23",
    ": 8979-96",
    "",
    "# Early N accessions were assigned haphazardly, and sometimes ambiguously.",
    "# (These are all secondary accessions nowadays, though.)  \"*\" denotes what,",
    "# if anything, N????? (and usually also N?????.1) immediately resolves to.",
    "# Some unambiguous accessions don't resolve, and some ambiguous ones do.",
    "special  N00001  gb_embl        # (L29187+L00109+L00110 / AH005313.2) / X04516.1",
    "special  N00002  gb_embl_ddbj   # M31027.1 / X04469.1 = D00002",
    "special  N00003  gb_ddbj        # L29169.1 / D00003.1",
    "special  N00004  gb_ddbj        # *L29170.1 / D00004.1",
    "special  N00005  gb_embl_ddbj   # L29171.1 / V01385.1 / D00005.1",
    "special  N00006  gb_ddbj        # (M31028.1 / AH002572.2) / D00006.1",
    "special  N00007  gb_ddbj        # (M31029.1 / AH002572.2) / D00007.1",
    "special  N00008  gb_other_nuc   # *L29172.1",
    "special  N00009  gb_embl_ddbj   # M13655.1 / *X00532.1 / D00009.1 (= M13655.1)",
    "special  N00010  gb_embl_ddbj   # *L29174.1 / X04067.1 = D00010.1",
    "special  N00011  gb_embl        # *L29175.1 = V00749.1",
    "special  N00012  gb_embl_ddbj   # L29176.1 = V00751.1 / D00012.1",
    "special  N00013  gb_other_nuc   # L29177.1 / AH002712.2",
    "special  N00014  gb_ddbj        # (L29178.1 / AH005322.2) / D00014.1",
    "special  N00015  gb_ddbj        # (L29187.1 / AH005313.2) / D00015.1",
    "special  N00016  gb_ddbj        # (L29188.1 / AH005313.2) / D00016.1",
    "special  N00017  gb_ddbj        # *L29190.1 / (M14043 =) D00017.1",
    "special  N00018  gb_other_nuc   # *L29191.1 / AH002172.2; only unversioned",
    "special  N00019  gb_other_nuc   # *L29197.1",
    "special  N00020  gb_embl_ddbj   # (L29198.1 / AH002320.2) / X03632.1 = D00020.1",
    "special  N00021  gb_ddbj        # (L29199.1 / AH002320.2) / D00021.1",
    "special  N00022  gb_embl_ddbj   # L29390.1 / V01168.1 / D00022.1",
    "special  N00023  gb_ddbj        # (L29391.1 / AH000963.2) / D00023.1",
    "special  N00024  gb_ddbj        # *L29392.1 / (M13071.1 =) D00024.1",
    "special  N00025  gb_embl_ddbj   # L29393.1 / X00626.1 / D00025.1",
    "special  N00026  gb_ddbj        # L29394.1 (= *X00442.1) / D00026.1",
    "special  N00027  gb_other_nuc   # *L29395.1",
    "special  N00028  ddbj_other_nuc # D00028.1",
    "special  N00029  gb_ddbj        # *L29397.1 / D00029.1",
    "special  N00030  gb_ddbj        # M10126.1 / D00030.1",
    "special  N00031  gb_ddbj        # (*L29400.1 / AH002739.2) / D00031.1; unvers.",
    "special  N00032  gb_ddbj        # (L?????.1 / AH??????.2) / D00032.1",
    "special  N00033  gb_ddbj        # (L29401.1 / AH002776.2) / D00033.1",
    "special  N00034  gb_ddbj        # (L29424.1 / AH001823.2) / D00034.1",
    "special  N00035  ddbj_other_nuc # D00035.1",
    "special  N00036  gb_ddbj        # M31030.1 / D00036.1",
    "special  N00037  ddbj_other_nuc # D00037.1",
    "special  N00038  gb_ddbj        # M31031.1 / D00038.1",
    "special  N00039  gb_ddbj        # *L29427.1 / D00039.1",
    "special  N00040  gb_ddbj        # L29428.1 / D00040.1",
    "special  N00041  gb_other_nuc   # L29429.1 / *M13756.1 (= D00041)",
    "special  N00042  gb_ddbj        # (L29430.1 / AH002209.2) / (M13752 =) D00042.1",
    "special  N00043  gb_ddbj        # (L29431.1 / AH005585.2) / (M13753 =) D00043.1",
    "special  N00044  gb_ddbj        # L29432.1 / D00044.1",
    "special  N00045  gb_other_nuc   # (*L29433.1/AH002727.2); once also DDBJ?",
    "special  N00046  gb_other_nuc   # *L29434.1",
    "special  N00047  gb_ddbj        # (*L29435.1 / AH002481.2) / D00047.1",
    "special  N00048  gb_other_nuc   # *L29436.1",
    "special  N00049  gb_ddbj        # M31032.1 / D00049.1",
    "special  N00050  gb_ddbj        # (L29399.1 / AH002739.2) / D00050.1",
    "special  N00051  gb_ddbj        # (L?????.1 / AH??????.2) / D00051.1",
    "special  N00052  gb_other_nuc   # L29472.1 / *M14909.1 (= D00052.1)",
    "special  N00053  ddbj_other_nuc # D00053.1",
    "special  N00054  gb_other_nuc   # M31033.1",
    "special  N00055  gb_ddbj        # (L?????.1 / AH??????.2) / D00055.1",
    "special  N00056  gb_ddbj        # L39908.1 / D00056.1",
    "special  N00057  gb_embl        # M31034.1 / X05532.1",
    "special  N00058  gb_embl_ddbj   # M31035.1 (= X05163.1) / (X05537.1 =) D00058.1",
    "special  N00059  gb_ddbj        # M22232.1 / (X05538.1 =) D00059.1",
    "special  N00060  embl_other_nuc # X05541.1 (= D00060.1)",
    "special  N00061  ddbj_other_nuc # (X05531.1 =) D00061.1",
    "special  N00062  ddbj_other_nuc # (X05530.1 =) D00062.1",
    "special  N00063  ddbj_other_nuc # (X05529.1 =) D00063.1",
    "special  N00064  embl_other_nuc # X05528.1 (= D00064.1 = D10030.1)",
    "special  N00065  ddbj_other_nuc # (X05527.1 =) D00065.1 = D10031.1",
    "special  N00066  ddbj_other_nuc # D00066.1",
    "special  N00067  ddbj_other_nuc # (M20207.1 =) D00067.1",
    "special  N00068  ddbj_other_nuc # D00068.1",
    "special  N00069  ddbj_other_nuc # D00069.1",
    "special  N00070  embl_ddbj      # X04036.1 = D00070.1",
    "special  N00078  ddbj_other_nuc # D00078.1",
    "special  N00079  ddbj_other_nuc # D00079.1",
    "special  N00083  ddbj_other_nuc # D00083.1",
    "special  N00088  ddbj_other_nuc # (M16550.1 =) D00088.1 = D10032.1",
    "special  N00090  ddbj_other_nuc # (X05597.1 =) D00090.1",
    "special  N00091  ddbj_other_nuc # (M15807.1 =) D00091.1",
    "special  N00092  ddbj_other_nuc # D00092.1",
    "special  N00093  ddbj_other_nuc # (M34437.1 = X04797.1 =) D00093.1",
    "special  N00094  ddbj_other_nuc # (X05040.1 =) D00094.1",
    "special  N18624  gb_other_nuc   # *L29496.1 / M23263.1",
    "special  N20001-N97317  gb_est",
    "special  N97318-N97531  gb_gss",
    "special  N97532-N99999  gb_est",
    "",
    "# Nominally gb_est.",
    "special2 T+5 gb_gss",
    ": 02634-808 9496-993",
    "",
    "# Nominally gb_dirsub.",
    "special2 U+5 gb_est",
    ": 01537-51 921 13686 4111-4 71 5041-7 988 7154 513-64 82-4 905-9 76-7",
    ": 99-8008 10-7 9036 135-41 512-5 678-93 732 72 823 21073-81 3-5 457-70 33921",
    ": 4233-44 396-400 5429 6594-6 7151-64 229 31-4 913-35 7-8174 9396 407-8 588-607",
    ": 40055 140-3 53 589 629 1133-61 297 2490-1 570-9 751 3146",
    ": 4093-102 35-377 981-90 54592-607 706-33 5-9 79 5034 777 962-91 6653-60 7844",
    ": 8051-82 979 9417 9 755-6 60299-311 799 2909 3519 22-8 4597 679 965-6",
    ": 5082 383-9 438-9 740 917 6423 576-7 693-7 718",
    "special2 U+5 gb_gss",
    ": 19502-10 21493-545 37588 60606-38 1299-300 522-5 5903-5 6210-3 5 97486 8 90 3",
    "# Respective (EST, GSS, STS) range counts:",
    "# (21, 1, 0); (18, 1, 0); (30, 5, 0); (13, 5, 0); (103, 35, 1)",
    "special2 U+5 gb_other_nuc",
    ": 23049-6690 7989-31698 46160-53560 67850-70383 2041-95639",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST ranges.",
    "special2 X+5 embl_est",
    ": 61801-99 2402 5268-75 374-93 71637-41 3-52 3542-8 704-804 6318 487 8018-28",
    ": 82204 3032-4 304-66 4313 711-21 5546-725 6144-6 218-20 7300-5 9987-96",
    ": 90532-45 1308-35 672-734 2440 790-803",
    ": 3012-4 79 227-300 413-60 811-67 915-9 88-9 4486-532 5581 686 6619-25",
    ": 7503-19 896-7 8134-40 98-204 425-8 548-54 9272",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Y+5 embl_est",
    ": 07823 8464-83 705-14",
    ": 9139 316-20 59-64 75-7 459-64 519-23 43-5 726-32 875 981-6",
    ": 10008-10 37-42 56-60 217-20 671-2 1191 308 615 4396-402 6130-1 971-4 8366",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Z+5 embl_est",
    ": 24464-546 760-6",
    ": 9-5279 83-392 400-17 86-508 10-8 46-86 8-733 76-94 9-801 5-8 25-6 32-50",
    ": 89-6039 45-132 84-235 7-8 43-4 323-30 42-480 95-517 25-79 658-752 4-64 72-823",
    ": 68-74 952-66 71-7066 95-104 240 9-303",
    ": 38136-46221 43-8 91-8 428-30 510-20 6-94 677-718 813-22 30-2 974-80",
    ": 7057-65 278-348 50-1 82-408 575-720 801-2 985",
    ": 8368-427 45-8 53-67 545-60 608-11 37 9229-32 744-5 54295-305 9-11",
    ": 69578-84 945-72 4-5 83-4 71789-924 2392-421 4621-61 8280-408 81149-290",
    ": 2016-7 913-35 3019-66 980-4196 92674-705 3025-38 725-63 4848-63",
    ": 7038-47 731-830 62-72 8057-138 443-527 764-819 21-45 9067-89 348-435",
    "# 69 and 84 EST ranges, respectively.",
    "special2 Z+5 embl_other_nuc",
    ": 12653-23155 8355-38124",
    "",
    "# Nominally ddbj_dirsub.",
    "special2 AB+6 ddbj_est",
    ": 158145 279-87 432 9214-7 736-9 63429 31 6724 327169 31173-92 734-46 927-49",
    ": 4239 53143 4879 61047-52 241-4 92-358 4678-9 71430-572 2866-75",
    ": 3997-4042 263-5 5019-60 433981 4937-50 7321-44 46243-391 7894-981 8953-9020",
    ": 50689-761 8260-300 688-789 61364-72 71888-91 4609-19 21-714 6-21 6-39 41-8",
    ": 80784-824 5714-5 64-70 960-92 92065-83 505865-73 9259 16772-956 7053-143 5",
    ": 29438-45 35102-4 7328-9 42429-50 52736-841 3313-5 68279-90 71597-602 2918-21",
    ": 3693-709 5970-8 6812-50 85974-96 94978-5127 602400-24 13266 7526 26803 40724",
    ": 6299-300 21-45 68572-7 9437-64 709967-10073 34662-75 8045-62 42236-51",
    ": 57677-705 811436 23195-214 7265-7 62603-877 3290-461 99003-14 922020-116",
    "# 197 and 80 EST ranges, respectively.",
    "special2 AB+6 ddbj_other_nuc",
    ": 001540-128048 78168-308274",
    "",
    "# Nominally gb_dirsub.",
    "special2 AF+6 gb_est",
    ": 390017 858 1795 801-4 6-7 6868 405213-30 8415-6 11092-9 20231 5300 36075",
    ": 9734 6 961-72 41178-82 4-7 8511-2 51165-81 3-9 3446 4762 6411 61771 8668-72",
    ": 9688-92 86818-9 7314-25 7-9 92356 503187-9 588 6703-6 7053 8 60 10188-90",
    ": 6758-66 20437-9 964 1978-2027 5702 7684-733 33598-600 8926-7",
    "special2 AF+6 gb_gss",
    ": 384864-5 7113-21 96672 7194 400792-848 1241-71 16103-38 35833-7 40734",
    ": 1725 60-9 7921 9707-12 55790-802 65471-4 72511 92012-4 272 4494-5 509571",
    ": 15664-5 21604 4047-260 2-826 5774-5 9172 34530-3 7199-202 42503",
    "special  AF000235-AF373213  gb_other_nuc # 585 EST ranges and 303 GSS ranges",
    "",
    "special  AG266800-AG266855  ddbj_dirsub # Nominally ddbj_gss.",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST and",
    "# GSS ranges.",
    "special2 AJ+6 embl_est",
    ": 131530-1 4 640 743 2447-53 743-4 6-7 68 70 3279-310 423 627-30 823-32 87-91",
    ": 344568-620 5961-6853 7704-8 8845-907 441341-56950 7094-5 215-787 97-801",
    ": 995-8180 9102-5 60001-86853 646897-97608 763-4 8954 9509-703791 4820 66-927",
    ": 5105-15323 6425-7291 9195-266 21139-44704 5200-660 6228-32 346 581-7913",
    ": 9659-68 50001-67053 69-80913 1008-24 3757 4436-774 5005-280 96-566 755",
    ": 6842-809161 10177-8 2737-21279 81-793 924-9440 31476-83 580-6 846-2104",
    ": 3020-569 920420-36931 7840-2 4-6 8-51 3-4 6 8183-64871 6338 532-70 7011-5",
    ": 8963-85 70155-60 2495-503 3481-591",
    "# Respective (EST, GSS) range counts:",
    "# (37, 0); (106, 0); (46, 0); (41, 0); (46, 0); (55, 0); (63, 2).",
    "special2 AJ+6 embl_other_nuc",
    ": 003249-13072 223808-52067 69829-320073 88667-441054 87042-519345 32915-83526",
    ": 601557-46868 843898-920257",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST and GSS ranges.",
    "special2 AL+6 embl_est",
    ": 022607-715 30-3086 993-4449 59-60 33283-374 42366-3422 79357-851 3-77",
    ": 9-80030 2-55 110302-468 7695-8492 560-21566",
    ": 32634 45-7 95-706 81-90 802-17 29-37 910-42 3667-5743 7939-8463 519 57506-686",
    ": 62087-101",
    ": 3072-135 54 96 331-480 93-504 13-22 614-35 43 92-701 12-59 61-2 73-84 892-901",
    ": 352973-5 94-3006 958-85 4617-21 5193-214 755-64 890-912 4-5 7-8 60374-5136",
    ": 523-89869 91923-74 2063-7 441606-20 2-3 9467-917 50491-982 99630-500520",
    ": 42-12267 40321-1353 83964-9147 204-622 96479-603622",
    ": 63683-6314 6-416 8-705 7-821 3-7261 4-371 3-8474 6-875",
    ": 7-9016 8-138 40-810 2 90 994-7 91524-713628 805-37 4032-31499 899-2289 97-307",
    ": 49534-9 41-50301 3-1363 808211-23461 4717-31324 4580-7504 29-40622 45-932",
    ": 1430-4138 226-479 901610-28536 9474-90 609-35024 73-113",
    "special  AL160494-AL161251  embl_gss",
    "# Respective EST range counts:",
    "# 182, 72, 490, 393, 251, 3583, 1244, 3341, 5767, 638.",
    "special2 AL+6 embl_other_nuc",
    ": 034585-42364 3424-9170 513551-40319 1355-83950 93862-6018 627462-63681",
    ": 71927-83797 773605-805894 45558-901606 54873-73407",
    "",
    "# Nominally embl_dirsub.",
    "special2 AM+6 embl_est",
    ": 003907-39430 41272-897 9-928 2018-538 715-8613 9439-915 51087-9 366-5585",
    ": 6504-62638 766-3038 43-71350 401-5 8 10-1 520-2286 430-44 5249-607 83343-946",
    ": 5154-297 8777-109845 10258-692 1128-305 50-1 76-3422 870 5672-94 7760-79",
    ": 37442-56757 7797-8083 9647-60600 1052-90 647-2203 5128-7516 8256-69 526-76418",
    ": 7644-9408 80191-250 4308-228715 9723-30448 1596-607 751-2 2089-226",
    ": 3524 688-739 7575-81 631-802 8-28 59062-6 60753-90 1635-51 893-919",
    ": 3561-5360 78-89 633-7 7321-478 8883-94 79675 83547-4142 5455-649 6691",
    ": 7291-91980 2305 925-6 3570-88 624 5342-5 6550-384871 493773-867 5471-722",
    ": 6020-68 70-7466 8769-500636 8 2267-86 3942-52 4150-600638 95771-6203 311-688",
    ": 713476-43079 50062-65799 6003-73228 4151 9939-849033 823-50054 1127-82506",
    ": 950553-80446 1402-2512 822-3454 577-8621 91118-27 2040-7 256-457",
    "# 21, 23, and 183 EST ranges, respectively.",
    "special2 AM+6 embl_other_nuc",
    ": 384993-422606 743198-8699 894321-950290",
    "",
    "# Nominally ddbj_est.",
    "special2 AU+6 ddbj_dirsub",
    ": 024804-9241 46301-50022 808-15 62283-350",
    ": 6497-8 500 4 6 11-2 4-5 21-4 7-9 35 40-2 4 6 8-53 5 7-8 78429-598 90535",
    ": 279339 78",
    "special  AU036596-AU036726  ddbj_gss",
    "",
    "special  AX114121           embl_dirsub # Nominally embl_patent.",
    "",
    "# Nominally gb_dirsub.",
    "special2 AY+6 gb_est",
    ": 007260 30235-6 2615-6 902 79 3289 42532 8753 63513 93804-17 6240 120880",
    ": 5856-90 39011-23 60682 6588 8429-39 89691-2 5 96929-33 243511 5441 311391",
    ": 21461-2 5801-2 6073 45126 7477 56158-311 7293-5 77860-4 95905 449735-46",
    ": 57064-5 60108-11 5830-2 94600-4 517518 8259-64 47439-57 53914 60545-6 8-50",
    ": 77286-7 89693-4 700-1 4 8-10 651316 78444-9 9774-8 86735-47 8838-40 714068-71",
    ": 36327 40678 50901-4 88904 96341 803125-65 31429 79586-91 85220-1 922984-8",
    ": 8802-5 52968-70 66462-85 87852 94354-6",
    "special2 AY+6 gb_gss",
    ": 026952-7433 38985-7 9709-12 55854 79522-80585 123938 7080-557 56078-82",
    ": 60080-2 6650-1 74766-78 98434-201593 5-640 2-91 3-3610 44458 65801-4 70178-81",
    ": 82782-5 352272-3 66892-9 91730-44 489065-6 91396-8 580990-4 3837 648006-7",
    ": 65687 85649-61 758600-60022 98-631 40-1013 822675-7 31657-67 8273-7 57201",
    ": 66420-4 70328 2191-255 390-3704 98612 993980-4",
    "",
    "# Nominally embl_dirsub.",
    "special2 BX+6 embl_est",
    ": 000562-687 710-59 976-9 88730-119313 401-900 248593 783-982 6-9708 63-51408",
    ": 14-5275 9-804 79530-83066 8-4108 94120-1 98-232 5243-348 50-8 60-78 80-516 8",
    ": 318044-558 466087-922 7129-9883 70269-510298 1045-7 314-23 33-26833 5-30014",
    ": 48257-69683 601649-29297 361-40397 1173-7061 63509 77677-8768 77-9656",
    ": 76-81414 9-2226 40-527 59-952 6-769172 7-84021 33 44-278 81-385 834112-41509",
    ": 61004-521 3-681 3-2186 7358-914 72508-3028 9625-80165",
    ": 9494-90135 7-88 90-8 200-2 4-24 6-32 4-308 10-94 6-483 5-537 7754-9178",
    ": 82-901874 27416-8738 59-9267 50875-7214 366-7",
    "# Respective EST range counts:",
    "# 403, 815, 309, 42, 5821, 79, 573, 596, 51, 66, 76, 119, 343.",
    "special2 BX+6 embl_other_nuc",
    ": 072585-88684 255991-79521 96570-318042 560-21855 3813-465182 540327-980",
    ": 664722-77662 842705-61002 2188-7356 916-72506 3030-9623 80167-9492",
    ": 908815-27274",
    "",
    "# Nominally gb_genome.",
    "special2 CP+6 gb_dirsub",
    ": 000925 2027 6698 10455-6 3186 4940 92 6816",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 CR+6 embl_est",
    ": 278161-93495 407721-50243 7485-77643 502047 59947-89873 627501-8310 421-31118",
    ": 735161-49142 881-51205 41-527 621-2637 62-728 30-981",
    ": 3-3092 4-178 80-308 10-27 9-416 8-20 2-508 10-608 10-33 5-50 2-793 5-802 4-11",
    ": 907-9280 2-423 5-701 3-31 62499-4089 98-7811 22-9762 70518-4176 201-5849",
    ": 86583-8225 341-90347 90-2412 926157 498-878 80-6 8-910",
    ": 2-7049 51-214 6-367 9-455 7-78 80-552 4-31631 8765-40296 2245-70 5 825-4659",
    ": 74421 599-99998",
    "# 315, 307, 134, and 70 EST ranges, respectively.",
    "special2 CR+6 embl_other_nuc",
    ": 354614-94505 450855-7481 513801-59927 848861-57055",
    "",
    "# Nominally embl_dirsub.",
    "special2 CT+6 embl_est",
    ": 000001-5229 9777-10161 409-25 25916-7 485799-989 563249-71240 79-2707",
    ": 4594-83622 731-737118 258 62376-504 6185-353 73820-949 51-4143 912-5059",
    ": 7272-416 80757-877 1913-2070 2-90 2-100 2-10 2-24 6-50 2-83 5-7 9-321",
    ": 6112-237 92226-352 3397-519 4724-853",
    ": 842009-118 20-1 3-30 2-47 9-58 60-78 80-1 3-516 8-28 30-1 3-40 2-63709 15-33",
    ": 8744-928681 3-38375 43670-50687 62514-3069 97-104 71504-71",
    ": 8604 6-46 8-9 51-2 4 6-77 9 81 3 5-926 8-56 8-89251 8-90465 74-86 90-531",
    "# Respective EST range counts:",
    "# 1381, 153, 322, 37, 84, 137, 39, 147, 219, 36, 48, 2036, 367",
    "special2 CT+6 embl_other_nuc",
    ": 737431-62374 507-6183 355-73818 4146-910 5061-7270 418-80755 879-1911",
    ": 2323-6110 239-92224 354-3395 521-4722 855-823556 938377-40347",
    "",
    "# Nominally embl_dirsub.",
    "special2 CU+6 embl_est",
    ": 062670-842 4-6 8-74269 339-82 423-5311 931-6039 234182-94 302207 9-16 324",
    ": 6818-10069 76-1182 67886-8379 81-441 3-521 3-6 8-600 2-745 7-50",
    ": 2-9046 8-187 9-553 5-65 7-72896 931-92058 4257-405559 15883-24422 74 96-42700",
    ": 64-57374 87231-98825 9388-524144 6-85 7-607 9-47",
    ": 9-5008 10-305 7-17 9-433 5-727 9-806 8-920 2-30337 421-8870 9140-50647",
    ": 735-65320 96016-606845 7105-11033 62-8304 43-27974 8007-33156 7754-8663",
    ": 9489-40365 490-880 60014-72219 81473-818",
    ": 2012-338 67-456 8-575 7-600 2-3 5-21 3-39 41-61 3-763 5-6 8-76 8-9 81-810",
    ": 2-3823 8-64 4056-6587 93503-4195 5349-740080 862081-96531 700-905499",
    ": 513-14123 83906-4539 6307-93795 823-9999",
    "# Respective (EST, GSS) range counts: (81, 1); (43, 0); (231, 0); (41, 0).",
    "special2 CU+6 embl_other_nuc",
    ": 457503-87206 98835-9386 565322-96014 651679-60012",
    "",
    "# Nominally ddbj_gss.",
    "special2 DE+6 ddbj_dirsub",
    ": 990447-894 7363-8419",
    "",
    "# Nominally gb_dirsub.",
    "special2 DQ+6 gb_est",
    ": 000203-5 3271-4 5448-52 6915-21 8074-87 9493 10056 23561-96 54537 6320-36",
    ": 62432 8265-7 71657-67 9655-7 82731 90495-9 118389-93 9294 38061-9 59946-7",
    ": 72857-99 90447-9 205195-9 7956 11055-83 697 7772 25105-7 38007-10 56365-8",
    ": 86755-9 96475-80 301872-6 6698-705 41431-41 9205-6 51838-40 4361 94888-90",
    ": 672588 821447-72 2605-89 58157-64 73299-317 83824-4159 6384-9 999011-23",
    "special2 DQ+6 gb_gss",
    ": 072281-378 3526-30 92578-99 3275-84 103519-23 14785 5593-640 24861-7 31496",
    ": 7423-5 56350-63 60233-40 76001-2 8992-4 219385-92 323032-5 9527-9 34866",
    ": 51716-21 99337-8 530238 641039 866805 988883-928",
    "",
    "# Nominally gb_con.",
    "special2 DS+6 gb_dirsub",
    ": 483562 659",
    ": 4496-515 8-35 8-50 2-3 5-74 6-611 4-23 5-6 8-33 5-7 9 41-54 6-75 7-86 8-703",
    ": 6-7 9-10 2-6 8-42",
    ": 5148-67 9 72-4 6-8 81-2 4 6 9-90 2 4-5 8-201 3-5 8-9 11 5-6 8-21 3-30 3 5-6",
    ": 8-40 2-3 5-7 9-68 70-1 3 5 7-8 80-1 3-5 7-8 90-2 4 6-306 9-11 3-6 8-20 2-6",
    ": 8-31 3-43 5 9 51 3-4 6-65 8 70-1 4-6 8-9 81-90 2-3 5 7-401 3 7 9-11 5-6 8-30",
    ": 3-4 6-43 8 50-4 6-7 9-62 4-73 5-8 81-3 8 90-2 4-8 500-1 3-6 9 12 4-5 7-8 20-3",
    ": 5-45",
    "# 159, 80, and 95 dirsub ranges, respectively.",
    "special2 DS+6 gb_other_nuc",
    ": 483744-4493 745-5146 547-6008",
    "",
    "# Nominally gb_dirsub.",
    "special2 EF+6 gb_est",
    ": 063001 189906-16 377525-37 422869 73211-5 94771-3 552376",
    "special2 EF+6 gb_gss",
    ": 053039-49 95769 165098 82756-8 204530-3 8191 10438-53 578434-635 92824-944",
    "",
    "# Nominally gb_dirsub.",
    "special2 EU+6 gb_est",
    ": 152056-79 239816 364506-7 8044 9669 420034 597223-8",
    "special  EU306364-EU306386  gb_gss",
    "",
    "# Nominally gb_dirsub.",
    "special2 FJ+6 gb_est",
    ": 710154-5 842632-42",
    "",
    "# Nominally embl_dirsub.",
    "special2 FM+6 embl_est",
    ": 000001-160408 4769 940 5392 707-72746 8562-778 80579-96445 205236-493 777-831",
    ": 7878-900 8280-711 851 900 12937 5048-42054 6886-51871 3361 6-8 72 8 864313-44",
    ": 7-5295 8295-72275 9143-81767 2258-3162 5959-6821 7038-96881 7212-3",
    ": 377-945301 441-999 6183-54971 7013-79 8532-85957 92847-50 9776-87",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 FN+6 embl_est",
    ": 000001-177896 9489-82188 288-5725 6135-90445 7-252183 460-789 63376-92969",
    ": 377870-86264 93571-732 830-49 424437-8571 30839-1219 34-660",
    ": 2032-41 154-328 729-75 3834-7 5336-50 539079-43092 51261-733 2552-91 699-705",
    ": 5710-987 7216-23 61898-924 2175-396 4151-8 5576-6839 88437-94512 600697",
    ": 1407-10843 1035-40462 581-1653 925-3079 6764-7626 51825-6 2903-4 61971-2351",
    ": 4012-5290 9777-73545 9295-86775 91927 2044-706436 565-73062 104-70 96618-723",
    ": 987-806772 826-48 11794-851 944-2314 3225-6 467-9 4310-20203 2244-743 3242-54",
    ": 68597 902-29 9177-376 70962-907899 8254-302 85040 644-93914 7680-8838",
    ": 9023-906",
    "",
    "# Nominally embl_dirsub.",
    "special2 FO+6 embl_est",
    ": 000003-76577 82887-117570 633-81358 544-203352 528-393391 680693-1285",
    ": 704924-22023 981374-99999",
    "",
    "# Nominally embl_dirsub.",
    "special2 FP+6 embl_est",
    ": 000001-3579 602-9753 5-8 60-1 3-4 6-12228",
    ": 24615-57328 30-70 456-62 562-6 704-9",
    ": 8162-3 5 7 9 71-2 4 6-7 80 3-90 282 4 6 526-7 9 31-2 4 7 9 42-3 5 7-53 708-13",
    ": 9328 30-2 4 7 9 41 3 5 8-52 87-93 60212-7 1764-9 2315-21",
    ": 3036-40 449-53 804-12 900-4 5159-7333 453-74848 89705-949 90914-1223",
    ": 101920-50 4570-236120 870-43270 5546-312611 8637-25096 31359-9571",
    ": 630-40170 462-88 50355-60034 6-458874 6-75875 89021-539727 30-65142 937-78983",
    ": 9010-83343 56-628470 2-71119 40-80548 607-90338 50-700052 189-10243 58-91398",
    ": 400-884219 35-5524 45-822 927-93245 7-924936 7985-8978 90-5 9145-99998",
    "# Respective EST range counts: 33, 43, 39, 16, 141, 45, 33, 95, 44, 15, 248,",
    "# 14, 187, 22, 136, 104, 552, 234, 246, 39, 11, 166, 154, 35, 74, 208, 251.",
    "special2 FP+6 embl_other_nuc",
    ": 057373-454 65-560 8-656 64-702 11-8036 42-155 92-271 93-514 56-658 73-706",
    ": 15-9322 54-85 95-833 41-87 95-60210 9-469 77-1762 71-2313 24-896 906-99",
    ": 3008-34 43-447 55-802 14-98 906-4076 82-562 9-5157",
    "",
    "# Nominally embl_dirsub.",
    "special2 FQ+6 embl_est",
    ": 000001 5-14216 36-32656 836-73829 967-116746 8-209379 35350-42479",
    ": 312199-23093 164-61146 9-77486 8-516 98062-439981 3-40019 21-2 4 6 8 30-2",
    ": 4-56868 75-82045 8-71 660554-70147 790408-828345 8-57191 9091-175 87-65452",
    ": 7-908260 7-58209 13-76554 923-99999",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con or embl_genome, but split out EST and TPA(!)",
    "# ranges.",
    "special2 FR+6 embl_est",
    ": 595163-647444 60151-6602 8536 9245-6 86584 963-5 8150-9535 91564 7056-714330",
    ": 9326-692 26163-5 8240-1 9927-31105 4407-44448 6042-4 111-7822 8230-9648",
    ": 53167-4317 554-71822 3977 5966 819721-44 28827-31799 6483-7532 42-92",
    ": 9767-45655 6456-60 537-887 7124-45 228-840 88-943 8368-71 50135-57 1958",
    ": 2768 894-904 4398-6581 63689-4978 9720-95 73995-4005 7779-8008 32-40",
    "special2 FR+6 embl_tpa_nuc",
    ": 734011-74 49997 821738-54 2741 72817 7768-77",
    "",
    "special  GQ162211-GQ162212  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 GU+6 gb_est",
    ": 357827-40 85812",
    "",
    "# Nominally embl_dirsub.",
    "special2 HE+6 embl_est",
    ": 575663-7 8177-80 289-716 80226-8 600073-122 2495-530 12182 7969-46283",
    ": 81861-82 775617-92769 5538-641 9315-645 802076-106 58615-9937 62417-958",
    ": 957083-61812 2539 7924-57 81808-3324 5332-93548",
    "special2 HE+6 embl_tpa_nuc",
    ": 580237-8 3424-588 613800 804769-72 963851-4756 7761",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST, TPA(!), and WGS ranges.",
    "special2 HF+6 embl_est",
    ": 546137-200 978 66097-123 7775-843 952730-71 3988-4002",
    "special2 HF+6 embl_tpa_nuc",
    ": 564658-815 933207-30",
    "special  HF913790-HF920632  embl_wgs_nuc",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST and TPA(!) ranges.",
    "special2 HG+6 embl_est",
    ": 000495-664 1312-9 314154-951 26529-98 421036-67 4982-5075 516089-8058",
    ": 792878-996 8530-3 964498-527 5112-28 70048-64",
    "special2 HG+6 embl_tpa_nuc",
    ": 313979-4002 22958-3812 8835-9089 425120-3 6065-183 91497-512884 8794-28968",
    ": 31973-2008 780872-92014 931734-849 75377-438 7712-83278 548-6399",
    "",
    "special  HM042681           gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 HQ+6 gb_est",
    ": 385980-98 436350 596498-504 603829-54 16895-912 34394-477",
    "",
    "special  JN376805-JN377341  gb_est # Nominally gb_dirsub.",
    "",
    "special  KF487514           gb_est # Nominally gb_dirsub.",
    "",
    "special  KJ472321-KJ472336  gb_est # Nominally gb_dirsub.",
    "",
    "special  KM673248-KM673271  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally embl_dirsub.",
    "special2 LK+6 embl_tpa_nuc",
    ": 000001-20668 937705-9125",
    "special  LK985528-LK995307  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special2 LM+6 embl_tpa_nuc",
    ": 378690-83429 608092-11902 44135-234",
    "special  LM994684-LM994695  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, but split out EST and TPA(!) ranges.",
    "special2 LN+6 embl_est",
    ": 624403-4 51082-92 553-78462 80257-71 879549-837 901386-412",
    "special2 LN+6 embl_tpa_nuc",
    ": 607841-8991 714474-514 94245-6 809256-883 46618-9 7449-8230 9001 71971-2940",
    ": 4312-522 85135-43 5-62 4-70 2-202 4-36 98187-98 901194-210",
    "",
    "# Nominally embl_dirsub.",
    "special2 LR+6 embl_tpa_nuc",
    ": 130242-508 594708-9 760818-1312",
    "",
    "# Nominally embl_dirsub.",
    "special2 LT+6 embl_est",
    ": 159851-65 556286-8089",
    "special2 LT+6 embl_tpa_nuc",
    ": 548096-244 71433-5 605004 31550-670 906301-58 62964-3174 90249-597",
    "",
    "# Nominally (conservatively) embl_other_nuc.",
    "special  OB000001-OB660024  embl_con",
    "",
    "# Some \"EMBL\" WGS nucleotide accessions are really third-party annotations.",
    "special2 CAADSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAADSM000000000-CAAGJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKD000000000-CAAGKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKS000000000-CAAGRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGRK000000000-CAAGSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAAHDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAAHDO000000000-CAAHFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABPVU000000000-CABUTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABUTU000000000-CABVEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CABVEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CABVEX000000000-CABVGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEPO000000000-CADEVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEVJ000000000-CADFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFHD000000000-CADFHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFIN000000000-CADFIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFIS000000000-CADFIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJH000000000-CADFJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJU000000000-CADFJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFKF000000000-CADFKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFLF000000000-CADFLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFMR000000000-CADFMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFNR000000000-CADFNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFNW000000000-CADFNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOI000000000-CADFOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOT000000000-CADFOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFOX000000000-CADFOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPF000000000-CADFPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPM000000000-CADFPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPX000000000-CADFPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFQP000000000-CADFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFRV000000000-CADFRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFRY000000000-CADFSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFSS000000000-CADFST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTF000000000-CADFTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFTJ000000000-CADFTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTU000000000-CADFTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFUE000000000-CADFUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUH000000000-CADFUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUM000000000-CADFUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUQ000000000-CADFUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADKUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIC000000000-CAJJID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJIG000000000-CAJJIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIQ000000000-CAJJJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJJM000000000-CAJMTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJSFZ000000000-CAJSGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTIX000000000-CAJTJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTJE000000000-CAJTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJS000000000-CAJTJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJY000000000-CAJTKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKG000000000-CAJTKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKU000000000-CAJTXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTXK000000000-CAJURP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJURR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJURT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJURV000000000-CAJUSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUSD000000000-CAJUSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUSZ000000000-CAJUTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTJ000000000-CAJUTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTV000000000-CAJUTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUTY000000000-CAJUUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVG000000000-CAJVVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVR000000000-CAJVVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJVVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJVWG000000000-CAJYBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJYCH000000000-CAJYCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJYLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZDA000000000-CAJZFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZFU000000000-CAJZHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHD000000000-CAJZHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZHR000000000-CAJZHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHV000000000-CAJZHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZIB000000000-CAJZJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZKB000000000-CAJZLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLC000000000-CAJZLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLJ000000000-CAJZLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKAEN000000000-CAKAIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKAOQ000000000-CAKASD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMHW000000000-CAKMJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMKY000000000-CAKMLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLJ000000000-CAKMLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLM000000000-CAKMME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMH000000000-CAKMMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKMMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMMU000000000-CAKMMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMX000000000-CAKMMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNB000000000-CAKMNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNH000000000-CAKMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNX000000000-CAKMRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMRL000000000-CAKMRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKNFQ000000000-CAKNSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZFW000000000-CAKZJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZJV000000000-CAKZRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSL000000000-CAKZSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSR000000000-CAKZST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZSW000000000-CAKZTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTH000000000-CAKZTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTR000000000-CAKZTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZTU000000000-CAKZTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUC000000000-CAKZUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZUH000000000-CAKZUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUW000000000-CAKZUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZVO000000000-CAKZVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZVV000000000-CAKZWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWG000000000-CAKZWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWR000000000-CAKZWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZXB000000000-CAKZYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZZB000000000-CALAHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAHT000000000-CALAIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIG000000000-CALAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIK000000000-CALAIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIP000000000-CALAIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALAJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJI000000000-CALAJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJW000000000-CALAJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKA000000000-CALAKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKF000000000-CALAKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKI000000000-CALAKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKN000000000-CALAKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKS000000000-CALAKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKV000000000-CALAKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALALA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALALC000000000-CALAMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMJ000000000-CALAMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAMR000000000-CALAMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMY000000000-CALAMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALANB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALANE000000000-CALANI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALANK000000000-CALANX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOA000000000-CALAOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOD000000000-CALAOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOG000000000-CALAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAPC000000000-CALBAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAE000000000-CALBAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAL000000000-CALBBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBI000000000-CALBBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBR000000000-CALBCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBCP000000000-CALBCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBDC000000000-CALBDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDH000000000-CALBDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDP000000000-CALBDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEH000000000-CALBEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEM000000000-CALBUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUJ000000000-CALBUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUR000000000-CALBUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBVB000000000-CALBVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBWE000000000-CALBWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWL000000000-CALBWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWT000000000-CALCDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCDE000000000-CALCIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCIP000000000-CALCJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCJW000000000-CALCKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKH000000000-CALCKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKS000000000-CALCKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCKZ000000000-CALCLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLM000000000-CALCLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLQ000000000-CALCMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMF000000000-CALCMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCML000000000-CALCMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMW000000000-CALCRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCRJ000000000-CALCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCUX000000000-CALDAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBA000000000-CALDBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBI000000000-CALDCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCD000000000-CALDCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCM000000000-CALDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCP000000000-CALDCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCU000000000-CALDDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDJ000000000-CALDDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDS000000000-CALDDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDW000000000-CALDDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDZ000000000-CALDEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEC000000000-CALDEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEQ000000000-CALDEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEX000000000-CALDEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDFC000000000-CALDFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDGB000000000-CALDGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGG000000000-CALDGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGO000000000-CALDGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGR000000000-CALDHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDHN000000000-CALDHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDIA000000000-CALDKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDKW000000000-CALDSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUU000000000-CALDUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUZ000000000-CALDVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVD000000000-CALDVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVQ000000000-CALDVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVX000000000-CALDVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWB000000000-CALDWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWH000000000-CALDWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWS000000000-CALDWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWX000000000-CALDWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXA000000000-CALDXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXK000000000-CALDXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXZ000000000-CALDYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDYD000000000-CALDYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDZM000000000-CALDZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEAA000000000-CALEAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAH000000000-CALEAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAR000000000-CALEAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAW000000000-CALEBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBL000000000-CALEBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBU000000000-CALECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECC000000000-CALECD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECG000000000-CALECO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECR000000000-CALECS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECU000000000-CALECY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDA000000000-CALEDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALEDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEDO000000000-CALEDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDX000000000-CALEEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEED000000000-CALEPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPF000000000-CALEPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPL000000000-CALETK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETM000000000-CALETT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETV000000000-CALETW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETY000000000-CALEUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUH000000000-CALEUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEUR000000000-CALEUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUZ000000000-CALEVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEVS000000000-CALEVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWA000000000-CALEWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWG000000000-CALEWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWK000000000-CALEWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWZ000000000-CALEXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEXQ000000000-CALEXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYB000000000-CALEYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYE000000000-CALEYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYL000000000-CALFAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFAN000000000-CALFAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFAW000000000-CALFAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCC000000000-CALFCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCJ000000000-CALFCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFCW000000000-CALFCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDB000000000-CALFDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDJ000000000-CALFDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDO000000000-CALFDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDV000000000-CALFDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEC000000000-CALFED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEF000000000-CALFFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFF000000000-CALFFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFL000000000-CALFSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFSK000000000-CALFUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFUY000000000-CALFVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFXA000000000-CALGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGAX000000000-CALGJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKF000000000-CALGKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKO000000000-CALGKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGKW000000000-CALGLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLF000000000-CALGLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLK000000000-CALGLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMG000000000-CALGMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMK000000000-CALGML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGMP000000000-CALGMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMU000000000-CALGMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNB000000000-CALGNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGNL000000000-CALGNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNQ000000000-CALGNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGOH000000000-CALGPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGPP000000000-CALGPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQD000000000-CALGQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGQM000000000-CALGQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQY000000000-CALGVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGVQ000000000-CALGVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWA000000000-CALGWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWI000000000-CALGWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWO000000000-CALGWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGWZ000000000-CALGXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGXC000000000-CALGXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXO000000000-CALGXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXW000000000-CALGXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGYC000000000-CALGYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZE000000000-CALGZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZP000000000-CALHAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHAC000000000-CALHAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBG000000000-CALHBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBM000000000-CALHBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBS000000000-CALHBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBX000000000-CALHCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHCR000000000-CALHDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDH000000000-CALHDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDZ000000000-CALHED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEF000000000-CALHEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEL000000000-CALHEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEP000000000-CALHFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFH000000000-CALHFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFR000000000-CALHGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGF000000000-CALHGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGK000000000-CALHGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHGR000000000-CALHGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHA000000000-CALHHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHD000000000-CALHHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHI000000000-CALHHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHR000000000-CALHHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHZ000000000-CALHIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIC000000000-CALHIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIM000000000-CALHIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHIY000000000-CALHJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJG000000000-CALHJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJL000000000-CALHJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJP000000000-CALHKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKL000000000-CALHKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKR000000000-CALHLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLG000000000-CALHLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLX000000000-CALHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMD000000000-CALHMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMH000000000-CALHML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMN000000000-CALHMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMW000000000-CALHMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHND000000000-CALHNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHNL000000000-CALHNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNT000000000-CALHNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNY000000000-CALHOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOJ000000000-CALHOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOV000000000-CALHOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOY000000000-CALHPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPL000000000-CALHPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPV000000000-CALHQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHQD000000000-CALHQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHQZ000000000-CALHRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRE000000000-CALHRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRK000000000-CALHRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRR000000000-CALHRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRX000000000-CALHRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHSC000000000-CALHSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHSW000000000-CALHSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHTC000000000-CALHTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTG000000000-CALHTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTS000000000-CALHTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUB000000000-CALHUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUJ000000000-CALHUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHUN000000000-CALHUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHVE000000000-CALHVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVI000000000-CALHVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVQ000000000-CALHVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVY000000000-CALHWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWL000000000-CALHWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWP000000000-CALHXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHXD000000000-CALHXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXJ000000000-CALHXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXX000000000-CALHYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYF000000000-CALHYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYN000000000-CALHYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYZ000000000-CALHZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZQ000000000-CALHZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZW000000000-CALIAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAH000000000-CALIAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAV000000000-CALIBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIBS000000000-CALICB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICD000000000-CALICL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICN000000000-CALIDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDJ000000000-CALIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDM000000000-CALIDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDS000000000-CALIEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEC000000000-CALIED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEF000000000-CALIEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEJ000000000-CALIEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEO000000000-CALIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIES000000000-CALIFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFN000000000-CALIFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFZ000000000-CALIGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIGJ000000000-CALIGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIGS000000000-CALIHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHC000000000-CALIHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHG000000000-CALIHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHM000000000-CALIHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIHX000000000-CALIHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIID000000000-CALIIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIM000000000-CALIIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIQ000000000-CALIIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIIZ000000000-CALIJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIJF000000000-CALIJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJK000000000-CALIJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJN000000000-CALIJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKA000000000-CALIKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKY000000000-CALILA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILC000000000-CALILO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILQ000000000-CALIMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMM000000000-CALIMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMY000000000-CALINA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALING000000000-CALINI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALINK000000000-CALINL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALINR000000000-CALIOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIOF000000000-CALIOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOM000000000-CALIOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOU000000000-CALIOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOY000000000-CALIPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIPD000000000-CALIQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQF000000000-CALIQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQP000000000-CALIRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIRE000000000-CALIRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIRT000000000-CALISA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISE000000000-CALISJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISL000000000-CALISN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISQ000000000-CALIST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISX000000000-CALITB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITD000000000-CALITI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITK000000000-CALITL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITQ000000000-CALITU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITW000000000-CALIUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUC000000000-CALIUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIUP000000000-CALIUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUZ000000000-CALIVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVF000000000-CALIVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVO000000000-CALIVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVU000000000-CALIWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIWU000000000-CALIWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXB000000000-CALIXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXL000000000-CALIXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXO000000000-CALIXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXV000000000-CALIYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZC000000000-CALIZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZG000000000-CALIZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZJ000000000-CALIZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAB000000000-CALJAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAF000000000-CALJAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJAR000000000-CALJAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBA000000000-CALJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBI000000000-CALJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBO000000000-CALJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBR000000000-CALJBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBU000000000-CALJBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCA000000000-CALJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCG000000000-CALJCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCZ000000000-CALJDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJDI000000000-CALJDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDL000000000-CALJDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDP000000000-CALJDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDV000000000-CALJED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJIE000000000-CALJIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJII000000000-CALJIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIO000000000-CALJIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIR000000000-CALJIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIV000000000-CALJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJA000000000-CALJJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJD000000000-CALJJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJJS000000000-CALJJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJKA000000000-CALJMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJME000000000-CALJMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMJ000000000-CALJMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMV000000000-CALJMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJNF000000000-CALJNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNK000000000-CALJNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNS000000000-CALJNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNW000000000-CALJNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJON000000000-CALJPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPK000000000-CALJPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPR000000000-CALJPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJPU000000000-CALJQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJQL000000000-CALJQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJQY000000000-CALJRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJRX000000000-CALJSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSC000000000-CALJSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSR000000000-CALJSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSW000000000-CALJTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTQ000000000-CALJTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTW000000000-CALJVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWM000000000-CALJWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWP000000000-CALJWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJWU000000000-CALJWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJXC000000000-CALJXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXF000000000-CALJXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXP000000000-CALJXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXV000000000-CALJYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYD000000000-CALJYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYI000000000-CALJYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYS000000000-CALJYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYX000000000-CALJZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJZV000000000-CALKBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKBJ000000000-CALKBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKHJ000000000-CALKIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKC000000000-CALKKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKO000000000-CALKKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKW000000000-CALKLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKLG000000000-CALKLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLQ000000000-CALKLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLT000000000-CALKLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLY000000000-CALKMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMD000000000-CALKME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMG000000000-CALKMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALKMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKPG000000000-CALKPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPN000000000-CALKPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPZ000000000-CALKQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKQX000000000-CALKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRL000000000-CALKRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRO000000000-CALKRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRV000000000-CALKRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKSA000000000-CALKTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTI000000000-CALKTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTV000000000-CALKUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKUX000000000-CALKUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVB000000000-CALKVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVQ000000000-CALKXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKYE000000000-CALKZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZI000000000-CALKZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZO000000000-CALKZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLAX000000000-CALLAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLBP000000000-CALLBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBS000000000-CALLBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBV000000000-CALLCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCI000000000-CALLCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCP000000000-CALLCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDB000000000-CALLDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDI000000000-CALLDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDM000000000-CALLDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDQ000000000-CALLDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEA000000000-CALLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEJ000000000-CALLEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEO000000000-CALLEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLES000000000-CALLEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEY000000000-CALLEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFB000000000-CALLFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFI000000000-CALLFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFN000000000-CALLFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGB000000000-CALLGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGE000000000-CALLGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGL000000000-CALLGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGQ000000000-CALLGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGT000000000-CALLHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHJ000000000-CALLHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHM000000000-CALLHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHV000000000-CALLIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLIR000000000-CALLJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLJV000000000-CALLKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLMO000000000-CALLMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLMW000000000-CALLND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNF000000000-CALLNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNU000000000-CALLNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLOC000000000-CALLOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLOT000000000-CALLPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLPF000000000-CALLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQD000000000-CALLQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQS000000000-CALLQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRA000000000-CALLRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLRS000000000-CALLRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRV000000000-CALLTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLTY000000000-CALLUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLUC000000000-CALLUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLVJ000000000-CALLVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLVZ000000000-CALLWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWC000000000-CALLWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWP000000000-CALLWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWW000000000-CALLXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLXL000000000-CALLYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLYJ000000000-CALMEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMEZ000000000-CALMHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMHR000000000-CALMKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMKR000000000-CALMRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMRJ000000000-CALMVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMVE000000000-CALMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMWD000000000-CALNCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALNEE000000000-CALNHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALNPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALNRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPDC000000000-CAMPDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPDW000000000-CAMPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPGF000000000-CAMPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPLK000000000-CAMPOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPTU000000000-CAMPTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPTY000000000-CAMPUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUE000000000-CAMPUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUH000000000-CAMPUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPUW000000000-CAMPUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVA000000000-CAMPVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPVO000000000-CAMPVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVV000000000-CAMPVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVY000000000-CAMPWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWN000000000-CAMPWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPWQ000000000-CAMPWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWY000000000-CAMPXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPXG000000000-CAMPXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYB000000000-CAMPYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYS000000000-CAMPYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYX000000000-CAMPYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZA000000000-CAMPZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZD000000000-CAMPZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAO000000000-CAMQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAT000000000-CAMQAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQAW000000000-CAMQBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBG000000000-CAMQBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBP000000000-CAMQBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCD000000000-CAMQCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCK000000000-CAMQCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQCR000000000-CAMQCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQDC000000000-CAMQDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQEN000000000-CAMQEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQEQ000000000-CAMQET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQFA000000000-CAMQFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQFR000000000-CAMQFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQGL000000000-CAMQPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQQL000000000-CAMQTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTS000000000-CAMQTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTX000000000-CAMQUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQUF000000000-CAMQUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVB000000000-CAMQVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVF000000000-CAMQVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVW000000000-CAMQWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWL000000000-CAMQWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWR000000000-CAMQWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWU000000000-CAMQWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWZ000000000-CAMQZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQZN000000000-CAMQZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAA000000000-CAMRAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAT000000000-CAMRAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRBA000000000-CAMREN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMREP000000000-CAMRFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMRGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMRSF000000000-CAMRXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSBO000000000-CAMSEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSEM000000000-CAMSLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSLO000000000-CAMSTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSTY000000000-CAMTCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTDX000000000-CAMTSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTZD000000000-CAMUPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUPX000000000-CAMUSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSG000000000-CAMUSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSS000000000-CAMWBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWBP000000000-CAMWCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWCU000000000-CAMWEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWEC000000000-CAMXAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXAS000000000-CAMXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXAX000000000-CAMXAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXBB000000000-CAMXBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXCV000000000-CAMXCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXHZ000000000-CAMXUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXVC000000000-CAMYGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGH000000000-CAMYGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGS000000000-CAMYHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYHI000000000-CAMYIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYOQ000000000-CAMYPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMYPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMYPF000000000-CAMYTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYTY000000000-CAMZJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMZXK000000000-CANACM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANACO000000000-CANAFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAFJ000000000-CANAHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAIF000000000-CANAKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAMA000000000-CANASN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANASP000000000-CANATP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATR000000000-CANATX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATZ000000000-CANAUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAUM000000000-CANAZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAZJ000000000-CANAZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAB000000000-CANBAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAL000000000-CANBCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBCM000000000-CANBKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBKY000000000-CANBMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANCXK000000000-CANDNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDOE000000000-CANDWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDYS000000000-CANERT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNOB000000000-CANNPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNVC000000000-CANNWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNYW000000000-CANNZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOAG000000000-CANOAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOBF000000000-CANOOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOOR000000000-CANOQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOQQ000000000-CANPDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDG000000000-CANPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDN000000000-CANPDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPDW000000000-CANPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEA000000000-CANPEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEG000000000-CANPEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEK000000000-CANPEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPEQ000000000-CANPER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPET000000000-CANPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEW000000000-CANPFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPFO000000000-CANPFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFT000000000-CANPFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFY000000000-CANPFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGB000000000-CANPGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGH000000000-CANPGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGK000000000-CANPGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPHE000000000-CANPIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPIX000000000-CANPJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPJF000000000-CANPJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJK000000000-CANPJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJP000000000-CANPJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJS000000000-CANPJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKB000000000-CANPKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKT000000000-CANPKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPKW000000000-CANPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPLB000000000-CANPLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPMR000000000-CANPMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMV000000000-CANPMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMZ000000000-CANPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPNS000000000-CANPNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOC000000000-CANPOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPOH000000000-CANPOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOS000000000-CANPOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPPA000000000-CANPPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPPE000000000-CANPPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPRF000000000-CANPRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPTS000000000-CANPTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUC000000000-CANPUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUG000000000-CANPUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANRQJ000000000-CANSGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSGE000000000-CANSNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSOA000000000-CANSTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSTO000000000-CANSXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXC000000000-CANSXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXI000000000-CANSZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSZE000000000-CANTAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTAM000000000-CANTDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTDX000000000-CANTFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTFN000000000-CANTKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBL000000000-CAOJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBO000000000-CAOJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOJBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOJBX000000000-CAOJBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCC000000000-CAOJCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCT000000000-CAOJWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJWM000000000-CAOJZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJZG000000000-CAOKAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKAG000000000-CAOKEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKEH000000000-CAOKFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKFG000000000-CAOKNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKNN000000000-CAOKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRM000000000-CAOKRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRP000000000-CAOKSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKSU000000000-CAOKTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTU000000000-CAOKTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTX000000000-CAOKXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKXC000000000-CAOKXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOKZN000000000-CAOKZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLAE000000000-CAOLAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLAX000000000-CAOLAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLBW000000000-CAOLBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLCR000000000-CAOLCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLDA000000000-CAOLDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLDG000000000-CAOLDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEA000000000-CAOLEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEO000000000-CAOLEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEX000000000-CAOLEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLFF000000000-CAOLFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLHA000000000-CAOLHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHE000000000-CAOLHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHK000000000-CAOLHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLHW000000000-CAOLHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLIZ000000000-CAOLJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLLN000000000-CAOLLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLLX000000000-CAOLLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLMG000000000-CAOLMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLNJ000000000-CAOLNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLOZ000000000-CAOLPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLPX000000000-CAOLPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLRH000000000-CAOLRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLRQ000000000-CAOLRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLSL000000000-CAOLSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLSS000000000-CAOLST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLTW000000000-CAOLTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUF000000000-CAOLUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLUU000000000-CAOLUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLWD000000000-CAOLWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLWJ000000000-CAOLWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLXG000000000-CAOLXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLXW000000000-CAOLXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLYM000000000-CAOLYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLYX000000000-CAOLZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMAA000000000-CAOMAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMAN000000000-CAOMAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMAY000000000-CAOMAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBE000000000-CAOMBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBK000000000-CAOMBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMDA000000000-CAOMDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMFJ000000000-CAOMFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMFY000000000-CAOMFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMGY000000000-CAOMHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMHJ000000000-CAOMHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMIT000000000-CAOMIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMJC000000000-CAOMJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMJN000000000-CAOMJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMJR000000000-CAOMJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMJU000000000-CAOMJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMKA000000000-CAOMKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMKQ000000000-CAOMKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMLA000000000-CAOMLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMLD000000000-CAOMLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMMB000000000-CAOMMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMMH000000000-CAOMMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMNC000000000-CAOMND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMOD000000000-CAOMOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMPD000000000-CAOMPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMPH000000000-CAOMPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMQV000000000-CAOMQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMRN000000000-CAOMRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMSB000000000-CAOMSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMUS000000000-CAOMUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMVQ000000000-CAOMVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMVZ000000000-CAOMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMWG000000000-CAOMWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMWJ000000000-CAOMWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXE000000000-CAOMXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMXU000000000-CAOMXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXZ000000000-CAOMYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMYD000000000-CAOMYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMYY000000000-CAOMYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMZN000000000-CAOMZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONAW000000000-CAONAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONBE000000000-CAONBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONBV000000000-CAONBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONBY000000000-CAONBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONCE000000000-CAONCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONCO000000000-CAONCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONCR000000000-CAONCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONET000000000-CAONEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONFB000000000-CAONFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONGN000000000-CAONGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONHK000000000-CAONHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONHT000000000-CAONHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONIZ000000000-CAONJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONJH000000000-CAONJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONJZ000000000-CAONKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONLR000000000-CAONLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONMJ000000000-CAONMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONNY000000000-CAONNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONOK000000000-CAONOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONOO000000000-CAONOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONPQ000000000-CAONPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONPX000000000-CAONPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONQN000000000-CAONQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONSF000000000-CAONSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONSS000000000-CAONSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONTW000000000-CAONTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONUD000000000-CAONUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONUI000000000-CAONUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONUT000000000-CAONUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVA000000000-CAONVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVH000000000-CAONVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVK000000000-CAONVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONWD000000000-CAONWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONWI000000000-CAONWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONWP000000000-CAONWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONXG000000000-CAONXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONYB000000000-CAONYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONZI000000000-CAONZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONZS000000000-CAONZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOBC000000000-CAOOBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOBS000000000-CAOOBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBY000000000-CAOOBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOCN000000000-CAOOCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOODB000000000-CAOODD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOODK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOODR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOEA000000000-CAOOED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOEW000000000-CAOOEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOFR000000000-CAOOFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOGC000000000-CAOOGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOGG000000000-CAOOGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOHD000000000-CAOOHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOIF000000000-CAOOIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOIO000000000-CAOOIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOIR000000000-CAOOIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOKD000000000-CAOOKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOKP000000000-CAOOKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOMH000000000-CAOOMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOMT000000000-CAOOMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOMW000000000-CAOOMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOONA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOONH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOONM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOONQ000000000-CAOONR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOONT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOOR000000000-CAOOOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOOY000000000-CAOOPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOPP000000000-CAOOPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOPZ000000000-CAOOQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOQC000000000-CAOOQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOORJ000000000-CAOORK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOORM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOSK000000000-CAOOSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOTA000000000-CAOOTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOVR000000000-CAOOVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOWM000000000-CAOOWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOWS000000000-CAOOWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOYC000000000-CAOOYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOZA000000000-CAOOZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOZW000000000-CAOOZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPBR000000000-CAOPBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPBV000000000-CAOPBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPBZ000000000-CAOPCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPCD000000000-CAOPCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPDT000000000-CAOPDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPGQ000000000-CAOPGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPGU000000000-CAOPGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPHG000000000-CAOPHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPJA000000000-CAOPJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJF000000000-CAOPJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJM000000000-CAOPJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJQ000000000-CAOPJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPKX000000000-CAOPKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPLB000000000-CAOPLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPMC000000000-CAOPMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPMQ000000000-CAOPMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPOU000000000-CAOPOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPPC000000000-CAOPPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPPR000000000-CAOPPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPQH000000000-CAOPQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPSE000000000-CAOPSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPUG000000000-CAOPUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPUN000000000-CAOPUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPUZ000000000-CAOPVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPVC000000000-CAOPVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPWK000000000-CAOPWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPXI000000000-CAOPXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPXL000000000-CAOPXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQAA000000000-CAOQAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQAK000000000-CAOQAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQAN000000000-CAOQAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBC000000000-CAOQBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBO000000000-CAOQBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBY000000000-CAOQBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQCJ000000000-CAOQCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQCQ000000000-CAOQCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQEW000000000-CAOQEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQFD000000000-CAOQFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQFJ000000000-CAOQFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGB000000000-CAOQGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGJ000000000-CAOQGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGQ000000000-CAOQGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQIC000000000-CAOQIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQJG000000000-CAOQJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQKK000000000-CAOQKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQKP000000000-CAOQKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQLP000000000-CAOQLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQMX000000000-CAOQMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQNB000000000-CAOQNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQOA000000000-CAOQOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQOO000000000-CAOQOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQPG000000000-CAOQPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQPQ000000000-CAOQPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQRW000000000-CAOQRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQSM000000000-CAOQSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQTZ000000000-CAOQUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQUU000000000-CAOQUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQUZ000000000-CAOQVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQVM000000000-CAOQVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQVU000000000-CAOQVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQWB000000000-CAOQWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQWX000000000-CAOQWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQXM000000000-CAOQXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQXU000000000-CAOQXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQYH000000000-CAOQYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORAK000000000-CAORAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORBJ000000000-CAORBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORCT000000000-CAORCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORDN000000000-CAORDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOREG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOREK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOREM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOREO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOREV000000000-CAOREW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORFD000000000-CAORFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORGW000000000-CAORGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORHK000000000-CAORHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORIM000000000-CAORIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORIQ000000000-CAORIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORIT000000000-CAORIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORIZ000000000-CAORJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORKP000000000-CAORKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORMM000000000-CAORMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORNL000000000-CAORNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORNO000000000-CAORNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOROC000000000-CAOROD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOROQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOROS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORPA000000000-CAORPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORPR000000000-CAORPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORQN000000000-CAORQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORSU000000000-CAORSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORTH000000000-CAORTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORUA000000000-CAORUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORVA000000000-CAORVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORVI000000000-CAORVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORWS000000000-CAORWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORXK000000000-CAORXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORZJ000000000-CAORZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSAA000000000-CAOSAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSAE000000000-CAOSAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSBB000000000-CAOSBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSBS000000000-CAOSBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSBY000000000-CAOSBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSCG000000000-CAOSCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSDE000000000-CAOSDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSDI000000000-CAOSDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSDR000000000-CAOSDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSDX000000000-CAOSEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSEL000000000-CAOSEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSEV000000000-CAOSEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSFB000000000-CAOSFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSFO000000000-CAOSFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSGJ000000000-CAOSGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSGP000000000-CAOSGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSHJ000000000-CAOSHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSIQ000000000-CAOSIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSKB000000000-CAOSKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSKR000000000-CAOSKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSKW000000000-CAOSKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSLB000000000-CAOSLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSLH000000000-CAOSLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSLO000000000-CAOSLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSMJ000000000-CAOSMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSMV000000000-CAOSMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSNC000000000-CAOSNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSOF000000000-CAOSOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSON000000000-CAOSOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSPH000000000-CAOSPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSPO000000000-CAOSPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSRG000000000-CAOSRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSRS000000000-CAOSRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSSN000000000-CAOSSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSTH000000000-CAOSTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSUQ000000000-CAOSUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSUZ000000000-CAOSVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSVC000000000-CAOSVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSVJ000000000-CAOSVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSWY000000000-CAOSWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSXY000000000-CAOSXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSYK000000000-CAOSYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTAL000000000-CAOTAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTCC000000000-CAOTCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCI000000000-CAOTCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCM000000000-CAOTCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTCY000000000-CAOTCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTDN000000000-CAOTDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTDS000000000-CAOTDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTEQ000000000-CAOTER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTFP000000000-CAOTFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTGE000000000-CAOTGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTGY000000000-CAOTHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTIB000000000-CAOTIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTIE000000000-CAOTIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTII000000000-CAOTIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTIW000000000-CAOTIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTJG000000000-CAOTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTJM000000000-CAOTJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTKG000000000-CAOTKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTLE000000000-CAOTLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTMY000000000-CAOTMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTNG000000000-CAOTNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTNW000000000-CAOTNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTOA000000000-CAOTOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTOD000000000-CAOTOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTOQ000000000-CAOTOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTPD000000000-CAOTPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTQX000000000-CAOTQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTRS000000000-CAOTRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSN000000000-CAOTSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTTP000000000-CAOTTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTUC000000000-CAOTUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTUN000000000-CAOTUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTVI000000000-CAOTVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTVT000000000-CAOTVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVW000000000-CAOTVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTXJ000000000-CAOTXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTXR000000000-CAOTXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTXZ000000000-CAOTYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUAS000000000-CAOUAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUBC000000000-CAOUBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUBT000000000-CAOUBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUCE000000000-CAOUCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUCM000000000-CAOUCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUDP000000000-CAOUDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUEO000000000-CAOUEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUFK000000000-CAOUFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUGE000000000-CAOUGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGI000000000-CAOUGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUGR000000000-CAOUGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGV000000000-CAOUGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUHX000000000-CAOUHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUID000000000-CAOUIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUJU000000000-CAOUJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOULA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOULC000000000-CAOULD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOULR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOULY000000000-CAOULZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUMJ000000000-CAOUMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUNE000000000-CAOUNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUNM000000000-CAOUNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUOQ000000000-CAOUOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUOZ000000000-CAOUPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUQI000000000-CAOUQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQO000000000-CAOUQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQR000000000-CAOUQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOURU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOURZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUSC000000000-CAOUSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUTE000000000-CAOUTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUVN000000000-CAOUVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUVV000000000-CAOUVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUWO000000000-CAOUWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUWU000000000-CAOUWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUXF000000000-CAOUXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUXI000000000-CAOUXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUXQ000000000-CAOUXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUXV000000000-CAOUXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUYO000000000-CAOUYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVAB000000000-CAOVAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVAI000000000-CAOVAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVAW000000000-CAOVBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVCG000000000-CAOVCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVCP000000000-CAOVCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVDH000000000-CAOVDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVDP000000000-CAOVDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVEB000000000-CAOVEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEF000000000-CAOVEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEK000000000-CAOVEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEQ000000000-CAOVER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVFE000000000-CAOVFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVFS000000000-CAOVFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVFZ000000000-CAOVGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVGH000000000-CAOVGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVHS000000000-CAOVHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVHW000000000-CAOVHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVIN000000000-CAOVIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVIZ000000000-CAOVJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVJP000000000-CAOVJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVLL000000000-CAOVLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVLX000000000-CAOVLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVNJ000000000-CAOVNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVOF000000000-CAOVOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVOV000000000-CAOVOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVPK000000000-CAOVPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVQB000000000-CAOVQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVQH000000000-CAOVQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVQZ000000000-CAOVRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVRH000000000-CAOVRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVRN000000000-CAOVRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVSH000000000-CAOVSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVTB000000000-CAOVTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTF000000000-CAOVTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTJ000000000-CAOVTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTM000000000-CAOVTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVTU000000000-CAOVTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVUV000000000-CAOVUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVUZ000000000-CAOVVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVVG000000000-CAOVVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVVK000000000-CAOVVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVVQ000000000-CAOVVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVXL000000000-CAOVXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVYQ000000000-CAOVYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVZL000000000-CAOVZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVZT000000000-CAOVZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVZX000000000-CAOWAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWAZ000000000-CAOWBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWBV000000000-CAOWBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWCX000000000-CAOWCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWDC000000000-CAOWDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWDO000000000-CAOWDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWED000000000-CAOWEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWFA000000000-CAOWFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWFI000000000-CAOWFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWFM000000000-CAOWFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWGJ000000000-CAOWGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWIR000000000-CAOWIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWJJ000000000-CAOWJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWJR000000000-CAOWJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWJX000000000-CAOWJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWKZ000000000-CAOWLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWMT000000000-CAOWMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWNO000000000-CAOWNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWOW000000000-CAOWOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWPE000000000-CAOWPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWPV000000000-CAOWPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWSH000000000-CAOWSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWTB000000000-CAOWTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWTM000000000-CAOWTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWTT000000000-CAOWTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWUK000000000-CAOWUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWUO000000000-CAOWUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWUV000000000-CAOWUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWVN000000000-CAOWVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWVX000000000-CAOWVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWWI000000000-CAOWWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWWY000000000-CAOWWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWXQ000000000-CAOWXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWYM000000000-CAOWYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWYP000000000-CAOWYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWZO000000000-CAOWZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWZX000000000-CAOWZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXAU000000000-CAOXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXAX000000000-CAOXAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXBE000000000-CAOXBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXBQ000000000-CAOXBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXDD000000000-CAOXDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXDJ000000000-CAOXDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXDS000000000-CAOXDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXEL000000000-CAOXEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXGR000000000-CAOXGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXHA000000000-CAOXHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXHR000000000-CAOXHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXHV000000000-CAOXHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXIR000000000-CAOXIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXJK000000000-CAOXJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXKC000000000-CAOXKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXKJ000000000-CAOXKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXKV000000000-CAOXKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXLL000000000-CAOXLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXLX000000000-CAOXLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXNE000000000-CAOXNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXOF000000000-CAOXOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXPD000000000-CAOXPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXPS000000000-CAOXPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXSC000000000-CAOXSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXSJ000000000-CAOXSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXSZ000000000-CAOXTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTD000000000-CAOXTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXTJ000000000-CAOXTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXUH000000000-CAOXUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXUX000000000-CAOXUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXVQ000000000-CAOXVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXVV000000000-CAOXVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXWA000000000-CAOXWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXXS000000000-CAOXXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXXW000000000-CAOXXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYE000000000-CAOXYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXZL000000000-CAOXZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYAL000000000-CAOYAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYBE000000000-CAOYBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYBL000000000-CAOYBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYBQ000000000-CAOYBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYDA000000000-CAOYDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYDG000000000-CAOYDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYDP000000000-CAOYDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYED000000000-CAOYEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYEL000000000-CAOYEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYFR000000000-CAOYFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYGD000000000-CAOYGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYGL000000000-CAOYGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYHQ000000000-CAOYHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYJA000000000-CAOYJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYJE000000000-CAOYJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYKR000000000-CAOYKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYKW000000000-CAOYKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYLT000000000-CAOYLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYLW000000000-CAOYLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYMA000000000-CAOYMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYMQ000000000-CAOYMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYMZ000000000-CAOYNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYNQ000000000-CAOYNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYPF000000000-CAOYPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYQF000000000-CAOYQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYQU000000000-CAOYQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYRJ000000000-CAOYRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYRY000000000-CAOYRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYTI000000000-CAOYTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYTP000000000-CAOYTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYUU000000000-CAOYUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYVD000000000-CAOYVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYWV000000000-CAOYWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYWZ000000000-CAOYXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYXO000000000-CAOYXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYXZ000000000-CAOYYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYYF000000000-CAOYYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZAJ000000000-CAOZAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZBA000000000-CAOZBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZBX000000000-CAOZBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZCT000000000-CAOZCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZDC000000000-CAOZDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZEL000000000-CAOZEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZEW000000000-CAOZEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZFT000000000-CAOZFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZGI000000000-CAOZGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZGR000000000-CAOZGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZHH000000000-CAOZHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZHM000000000-CAOZHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZHT000000000-CAOZHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZJJ000000000-CAOZJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZJQ000000000-CAOZJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZKB000000000-CAOZKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKF000000000-CAOZKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKL000000000-CAOZKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKQ000000000-CAOZKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZKX000000000-CAOZKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZLM000000000-CAOZLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZMI000000000-CAOZMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZML000000000-CAOZMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZMV000000000-CAOZMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNA000000000-CAOZNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNF000000000-CAOZNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNR000000000-CAOZNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOA000000000-CAOZOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOI000000000-CAOZOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZOT000000000-CAOZOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZPW000000000-CAOZPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZQB000000000-CAOZQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZRI000000000-CAOZRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZRL000000000-CAOZRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZRX000000000-CAOZRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZSM000000000-CAOZSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZSY000000000-CAOZSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZTE000000000-CAOZTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZTH000000000-CAOZTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZTM000000000-CAOZTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZVG000000000-CAOZVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZWK000000000-CAOZWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZWQ000000000-CAOZWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXF000000000-CAOZXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXR000000000-CAOZXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXY000000000-CAOZXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZYH000000000-CAOZYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYP000000000-CAOZYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYU000000000-CAOZYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZZM000000000-CAOZZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAAZ000000000-CAPABA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPABC000000000-CAPABD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPABI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPABK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPABM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPABR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPABT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPABV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPACB000000000-CAPACC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPACF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPACJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPACL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPACV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPACY000000000-CAPADA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPADK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPADO000000000-CAPADP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPADR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPADU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPADX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAEW000000000-CAPAEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAGC000000000-CAPAGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAGW000000000-CAPAGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAHX000000000-CAPAHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAJW000000000-CAPAJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAKX000000000-CAPAKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALB000000000-CAPALC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPALG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPALI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPALM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPALQ000000000-CAPALR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPALX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPALZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPANB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPANE000000000-CAPANF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPANH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPANM000000000-CAPANN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPANR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAOP000000000-CAPAOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAPI000000000-CAPAPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAQC000000000-CAPAQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAQU000000000-CAPAQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPARB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPARG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPARI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPARN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPARQ000000000-CAPARS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPARY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPASG000000000-CAPASI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPASL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPASW000000000-CAPASX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPATA000000000-CAPATB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPATD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPATL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPATP000000000-CAPATQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPATW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPATY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAUA000000000-CAPAUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAUM000000000-CAPAUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAUP000000000-CAPAUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAUV000000000-CAPAUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAVJ000000000-CAPAVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAXC000000000-CAPAXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAXL000000000-CAPAXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAXP000000000-CAPAXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAYD000000000-CAPAYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAYY000000000-CAPAYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAZC000000000-CAPAZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAZM000000000-CAPAZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAZV000000000-CAPAZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBAT000000000-CAPBAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBCP000000000-CAPBCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBCU000000000-CAPBCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBDF000000000-CAPBDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBDI000000000-CAPBDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBDM000000000-CAPBDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBDP000000000-CAPBDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBEB000000000-CAPBEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBEU000000000-CAPBEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBFZ000000000-CAPBGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBHK000000000-CAPBHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBHT000000000-CAPBHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBIH000000000-CAPBII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBIS000000000-CAPBIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBJH000000000-CAPBJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBJR000000000-CAPBJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBKA000000000-CAPBKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBKH000000000-CAPBKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBLF000000000-CAPBLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBLI000000000-CAPBLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBLV000000000-CAPBLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBMM000000000-CAPBMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBNX000000000-CAPBNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBOS000000000-CAPBOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBPH000000000-CAPBPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBPY000000000-CAPBPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBRC000000000-CAPBRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBRX000000000-CAPBRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBSN000000000-CAPBSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBST000000000-CAPBSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBTG000000000-CAPBTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBUE000000000-CAPBUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBUR000000000-CAPBUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBVA000000000-CAPBVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBVD000000000-CAPBVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBVX000000000-CAPBVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBWH000000000-CAPBWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBWN000000000-CAPBWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBXO000000000-CAPBXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBXV000000000-CAPBXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBYC000000000-CAPBYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBYN000000000-CAPBYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBYS000000000-CAPBYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBZM000000000-CAPBZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBZV000000000-CAPBZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAF000000000-CAPCAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAP000000000-CAPCAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAS000000000-CAPCAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAY000000000-CAPCBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCBZ000000000-CAPCCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCCG000000000-CAPCCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCCO000000000-CAPCCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCDJ000000000-CAPCDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCDT000000000-CAPCDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCEV000000000-CAPCEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCFB000000000-CAPCFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCFL000000000-CAPCFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCHQ000000000-CAPCHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCIH000000000-CAPCII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCIK000000000-CAPCIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCJX000000000-CAPCJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCKB000000000-CAPCKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCKF000000000-CAPCKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCKX000000000-CAPCKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCMP000000000-CAPCMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCQD000000000-CAPCQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCRO000000000-CAPCRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCSY000000000-CAPCSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCTK000000000-CAPCTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCTV000000000-CAPCTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCUN000000000-CAPCUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCUZ000000000-CAPCVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCWQ000000000-CAPCWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCXF000000000-CAPCXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCXL000000000-CAPCXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCXQ000000000-CAPCXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCZM000000000-CAPCZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCZQ000000000-CAPCZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDAM000000000-CAPDAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDBQ000000000-CAPDBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDCF000000000-CAPDCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDCK000000000-CAPDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDCZ000000000-CAPDDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDDU000000000-CAPDDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDDZ000000000-CAPDEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDEJ000000000-CAPDEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDHM000000000-CAPDHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHQ000000000-CAPDHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHU000000000-CAPDHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDJR000000000-CAPDJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDLP000000000-CAPDLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDLW000000000-CAPDLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDNG000000000-CAPDNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDOE000000000-CAPDOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDOO000000000-CAPDOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDPJ000000000-CAPDPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDQE000000000-CAPDQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDRM000000000-CAPDRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDSH000000000-CAPDSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDST000000000-CAPDSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDSW000000000-CAPDSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDTR000000000-CAPDTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDVC000000000-CAPDVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDVM000000000-CAPDVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDVS000000000-CAPDVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDVW000000000-CAPDVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDYF000000000-CAPDYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDYY000000000-CAPDYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDZJ000000000-CAPDZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDZT000000000-CAPDZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEAE000000000-CAPEAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEAH000000000-CAPEAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEAL000000000-CAPEAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEBZ000000000-CAPECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPECC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPECV000000000-CAPECX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEDB000000000-CAPEDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEDK000000000-CAPEDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEGF000000000-CAPEGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEHP000000000-CAPEHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEHZ000000000-CAPEIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEIZ000000000-CAPEJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEKI000000000-CAPEKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPELH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPELJ000000000-CAPELK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPELN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPELR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPELV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPELY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEML000000000-CAPEMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEMR000000000-CAPEMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPENB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPENJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPENL000000000-CAPENM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPENY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEOA000000000-CAPEOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEOD000000000-CAPEOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEPU000000000-CAPEPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPERK000000000-CAPERL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPERQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPERS000000000-CAPERT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPERV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPESD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPESK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPESQ000000000-CAPESS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPESV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPESZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPETC000000000-CAPETD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPETI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPETS000000000-CAPETT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPETV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPETZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEUB000000000-CAPEUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUG000000000-CAPEUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUQ000000000-CAPEUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUW000000000-CAPEUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEVY000000000-CAPEVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEWB000000000-CAPEWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEXJ000000000-CAPEXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEZZ000000000-CAPFAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFAN000000000-CAPFAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFBF000000000-CAPFBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFBW000000000-CAPFBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFCI000000000-CAPFCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFCY000000000-CAPFDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFDL000000000-CAPFDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFDU000000000-CAPFDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFEA000000000-CAPFEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFGW000000000-CAPFGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFGZ000000000-CAPFHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFHC000000000-CAPFHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFJA000000000-CAPFJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFJR000000000-CAPFJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFJW000000000-CAPFJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFKO000000000-CAPFKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFLE000000000-CAPFLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFLI000000000-CAPFLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFLU000000000-CAPFLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFMS000000000-CAPFMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFNC000000000-CAPFND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFPA000000000-CAPFPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFPS000000000-CAPFPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFQQ000000000-CAPFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFRA000000000-CAPFRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFSB000000000-CAPFSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFST000000000-CAPFSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFUM000000000-CAPFUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFWM000000000-CAPFWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWQ000000000-CAPFWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWU000000000-CAPFWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFYT000000000-CAPFYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZA000000000-CAPFZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZH000000000-CAPFZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZK000000000-CAPFZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZT000000000-CAPFZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGAL000000000-CAPGAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGBC000000000-CAPGBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGBH000000000-CAPGBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGBR000000000-CAPGBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGBX000000000-CAPGBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGCC000000000-CAPGCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGCK000000000-CAPGCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGDJ000000000-CAPGDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGDP000000000-CAPGDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGEX000000000-CAPGEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGFH000000000-CAPGFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGFU000000000-CAPGFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGGA000000000-CAPGGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGGI000000000-CAPGGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGHS000000000-CAPGHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGID000000000-CAPGIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGIX000000000-CAPGIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGKG000000000-CAPGKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGLI000000000-CAPGLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGLQ000000000-CAPGLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGNC000000000-CAPGNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGOS000000000-CAPGOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGPZ000000000-CAPGQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGQG000000000-CAPGQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGQK000000000-CAPGQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGQT000000000-CAPGQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGRI000000000-CAPGRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGRU000000000-CAPGRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGTT000000000-CAPGTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGUJ000000000-CAPGUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGUS000000000-CAPGUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGVE000000000-CAPGVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGVQ000000000-CAPGVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGVX000000000-CAPGVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGWR000000000-CAPGWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGXC000000000-CAPGXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGXN000000000-CAPGXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGYO000000000-CAPGYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGZK000000000-CAPGZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGZS000000000-CAPGZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHAA000000000-CAPHAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAF000000000-CAPHAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHBZ000000000-CAPHCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHCI000000000-CAPHCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHDI000000000-CAPHDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHDO000000000-CAPHDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHDV000000000-CAPHDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHEQ000000000-CAPHER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHEU000000000-CAPHEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFC000000000-CAPHFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHFM000000000-CAPHFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFQ000000000-CAPHFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFW000000000-CAPHFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHJJ000000000-CAPHJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHJT000000000-CAPHJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHJY000000000-CAPHJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKB000000000-CAPHKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKI000000000-CAPHKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHLF000000000-CAPHLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHLT000000000-CAPHLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHMA000000000-CAPHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHMG000000000-CAPHMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHMS000000000-CAPHMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHNA000000000-CAPHNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHNI000000000-CAPHNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHNT000000000-CAPHNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHOF000000000-CAPHOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHOK000000000-CAPHOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHPB000000000-CAPHPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHPP000000000-CAPHPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHQN000000000-CAPHQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHQX000000000-CAPHQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHRT000000000-CAPHRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHRZ000000000-CAPHSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHSJ000000000-CAPHSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHSO000000000-CAPHSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHSZ000000000-CAPHTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHVE000000000-CAPHVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHVJ000000000-CAPHVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHXY000000000-CAPHXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHZB000000000-CAPHZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHZO000000000-CAPHZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHZW000000000-CAPHZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIAX000000000-CAPIBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIBG000000000-CAPIBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIBS000000000-CAPIBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPICA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPICW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIDQ000000000-CAPIDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIDU000000000-CAPIDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIEO000000000-CAPIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIES000000000-CAPIEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIFI000000000-CAPIFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIFR000000000-CAPIFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIFV000000000-CAPIFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIGJ000000000-CAPIGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIHM000000000-CAPIHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIID000000000-CAPIIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIIO000000000-CAPIIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIIZ000000000-CAPIJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIJC000000000-CAPIJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIJY000000000-CAPIJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIKJ000000000-CAPIKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIKU000000000-CAPIKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPILB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPILF000000000-CAPILG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPILN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPILP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPILW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIMF000000000-CAPIMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIOF000000000-CAPIOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOL000000000-CAPIOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIOW000000000-CAPIOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIPA000000000-CAPIPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIPI000000000-CAPIPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIQB000000000-CAPIQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIQV000000000-CAPIQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPISC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPISG000000000-CAPISH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPISJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPISR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPISW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPISY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIUE000000000-CAPIUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIUK000000000-CAPIUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIUT000000000-CAPIUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIWD000000000-CAPIWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIWY000000000-CAPIXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIZD000000000-CAPIZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIZJ000000000-CAPIZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJAD000000000-CAPJAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJAL000000000-CAPJAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJAQ000000000-CAPJAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJAX000000000-CAPJAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJBD000000000-CAPJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJBP000000000-CAPJBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJBY000000000-CAPJCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJDC000000000-CAPJDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJDI000000000-CAPJDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJEN000000000-CAPJEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJGS000000000-CAPJGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJHN000000000-CAPJHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJIJ000000000-CAPJIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJIS000000000-CAPJIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJIW000000000-CAPJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJJQ000000000-CAPJJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJKN000000000-CAPJKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJLM000000000-CAPJLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJLT000000000-CAPJLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJMF000000000-CAPJMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJNH000000000-CAPJNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJOI000000000-CAPJOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJPB000000000-CAPJPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJPW000000000-CAPJPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJPZ000000000-CAPJQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJQE000000000-CAPJQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJQU000000000-CAPJQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJRF000000000-CAPJRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJRQ000000000-CAPJRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJTS000000000-CAPJTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJUS000000000-CAPJUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJVX000000000-CAPJVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJWT000000000-CAPJWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJZQ000000000-CAPJZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKAA000000000-CAPKAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKCB000000000-CAPKCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKCK000000000-CAPKCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKCO000000000-CAPKCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKDB000000000-CAPKDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKDU000000000-CAPKDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKFS000000000-CAPKFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKGK000000000-CAPKGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKGN000000000-CAPKGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKHS000000000-CAPKHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKHV000000000-CAPKHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIA000000000-CAPKIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKIG000000000-CAPKIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIL000000000-CAPKIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIP000000000-CAPKIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKJS000000000-CAPKJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKKC000000000-CAPKKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKLL000000000-CAPKLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKLS000000000-CAPKLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKLX000000000-CAPKLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKMK000000000-CAPKML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKPC000000000-CAPKPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKPJ000000000-CAPKPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKQQ000000000-CAPKQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKRS000000000-CAPKRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKSJ000000000-CAPKSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKSR000000000-CAPKSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKSW000000000-CAPKSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKUL000000000-CAPKUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKVO000000000-CAPKVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKWN000000000-CAPKWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKWS000000000-CAPKWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKXE000000000-CAPKXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKXN000000000-CAPKXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKYN000000000-CAPKYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKYW000000000-CAPKYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKZO000000000-CAPKZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLAB000000000-CAPLAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLAW000000000-CAPLAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLAZ000000000-CAPLBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLBN000000000-CAPLBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLBX000000000-CAPLBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLCK000000000-CAPLCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLDJ000000000-CAPLDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDM000000000-CAPLDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDU000000000-CAPLDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDY000000000-CAPLDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLED000000000-CAPLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFJ000000000-CAPLFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLFM000000000-CAPLFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFT000000000-CAPLFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFZ000000000-CAPLGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLGS000000000-CAPLGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLHE000000000-CAPLHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLHQ000000000-CAPLHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLIP000000000-CAPLIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLJW000000000-CAPLJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLKD000000000-CAPLKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLKZ000000000-CAPLLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLLW000000000-CAPLLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLMB000000000-CAPLMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLMI000000000-CAPLMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLND000000000-CAPLNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLNP000000000-CAPLNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLOE000000000-CAPLOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLPJ000000000-CAPLPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLPY000000000-CAPLQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLQR000000000-CAPLQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLQY000000000-CAPLQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLTT000000000-CAPLTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLUD000000000-CAPLUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUH000000000-CAPLUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUO000000000-CAPLUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUY000000000-CAPLUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLVM000000000-CAPLVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLVT000000000-CAPLVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLWA000000000-CAPLWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLXB000000000-CAPLXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLXL000000000-CAPLXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLXQ000000000-CAPLXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLXT000000000-CAPLXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLYZ000000000-CAPLZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLZQ000000000-CAPLZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLZY000000000-CAPLZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMAD000000000-CAPMAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMBC000000000-CAPMBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMCD000000000-CAPMCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCI000000000-CAPMCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCU000000000-CAPMCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMEW000000000-CAPMEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMFN000000000-CAPMFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMFY000000000-CAPMFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGD000000000-CAPMGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGK000000000-CAPMGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGT000000000-CAPMGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMHL000000000-CAPMHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMIB000000000-CAPMIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMIV000000000-CAPMIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMIY000000000-CAPMIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMJR000000000-CAPMJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJU000000000-CAPMJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJZ000000000-CAPMKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMMY000000000-CAPMMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMNC000000000-CAPMND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMNI000000000-CAPMNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMNP000000000-CAPMNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMOI000000000-CAPMOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMOW000000000-CAPMOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMQC000000000-CAPMQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMQT000000000-CAPMQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMRH000000000-CAPMRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMRZ000000000-CAPMSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMSR000000000-CAPMSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMSY000000000-CAPMSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMTV000000000-CAPMTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMUC000000000-CAPMUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMUW000000000-CAPMUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMVF000000000-CAPMVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMVM000000000-CAPMVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMWO000000000-CAPMWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMXV000000000-CAPMXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMZJ000000000-CAPMZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMZV000000000-CAPNAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNAI000000000-CAPNAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNAN000000000-CAPNAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNAV000000000-CAPNAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNBG000000000-CAPNBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNBZ000000000-CAPNCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNCG000000000-CAPNCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNDA000000000-CAPNDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNED000000000-CAPNEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNFP000000000-CAPNFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNGD000000000-CAPNGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNGH000000000-CAPNGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNHC000000000-CAPNHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNHT000000000-CAPNHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNIS000000000-CAPNIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNIZ000000000-CAPNJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNJJ000000000-CAPNJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJN000000000-CAPNJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJQ000000000-CAPNJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNKI000000000-CAPNKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNKR000000000-CAPNKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNLF000000000-CAPNLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNLN000000000-CAPNLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNMD000000000-CAPNME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNMG000000000-CAPNMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNMY000000000-CAPNMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNNE000000000-CAPNNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNNO000000000-CAPNNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNOC000000000-CAPNOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNOI000000000-CAPNOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNPV000000000-CAPNPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNQD000000000-CAPNQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNQO000000000-CAPNQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNRK000000000-CAPNRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNSN000000000-CAPNSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNTJ000000000-CAPNTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNUB000000000-CAPNUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNUI000000000-CAPNUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNUQ000000000-CAPNUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNVQ000000000-CAPNVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNVW000000000-CAPNVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNWB000000000-CAPNWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNXA000000000-CAPNXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNXV000000000-CAPNXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNXZ000000000-CAPNYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNYC000000000-CAPNYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNYP000000000-CAPNYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPODB000000000-CAPODE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPODI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPODP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPODS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPODW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOED000000000-CAPOEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEI000000000-CAPOEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEL000000000-CAPOEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOET000000000-CAPOEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOFC000000000-CAPOFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOFW000000000-CAPOFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOFZ000000000-CAPOGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOHF000000000-CAPOHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOHZ000000000-CAPOIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOID000000000-CAPOIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOIS000000000-CAPOIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOKO000000000-CAPOKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOLI000000000-CAPOLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOLY000000000-CAPOMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOMK000000000-CAPOMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOMR000000000-CAPOMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOMV000000000-CAPOMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPONB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPONG000000000-CAPONH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPONK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPONV000000000-CAPONW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOPO000000000-CAPOPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOPT000000000-CAPOPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOPX000000000-CAPOPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOQA000000000-CAPOQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOQL000000000-CAPOQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOQV000000000-CAPOQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORC000000000-CAPORD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPORG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPORL000000000-CAPORM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORP000000000-CAPORQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPORW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOSN000000000-CAPOSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSQ000000000-CAPOSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOTP000000000-CAPOTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOUN000000000-CAPOUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOUX000000000-CAPOUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOVA000000000-CAPOVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOVW000000000-CAPOVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOWG000000000-CAPOWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOXT000000000-CAPOXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOYC000000000-CAPOYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOYO000000000-CAPOYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOZK000000000-CAPOZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPAP000000000-CAPPAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPAT000000000-CAPPAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPBK000000000-CAPPBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPBO000000000-CAPPBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPDK000000000-CAPPDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPDT000000000-CAPPDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPEB000000000-CAPPEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPEK000000000-CAPPEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPES000000000-CAPPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPFC000000000-CAPPFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPGM000000000-CAPPGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPGS000000000-CAPPGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPHM000000000-CAPPHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPHU000000000-CAPPHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPIE000000000-CAPPIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPIQ000000000-CAPPIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPIV000000000-CAPPIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPJE000000000-CAPPJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPJT000000000-CAPPJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPLB000000000-CAPPLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPLW000000000-CAPPLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPMQ000000000-CAPPMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPMU000000000-CAPPMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPNB000000000-CAPPNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPNL000000000-CAPPNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPNP000000000-CAPPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPPC000000000-CAPPPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPQE000000000-CAPPQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPRE000000000-CAPPRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPRM000000000-CAPPRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPRT000000000-CAPPRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPRW000000000-CAPPRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPSH000000000-CAPPSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPSL000000000-CAPPSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPSV000000000-CAPPSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPTA000000000-CAPPTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPTI000000000-CAPPTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPVU000000000-CAPPVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWA000000000-CAPPWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPWP000000000-CAPPWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPXA000000000-CAPPXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPXE000000000-CAPPXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPXM000000000-CAPPXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPXX000000000-CAPPYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPYM000000000-CAPPYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPZY000000000-CAPPZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQAF000000000-CAPQAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQBK000000000-CAPQBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQCA000000000-CAPQCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQCN000000000-CAPQCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQED000000000-CAPQEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQEJ000000000-CAPQEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQFD000000000-CAPQFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQFO000000000-CAPQFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQFS000000000-CAPQFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQFY000000000-CAPQFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQGC000000000-CAPQGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQHS000000000-CAPQHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQJI000000000-CAPQJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQJS000000000-CAPQJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQKP000000000-CAPQKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLA000000000-CAPQLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQLQ000000000-CAPQLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQMF000000000-CAPQMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQMT000000000-CAPQMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQOK000000000-CAPQOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQOP000000000-CAPQOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQQE000000000-CAPQQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQQI000000000-CAPQQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQRB000000000-CAPQRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQRO000000000-CAPQRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQSY000000000-CAPQTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQTH000000000-CAPQTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQUS000000000-CAPQUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQUW000000000-CAPQUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQVV000000000-CAPQVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQWZ000000000-CAPQXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYA000000000-CAPQYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQYF000000000-CAPQYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYM000000000-CAPQYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYZ000000000-CAPQZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQZG000000000-CAPQZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQZP000000000-CAPQZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRAH000000000-CAPRAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRAO000000000-CAPRAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRBE000000000-CAPRBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBJ000000000-CAPRBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRBT000000000-CAPRBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRDE000000000-CAPRDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRDL000000000-CAPRDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRDR000000000-CAPRDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPREA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPREC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPREF000000000-CAPREG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPREI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPREL000000000-CAPREP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRES000000000-CAPRET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPREV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRFC000000000-CAPRFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRFG000000000-CAPRFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRFM000000000-CAPRFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRGG000000000-CAPRGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRHC000000000-CAPRHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRHK000000000-CAPRHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRHS000000000-CAPRHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRIN000000000-CAPRIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRIS000000000-CAPRIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRJV000000000-CAPRJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRJY000000000-CAPRKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKG000000000-CAPRKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKK000000000-CAPRKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKS000000000-CAPRKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKW000000000-CAPRKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLB000000000-CAPRLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRLS000000000-CAPRLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRMF000000000-CAPRMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRNC000000000-CAPRND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPROA000000000-CAPROB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPROH000000000-CAPROI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPROQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPROU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPROX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPROZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRPE000000000-CAPRPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRPU000000000-CAPRPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRQB000000000-CAPRQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRQI000000000-CAPRQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRQL000000000-CAPRQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRQW000000000-CAPRQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRB000000000-CAPRRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRF000000000-CAPRRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRSB000000000-CAPRSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRTB000000000-CAPRTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTP000000000-CAPRTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRVE000000000-CAPRVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRWY000000000-CAPRWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRYE000000000-CAPRYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZA000000000-CAPRZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZJ000000000-CAPRZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZT000000000-CAPRZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRZY000000000-CAPSAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSAU000000000-CAPSAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSCG000000000-CAPSCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSCT000000000-CAPSCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSDL000000000-CAPSDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSDQ000000000-CAPSDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSFB000000000-CAPSFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSGC000000000-CAPSGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSGH000000000-CAPSGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSGY000000000-CAPSGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSHF000000000-CAPSHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSHO000000000-CAPSHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSIK000000000-CAPSIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSJH000000000-CAPSJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSJL000000000-CAPSJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSJO000000000-CAPSJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSKF000000000-CAPSKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSKL000000000-CAPSKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSKY000000000-CAPSKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSLL000000000-CAPSLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSLV000000000-CAPSLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSMU000000000-CAPSMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSNF000000000-CAPSNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSNL000000000-CAPSNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSOA000000000-CAPSOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSPS000000000-CAPSPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSPZ000000000-CAPSQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQE000000000-CAPSQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSQL000000000-CAPSQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSQY000000000-CAPSQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSRO000000000-CAPSRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSRU000000000-CAPSRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSTB000000000-CAPSTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSUZ000000000-CAPSVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSVI000000000-CAPSVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSWF000000000-CAPSWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWI000000000-CAPSWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWO000000000-CAPSWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWR000000000-CAPSWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWU000000000-CAPSWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSXE000000000-CAPSXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSXN000000000-CAPSXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSXW000000000-CAPSXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSYD000000000-CAPSYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSYP000000000-CAPSYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTAF000000000-CAPTAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTAM000000000-CAPTAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTBA000000000-CAPTBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTBS000000000-CAPTBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTCF000000000-CAPTCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTCS000000000-CAPTCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTDA000000000-CAPTDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTEQ000000000-CAPTER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTEW000000000-CAPTFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTFZ000000000-CAPTGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTGF000000000-CAPTGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTGI000000000-CAPTGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTHO000000000-CAPTHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTHX000000000-CAPTHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTIK000000000-CAPTIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTIW000000000-CAPTIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTJG000000000-CAPTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTKJ000000000-CAPTKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTLK000000000-CAPTLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTMG000000000-CAPTMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTMJ000000000-CAPTMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTMZ000000000-CAPTNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTNO000000000-CAPTNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTNV000000000-CAPTNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTOJ000000000-CAPTOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTQH000000000-CAPTQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTRF000000000-CAPTRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTRK000000000-CAPTRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTTR000000000-CAPTTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTUM000000000-CAPTUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTUS000000000-CAPTUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUW000000000-CAPTUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTVC000000000-CAPTVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTVI000000000-CAPTVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTXA000000000-CAPTXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTXO000000000-CAPTXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTXU000000000-CAPTXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTYD000000000-CAPTYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTYT000000000-CAPTYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTZG000000000-CAPTZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTZS000000000-CAPTZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAB000000000-CAPUAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUAN000000000-CAPUAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAR000000000-CAPUAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAU000000000-CAPUAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUBK000000000-CAPUBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUBU000000000-CAPUBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUEN000000000-CAPUEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUEW000000000-CAPUEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUGJ000000000-CAPUGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUGN000000000-CAPUGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUGY000000000-CAPUGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUHC000000000-CAPUHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUHR000000000-CAPUHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUIB000000000-CAPUIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUIG000000000-CAPUIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUJV000000000-CAPUJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKA000000000-CAPUKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUKO000000000-CAPUKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKT000000000-CAPUKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPULR000000000-CAPULS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPULU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPULY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUMP000000000-CAPUMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMT000000000-CAPUMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMY000000000-CAPUMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUNO000000000-CAPUNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUOC000000000-CAPUOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUOS000000000-CAPUOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUPM000000000-CAPUPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPW000000000-CAPUPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUQK000000000-CAPUQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPURB000000000-CAPURD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPURI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPURK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPURO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPURT000000000-CAPURV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPURY000000000-CAPUSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUSC000000000-CAPUSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUSL000000000-CAPUSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUSZ000000000-CAPUTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUTV000000000-CAPUTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUVQ000000000-CAPUVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUVZ000000000-CAPUWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUWS000000000-CAPUWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUXQ000000000-CAPUXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUYJ000000000-CAPUYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUYO000000000-CAPUYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVAG000000000-CAPVAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVAN000000000-CAPVAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVBC000000000-CAPVBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVBQ000000000-CAPVBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVCN000000000-CAPVCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVCV000000000-CAPVCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVDP000000000-CAPVDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVDT000000000-CAPVDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVEA000000000-CAPVEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVFK000000000-CAPVFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVFT000000000-CAPVFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVGC000000000-CAPVGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVHI000000000-CAPVHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVID000000000-CAPVII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVIR000000000-CAPVIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVJN000000000-CAPVJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJQ000000000-CAPVJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKB000000000-CAPVKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKJ000000000-CAPVKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVKR000000000-CAPVKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKZ000000000-CAPVLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVML000000000-CAPVMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVNM000000000-CAPVNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVNS000000000-CAPVNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVNZ000000000-CAPVOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVOV000000000-CAPVOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVOY000000000-CAPVOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVPC000000000-CAPVPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVPJ000000000-CAPVPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVPX000000000-CAPVQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVQG000000000-CAPVQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVRD000000000-CAPVRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVRK000000000-CAPVRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVRP000000000-CAPVRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVSN000000000-CAPVSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVTK000000000-CAPVTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVTY000000000-CAPVTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVUK000000000-CAPVUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVVW000000000-CAPVVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVWE000000000-CAPVWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVWU000000000-CAPVWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVXE000000000-CAPVXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXI000000000-CAPVXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXO000000000-CAPVXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVYR000000000-CAPVYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVZF000000000-CAPVZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVZV000000000-CAPVZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWAN000000000-CAPWAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWBL000000000-CAPWBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWDW000000000-CAPWDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWEX000000000-CAPWEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWFI000000000-CAPWFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWHJ000000000-CAPWHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHN000000000-CAPWHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHQ000000000-CAPWHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWIA000000000-CAPWIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWIW000000000-CAPWIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWJX000000000-CAPWJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWKA000000000-CAPWKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWKJ000000000-CAPWKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWKQ000000000-CAPWKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWKW000000000-CAPWKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWLD000000000-CAPWLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWLL000000000-CAPWLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWLU000000000-CAPWLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWMG000000000-CAPWMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWMM000000000-CAPWMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWNM000000000-CAPWNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWOV000000000-CAPWOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWPG000000000-CAPWPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWPR000000000-CAPWPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWQL000000000-CAPWQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWQT000000000-CAPWQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWRE000000000-CAPWRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWRS000000000-CAPWRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWSK000000000-CAPWSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWUF000000000-CAPWUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWUQ000000000-CAPWUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWVF000000000-CAPWVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWVM000000000-CAPWVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWWH000000000-CAPWWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWWN000000000-CAPWWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWZF000000000-CAPWZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXAM000000000-CAPXAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAU000000000-CAPXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXBC000000000-CAPXBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXCK000000000-CAPXCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXDD000000000-CAPXDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXDQ000000000-CAPXDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXDV000000000-CAPXDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXEA000000000-CAPXEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXEL000000000-CAPXEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXEO000000000-CAPXEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXFT000000000-CAPXFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXFX000000000-CAPXFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGB000000000-CAPXGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGK000000000-CAPXGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXGS000000000-CAPXGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXIK000000000-CAPXIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXJG000000000-CAPXJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJK000000000-CAPXJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJO000000000-CAPXJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJT000000000-CAPXJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXKA000000000-CAPXKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXKM000000000-CAPXKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXKU000000000-CAPXKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXMP000000000-CAPXMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXMT000000000-CAPXMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXPN000000000-CAPXPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXPV000000000-CAPXPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXQB000000000-CAPXQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXQX000000000-CAPXQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXRH000000000-CAPXRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXRZ000000000-CAPXSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXSD000000000-CAPXSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXTE000000000-CAPXTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXTJ000000000-CAPXTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXUZ000000000-CAPXVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXVN000000000-CAPXVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXWL000000000-CAPXWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXXK000000000-CAPXXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXZX000000000-CAPXZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYAR000000000-CAPYAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYBA000000000-CAPYBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYDB000000000-CAPYDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYDU000000000-CAPYDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYEA000000000-CAPYEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYED000000000-CAPYEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYER000000000-CAPYES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYEY000000000-CAPYEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYFC000000000-CAPYFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYFK000000000-CAPYFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYGC000000000-CAPYGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYHF000000000-CAPYHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYHO000000000-CAPYHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYHY000000000-CAPYHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYII000000000-CAPYIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYIN000000000-CAPYIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYIU000000000-CAPYIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYJE000000000-CAPYJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYJS000000000-CAPYJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYLB000000000-CAPYLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYMI000000000-CAPYMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYMO000000000-CAPYMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYNK000000000-CAPYNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYNR000000000-CAPYNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYOJ000000000-CAPYOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOO000000000-CAPYOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYPG000000000-CAPYPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYPJ000000000-CAPYPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYRM000000000-CAPYRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYSA000000000-CAPYSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYSE000000000-CAPYSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYSM000000000-CAPYSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYTT000000000-CAPYTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYUI000000000-CAPYUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYVH000000000-CAPYVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVK000000000-CAPYVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVO000000000-CAPYVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYWP000000000-CAPYWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYXE000000000-CAPYXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYXN000000000-CAPYXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYYE000000000-CAPYYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYYJ000000000-CAPYYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYYQ000000000-CAPYYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYYY000000000-CAPYZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYZM000000000-CAPYZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYZX000000000-CAPYZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZBH000000000-CAPZBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZBL000000000-CAPZBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZBT000000000-CAPZBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZBX000000000-CAPZBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZDL000000000-CAPZDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZEC000000000-CAPZEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZEK000000000-CAPZEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZEW000000000-CAPZEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZFJ000000000-CAPZFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZFS000000000-CAPZFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZFV000000000-CAPZFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZGK000000000-CAPZGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZHB000000000-CAPZHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZHW000000000-CAPZHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZIG000000000-CAPZIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZIZ000000000-CAPZJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZJW000000000-CAPZJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZKO000000000-CAPZKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZLU000000000-CAPZLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZLX000000000-CAPZMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZMG000000000-CAPZMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZMN000000000-CAPZMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZMU000000000-CAPZMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZNB000000000-CAPZNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZNF000000000-CAPZNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZOI000000000-CAPZOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZRJ000000000-CAPZRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZSI000000000-CAPZSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZSS000000000-CAPZST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZTJ000000000-CAPZTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZUE000000000-CAPZUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZUO000000000-CAPZUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZUT000000000-CAPZUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZVC000000000-CAPZVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZVR000000000-CAPZVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVU000000000-CAPZVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZXE000000000-CAPZXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZYE000000000-CAPZYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZYN000000000-CAPZYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYQ000000000-CAPZYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYU000000000-CAPZYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZZY000000000-CAQAAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAAP000000000-CAQAAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQABA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQABD000000000-CAQABE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQABK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQABW000000000-CAQABX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQABZ000000000-CAQACA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQACD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQACF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQACM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQACV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQACY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQADC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQADF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQADI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQADP000000000-CAQADQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQADX000000000-CAQADY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAEB000000000-CAQAEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAEE000000000-CAQAEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAEV000000000-CAQAEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAHG000000000-CAQAHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAIH000000000-CAQAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAIO000000000-CAQAIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAIR000000000-CAQAIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAKN000000000-CAQAKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAKS000000000-CAQAKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAKX000000000-CAQAKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQALA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQALE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQALI000000000-CAQALK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQALN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQALP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQALU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQALW000000000-CAQALX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAMK000000000-CAQAML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAMV000000000-CAQAMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQANB000000000-CAQANC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQANF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAOH000000000-CAQAOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAOM000000000-CAQAON999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAOY000000000-CAQAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAPO000000000-CAQAPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAPT000000000-CAQAPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQARV000000000-CAQARW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQARY000000000-CAQARZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQASI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQATE000000000-CAQATF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQATJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQATL000000000-CAQATM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQATR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAUJ000000000-CAQAUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAUQ000000000-CAQAUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAVK000000000-CAQAVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAVT000000000-CAQAVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAWK000000000-CAQAWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAXC000000000-CAQAXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAXY000000000-CAQAXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAYI000000000-CAQAYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAYO000000000-CAQAYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAZD000000000-CAQAZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBAV000000000-CAQBAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBDE000000000-CAQBDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBDX000000000-CAQBDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBEP000000000-CAQBEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBFB000000000-CAQBFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBFF000000000-CAQBFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBGT000000000-CAQBGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBGW000000000-CAQBGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBHB000000000-CAQBHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBHI000000000-CAQBHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBHR000000000-CAQBHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBIL000000000-CAQBIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBJF000000000-CAQBJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBJI000000000-CAQBJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBJO000000000-CAQBJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBKN000000000-CAQBKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBKW000000000-CAQBKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBKZ000000000-CAQBLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBLS000000000-CAQBLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBMH000000000-CAQBMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBMV000000000-CAQBMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBNG000000000-CAQBNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBON000000000-CAQBOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBOT000000000-CAQBOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBPS000000000-CAQBPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBQC000000000-CAQBQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBQH000000000-CAQBQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBRA000000000-CAQBRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRE000000000-CAQBRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBSD000000000-CAQBSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBSX000000000-CAQBSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBTI000000000-CAQBTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBUD000000000-CAQBUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBVA000000000-CAQBVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBVI000000000-CAQBVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBVU000000000-CAQBVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBWB000000000-CAQBWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBWU000000000-CAQBWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBXV000000000-CAQBXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBXY000000000-CAQBXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBZB000000000-CAQBZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBZG000000000-CAQBZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCAM000000000-CAQCAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCCB000000000-CAQCCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCCG000000000-CAQCCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCDH000000000-CAQCDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCDM000000000-CAQCDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCDP000000000-CAQCDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCEB000000000-CAQCEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCEX000000000-CAQCEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCFF000000000-CAQCFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCFX000000000-CAQCFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCGF000000000-CAQCGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCHA000000000-CAQCHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCIB000000000-CAQCIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCJF000000000-CAQCJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJL000000000-CAQCJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCJZ000000000-CAQCKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCKS000000000-CAQCKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCLL000000000-CAQCLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCLP000000000-CAQCLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCMH000000000-CAQCMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCMN000000000-CAQCMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCMT000000000-CAQCMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCNA000000000-CAQCNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCNM000000000-CAQCNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCNX000000000-CAQCNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCOF000000000-CAQCOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCQS000000000-CAQCQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCRB000000000-CAQCRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCRN000000000-CAQCRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCRQ000000000-CAQCRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCSH000000000-CAQCSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCTH000000000-CAQCTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCXT000000000-CAQCXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCZF000000000-CAQCZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZI000000000-CAQCZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCZZ000000000-CAQDAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDAJ000000000-CAQDAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDBR000000000-CAQDBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDCP000000000-CAQDCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDEZ000000000-CAQDFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFC000000000-CAQDFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDFK000000000-CAQDFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFQ000000000-CAQDFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDGF000000000-CAQDGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDGM000000000-CAQDGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDHD000000000-CAQDHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDHH000000000-CAQDHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDHU000000000-CAQDHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDIB000000000-CAQDID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDIX000000000-CAQDIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJA000000000-CAQDJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDJK000000000-CAQDJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJP000000000-CAQDJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDKU000000000-CAQDKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDLE000000000-CAQDLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDME000000000-CAQDMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDMU000000000-CAQDMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDMZ000000000-CAQDNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNC000000000-CAQDNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDNS000000000-CAQDNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDPG000000000-CAQDPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDPZ000000000-CAQDQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDQE000000000-CAQDQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDQQ000000000-CAQDQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDRM000000000-CAQDRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDRW000000000-CAQDRX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDSO000000000-CAQDSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTM000000000-CAQDTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTW000000000-CAQDTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDUT000000000-CAQDUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDVN000000000-CAQDVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDWE000000000-CAQDWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDWN000000000-CAQDWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDWU000000000-CAQDWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDXR000000000-CAQDXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDYU000000000-CAQDYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDZC000000000-CAQDZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEAA000000000-CAQEAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEAU000000000-CAQEAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEBJ000000000-CAQEBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQECD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQECG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQECL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQECX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQECZ000000000-CAQEDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEDK000000000-CAQEDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEDN000000000-CAQEDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEEO000000000-CAQEEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEFG000000000-CAQEFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEFV000000000-CAQEFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEGT000000000-CAQEGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEHU000000000-CAQEHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEHY000000000-CAQEHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEID000000000-CAQEIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEII000000000-CAQEIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEIP000000000-CAQEIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEIZ000000000-CAQEJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJC000000000-CAQEJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEJM000000000-CAQEJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEJT000000000-CAQEJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEKF000000000-CAQEKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEKI000000000-CAQEKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEKX000000000-CAQEKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQELR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQELW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQELZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEME000000000-CAQEMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEMO000000000-CAQEMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQENA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQENC000000000-CAQEND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQENM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQENT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQENW000000000-CAQENY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEOL000000000-CAQEOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEOW000000000-CAQEOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEQD000000000-CAQEQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEQJ000000000-CAQEQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQERG000000000-CAQERH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQERJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQESI000000000-CAQESK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQESM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQESO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQESV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQESZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQETE000000000-CAQETF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQETK000000000-CAQETN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEUE000000000-CAQEUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEUT000000000-CAQEUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEVF000000000-CAQEVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEVQ000000000-CAQEVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEVU000000000-CAQEVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEWD000000000-CAQEWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEWZ000000000-CAQEXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEXR000000000-CAQEXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEYK000000000-CAQEYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEZM000000000-CAQEZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFAC000000000-CAQFAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFAO000000000-CAQFAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFAR000000000-CAQFAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFAX000000000-CAQFAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFBC000000000-CAQFBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFBZ000000000-CAQFCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFCO000000000-CAQFCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFDG000000000-CAQFDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFEJ000000000-CAQFEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFGC000000000-CAQFGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFGR000000000-CAQFGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFHI000000000-CAQFHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFHT000000000-CAQFHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFIA000000000-CAQFIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFIL000000000-CAQFIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFIT000000000-CAQFIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFIX000000000-CAQFIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFKB000000000-CAQFKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFKM000000000-CAQFKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFKQ000000000-CAQFKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFLG000000000-CAQFLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFLY000000000-CAQFMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFMD000000000-CAQFME999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFNF000000000-CAQFNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFNX000000000-CAQFNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFOQ000000000-CAQFOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFOT000000000-CAQFOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFPK000000000-CAQFPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFPU000000000-CAQFPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFQE000000000-CAQFQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFTI000000000-CAQFTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFTX000000000-CAQFTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFUK000000000-CAQFUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUP000000000-CAQFUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUU000000000-CAQFUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUY000000000-CAQFUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFVD000000000-CAQFVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFVK000000000-CAQFVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFVS000000000-CAQFVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFWI000000000-CAQFWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFXA000000000-CAQFXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFXM000000000-CAQFXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFYP000000000-CAQFYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFYX000000000-CAQFYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFZN000000000-CAQFZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFZY000000000-CAQGAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGAR000000000-CAQGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGBH000000000-CAQGBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGBM000000000-CAQGBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGBZ000000000-CAQGCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGCF000000000-CAQGCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGCM000000000-CAQGCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCT000000000-CAQGCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGDQ000000000-CAQGDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGFH000000000-CAQGFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGHE000000000-CAQGHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGHS000000000-CAQGHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGIR000000000-CAQGIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGJC000000000-CAQGJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGJL000000000-CAQGJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGKG000000000-CAQGKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGKR000000000-CAQGKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGLL000000000-CAQGLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGLU000000000-CAQGLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGLY000000000-CAQGLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGMK000000000-CAQGML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGMO000000000-CAQGMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGNB000000000-CAQGNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGNV000000000-CAQGNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGOV000000000-CAQGOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGPJ000000000-CAQGPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGPQ000000000-CAQGPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGQU000000000-CAQGQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGRU000000000-CAQGRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGSM000000000-CAQGSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGSU000000000-CAQGSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGSZ000000000-CAQGTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGTO000000000-CAQGTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGUD000000000-CAQGUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGUL000000000-CAQGUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGVX000000000-CAQGVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGWC000000000-CAQGWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGWZ000000000-CAQGXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGXC000000000-CAQGXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGXK000000000-CAQGXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGXW000000000-CAQGXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGYC000000000-CAQGYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGYK000000000-CAQGYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGYO000000000-CAQGYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGYV000000000-CAQGYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGZR000000000-CAQGZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGZW000000000-CAQGZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHAA000000000-CAQHAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHBD000000000-CAQHBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHCD000000000-CAQHCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHCL000000000-CAQHCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHDI000000000-CAQHDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHDP000000000-CAQHDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHEB000000000-CAQHEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHEQ000000000-CAQHER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHFQ000000000-CAQHFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHGB000000000-CAQHGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHHB000000000-CAQHHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHHL000000000-CAQHHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHIG000000000-CAQHIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHIN000000000-CAQHIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHIX000000000-CAQHIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHJO000000000-CAQHJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHJR000000000-CAQHJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHKD000000000-CAQHKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKJ000000000-CAQHKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHKX000000000-CAQHKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHLP000000000-CAQHLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHLU000000000-CAQHLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHME000000000-CAQHMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHMY000000000-CAQHMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHNC000000000-CAQHNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHNQ000000000-CAQHNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHNW000000000-CAQHNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHOK000000000-CAQHOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHOS000000000-CAQHOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHPK000000000-CAQHPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHPY000000000-CAQHPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHQE000000000-CAQHQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHQV000000000-CAQHQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHUB000000000-CAQHUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHVA000000000-CAQHVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHVR000000000-CAQHVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHWG000000000-CAQHWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHWN000000000-CAQHWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHXI000000000-CAQHXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHXP000000000-CAQHXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHYI000000000-CAQHYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHYO000000000-CAQHYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHZI000000000-CAQHZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHZS000000000-CAQHZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZX000000000-CAQHZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIAR000000000-CAQIAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIAW000000000-CAQIAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIBH000000000-CAQIBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIBR000000000-CAQIBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIDA000000000-CAQIDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIDH000000000-CAQIDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIDU000000000-CAQIDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIEA000000000-CAQIEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIEU000000000-CAQIEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIJC000000000-CAQIJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIJM000000000-CAQIJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIKZ000000000-CAQILA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQILG000000000-CAQILH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQILO000000000-CAQILP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQILT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQILX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIMA000000000-CAQIMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIMK000000000-CAQIML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIMR000000000-CAQIMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMV000000000-CAQIMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQINC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQINE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQINN000000000-CAQINO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQINS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQINX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIQR000000000-CAQIQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIRD000000000-CAQIRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIRK000000000-CAQIRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIRY000000000-CAQIRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQISC000000000-CAQISD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQISM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIST000000000-CAQISU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQISW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQISZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQITH000000000-CAQITL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQITU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQITX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIUD000000000-CAQIUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIUX000000000-CAQIUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIWE000000000-CAQIWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIXI000000000-CAQIXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIXZ000000000-CAQIYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIZJ000000000-CAQIZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJAB000000000-CAQJAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJAZ000000000-CAQJBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJBL000000000-CAQJBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJCC000000000-CAQJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJCW000000000-CAQJCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJDF000000000-CAQJDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJDJ000000000-CAQJDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJEF000000000-CAQJEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJEJ000000000-CAQJEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJFH000000000-CAQJFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJFM000000000-CAQJFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJFQ000000000-CAQJFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJFV000000000-CAQJFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJGU000000000-CAQJGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJKM000000000-CAQJKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJKZ000000000-CAQJLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJLE000000000-CAQJLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJLK000000000-CAQJLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJLZ000000000-CAQJMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJMM000000000-CAQJMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJNP000000000-CAQJNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJOB000000000-CAQJOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJOI000000000-CAQJOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJPL000000000-CAQJPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJQQ000000000-CAQJQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJQY000000000-CAQJQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJRH000000000-CAQJRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJTR000000000-CAQJTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJTW000000000-CAQJTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJUW000000000-CAQJUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJVL000000000-CAQJVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJWA000000000-CAQJWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJXD000000000-CAQJXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJYE000000000-CAQJYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJYH000000000-CAQJYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJYX000000000-CAQJYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJZE000000000-CAQJZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJZP000000000-CAQJZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJZS000000000-CAQJZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKAH000000000-CAQKAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKAM000000000-CAQKAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKBZ000000000-CAQKCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKCO000000000-CAQKCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKDI000000000-CAQKDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKDR000000000-CAQKDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKEP000000000-CAQKEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKET000000000-CAQKEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKEY000000000-CAQKEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKFK000000000-CAQKFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKFT000000000-CAQKFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKGR000000000-CAQKGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKHM000000000-CAQKHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKIA000000000-CAQKIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKIG000000000-CAQKIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKIK000000000-CAQKIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKJY000000000-CAQKJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKKF000000000-CAQKKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKLE000000000-CAQKLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKMG000000000-CAQKMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKNA000000000-CAQKNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKND000000000-CAQKNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKNX000000000-CAQKNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKOX000000000-CAQKOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKRU000000000-CAQKRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKSY000000000-CAQKSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKTL000000000-CAQKTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKTU000000000-CAQKTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKUK000000000-CAQKUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKUX000000000-CAQKUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKWI000000000-CAQKWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKWY000000000-CAQKWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKXY000000000-CAQKXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKZG000000000-CAQKZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLAF000000000-CAQLAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLBC000000000-CAQLBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLBF000000000-CAQLBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLCJ000000000-CAQLCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLCR000000000-CAQLCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLDD000000000-CAQLDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLED000000000-CAQLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEG000000000-CAQLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEJ000000000-CAQLEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLFH000000000-CAQLFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLGO000000000-CAQLGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLGY000000000-CAQLGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLHM000000000-CAQLHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLHW000000000-CAQLHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLIA000000000-CAQLIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLIN000000000-CAQLIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLIX000000000-CAQLIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLJP000000000-CAQLJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLKZ000000000-CAQLLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLMC000000000-CAQLME999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLMY000000000-CAQLMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLOA000000000-CAQLOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLOZ000000000-CAQLPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLPS000000000-CAQLPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLRB000000000-CAQLRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLRK000000000-CAQLRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLSR000000000-CAQLSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLTQ000000000-CAQLTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLTU000000000-CAQLTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLUZ000000000-CAQLVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLVY000000000-CAQLVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLWD000000000-CAQLWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLXS000000000-CAQLXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLXX000000000-CAQLYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLYI000000000-CAQLYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLZL000000000-CAQLZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLZS000000000-CAQLZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLZX000000000-CAQLZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMAR000000000-CAQMAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMBP000000000-CAQMBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBU000000000-CAQMBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBY000000000-CAQMCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMDD000000000-CAQMDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMFE000000000-CAQMFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMFI000000000-CAQMFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMFQ000000000-CAQMFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMGT000000000-CAQMGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMHD000000000-CAQMHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMIT000000000-CAQMIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMJL000000000-CAQMJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMJR000000000-CAQMJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMJW000000000-CAQMJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMKS000000000-CAQMKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLA000000000-CAQMLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLS000000000-CAQMLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLY000000000-CAQMLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMMX000000000-CAQMMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMNO000000000-CAQMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMPF000000000-CAQMPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMPS000000000-CAQMPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMQL000000000-CAQMQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMQQ000000000-CAQMQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMRN000000000-CAQMRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMRT000000000-CAQMRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMSN000000000-CAQMSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMTI000000000-CAQMTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMTV000000000-CAQMTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMUO000000000-CAQMUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMVY000000000-CAQMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMWK000000000-CAQMWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMXA000000000-CAQMXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMYW000000000-CAQMYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNAX000000000-CAQNAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNBB000000000-CAQNBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNBT000000000-CAQNBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCA000000000-CAQNCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCH000000000-CAQNCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCN000000000-CAQNCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCU000000000-CAQNCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNDE000000000-CAQNDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDH000000000-CAQNDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDR000000000-CAQNDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNEB000000000-CAQNEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNEY000000000-CAQNEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNGD000000000-CAQNGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNHE000000000-CAQNHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNHM000000000-CAQNHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNHU000000000-CAQNHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNIM000000000-CAQNIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNJU000000000-CAQNJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNLA000000000-CAQNLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNLO000000000-CAQNLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNLW000000000-CAQNMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNMR000000000-CAQNMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNMW000000000-CAQNMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNNH000000000-CAQNNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNOR000000000-CAQNOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNQD000000000-CAQNQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNQH000000000-CAQNQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNRG000000000-CAQNRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNRL000000000-CAQNRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNRX000000000-CAQNRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNSD000000000-CAQNSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNSL000000000-CAQNSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNST000000000-CAQNSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNTF000000000-CAQNTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNTO000000000-CAQNTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNTS000000000-CAQNTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNUG000000000-CAQNUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUV000000000-CAQNUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUZ000000000-CAQNVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNVH000000000-CAQNVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVM000000000-CAQNVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVT000000000-CAQNVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVX000000000-CAQNVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNXD000000000-CAQNXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNXP000000000-CAQNXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNYD000000000-CAQNYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNYW000000000-CAQNYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNZM000000000-CAQNZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNZP000000000-CAQNZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNZV000000000-CAQNZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOAE000000000-CAQOAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOAN000000000-CAQOAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOAV000000000-CAQOAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOBH000000000-CAQOBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOBQ000000000-CAQOBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOCE000000000-CAQOCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOCK000000000-CAQOCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOCU000000000-CAQOCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOCX000000000-CAQOCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODB000000000-CAQODC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODF000000000-CAQODH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODV000000000-CAQODX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOEJ000000000-CAQOEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOET000000000-CAQOEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOFC000000000-CAQOFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOFL000000000-CAQOFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFR000000000-CAQOFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOGC000000000-CAQOGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOGF000000000-CAQOGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOGT000000000-CAQOGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOHT000000000-CAQOHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOIH000000000-CAQOII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOIN000000000-CAQOIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOJB000000000-CAQOJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOJL000000000-CAQOJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOJY000000000-CAQOJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOLQ000000000-CAQOLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOMM000000000-CAQOMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQONU000000000-CAQONX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOOX000000000-CAQOOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOPS000000000-CAQOPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOPY000000000-CAQOQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOQS000000000-CAQOQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQORB000000000-CAQORE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQORG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQORV000000000-CAQORW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOSG000000000-CAQOSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOTR000000000-CAQOTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOUE000000000-CAQOUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUJ000000000-CAQOUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUP000000000-CAQOUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOWD000000000-CAQOWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOWG000000000-CAQOWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOWT000000000-CAQOWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOXW000000000-CAQOXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOYL000000000-CAQOYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOYW000000000-CAQOYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOZS000000000-CAQOZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPBH000000000-CAQPBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPCN000000000-CAQPCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPEQ000000000-CAQPER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPEZ000000000-CAQPFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPFU000000000-CAQPFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPGO000000000-CAQPGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPHB000000000-CAQPHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPHR000000000-CAQPHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPHY000000000-CAQPHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPIR000000000-CAQPIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPJQ000000000-CAQPJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPJT000000000-CAQPJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPKQ000000000-CAQPKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPLT000000000-CAQPLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPLW000000000-CAQPLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPMS000000000-CAQPMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPPK000000000-CAQPPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPQR000000000-CAQPQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPRN000000000-CAQPRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPRQ000000000-CAQPRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPSK000000000-CAQPSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPSS000000000-CAQPST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPTH000000000-CAQPTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPVP000000000-CAQPVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPVV000000000-CAQPVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPXD000000000-CAQPXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPXO000000000-CAQPXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPXU000000000-CAQPXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQAK000000000-CAQQAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQAO000000000-CAQQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQBC000000000-CAQQBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQCG000000000-CAQQCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQDB000000000-CAQQDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQDK000000000-CAQQDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQDR000000000-CAQQDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDV000000000-CAQQDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQFL000000000-CAQQFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQFP000000000-CAQQFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQFT000000000-CAQQFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQGB000000000-CAQQGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQGX000000000-CAQQGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQHA000000000-CAQQHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQHE000000000-CAQQHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQIA000000000-CAQQIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQIF000000000-CAQQIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQII000000000-CAQQIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQIU000000000-CAQQIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQJG000000000-CAQQJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQJO000000000-CAQQJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQKH000000000-CAQQKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQKN000000000-CAQQKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQKS000000000-CAQQKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQLX000000000-CAQQMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQPM000000000-CAQQPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQPV000000000-CAQQPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQQB000000000-CAQQQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQQS000000000-CAQQQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQQZ000000000-CAQQRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRE000000000-CAQQRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRI000000000-CAQQRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQRO000000000-CAQQRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRV000000000-CAQQRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQSH000000000-CAQQSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQVJ000000000-CAQQVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQWW000000000-CAQQXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQXF000000000-CAQQXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQYF000000000-CAQQYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQYO000000000-CAQQYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQZC000000000-CAQQZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQZV000000000-CAQQZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRAR000000000-CAQRAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRBJ000000000-CAQRBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRCA000000000-CAQRCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRCD000000000-CAQRCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRCT000000000-CAQRCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRDK000000000-CAQRDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQREB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQREE000000000-CAQREF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQREM000000000-CAQREN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQREP000000000-CAQREQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRGS000000000-CAQRGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRHG000000000-CAQRHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRHT000000000-CAQRHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRID000000000-CAQRIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRIN000000000-CAQRIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRKB000000000-CAQRKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRKK000000000-CAQRKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRLB000000000-CAQRLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRLZ000000000-CAQRMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRMJ000000000-CAQRML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRMZ000000000-CAQRNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRNC000000000-CAQRND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRNO000000000-CAQRNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRNY000000000-CAQRNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQROF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRPB000000000-CAQRPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRPS000000000-CAQRPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRPY000000000-CAQRPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRQJ000000000-CAQRQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRRE000000000-CAQRRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRRP000000000-CAQRRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRSJ000000000-CAQRSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRSY000000000-CAQRSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRTN000000000-CAQRTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRTX000000000-CAQRTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRUC000000000-CAQRUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRVH000000000-CAQRVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRVK000000000-CAQRVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRWB000000000-CAQRWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRWR000000000-CAQRWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRXF000000000-CAQRXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRYF000000000-CAQRYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRYT000000000-CAQRYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRZG000000000-CAQRZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRZY000000000-CAQRZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSAJ000000000-CAQSAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSBA000000000-CAQSBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSBZ000000000-CAQSCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSCW000000000-CAQSCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSDJ000000000-CAQSDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSEE000000000-CAQSEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSFZ000000000-CAQSGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSGS000000000-CAQSGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSHK000000000-CAQSHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSHS000000000-CAQSHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSIW000000000-CAQSIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSJE000000000-CAQSJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSJK000000000-CAQSJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSKB000000000-CAQSKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSKM000000000-CAQSKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSKW000000000-CAQSKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSLL000000000-CAQSLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSLR000000000-CAQSLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSNI000000000-CAQSNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSOB000000000-CAQSOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSQU000000000-CAQSQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSRM000000000-CAQSRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSSC000000000-CAQSSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSST000000000-CAQSSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSTF000000000-CAQSTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSTP000000000-CAQSTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSUH000000000-CAQSUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSUY000000000-CAQSUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVB000000000-CAQSVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSWS000000000-CAQSWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSWW000000000-CAQSWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSXL000000000-CAQSXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSXP000000000-CAQSXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSZI000000000-CAQSZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSZZ000000000-CAQTAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTCG000000000-CAQTCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTCK000000000-CAQTCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTCZ000000000-CAQTDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTFZ000000000-CAQTGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTGX000000000-CAQTGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTHU000000000-CAQTHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTIQ000000000-CAQTIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTIY000000000-CAQTJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJD000000000-CAQTJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTJI000000000-CAQTJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTKD000000000-CAQTKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTKI000000000-CAQTKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTKY000000000-CAQTKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTLC000000000-CAQTLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTLK000000000-CAQTLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTMD000000000-CAQTME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTMH000000000-CAQTMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTNY000000000-CAQTNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTON000000000-CAQTOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTPE000000000-CAQTPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTPV000000000-CAQTPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTQE000000000-CAQTQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTQH000000000-CAQTQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTSO000000000-CAQTSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTSR000000000-CAQTSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTTD000000000-CAQTTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTUD000000000-CAQTUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTWB000000000-CAQTWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTWN000000000-CAQTWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTXB000000000-CAQTXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTXT000000000-CAQTXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTYB000000000-CAQTYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTYU000000000-CAQTYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUAF000000000-CAQUAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUAQ000000000-CAQUAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUBI000000000-CAQUBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUBU000000000-CAQUBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUCT000000000-CAQUCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUEA000000000-CAQUEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUEQ000000000-CAQUER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUFI000000000-CAQUFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUFL000000000-CAQUFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUGW000000000-CAQUGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUHR000000000-CAQUHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUIZ000000000-CAQUJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUJK000000000-CAQUJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUJU000000000-CAQUJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUJY000000000-CAQUJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUKJ000000000-CAQUKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQULA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQULC000000000-CAQULE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQULH000000000-CAQULI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQULL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQULW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQULZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUMK000000000-CAQUML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUMN000000000-CAQUMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUMU000000000-CAQUMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUND000000000-CAQUNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUNN000000000-CAQUNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUPU000000000-CAQUPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUQI000000000-CAQUQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUQT000000000-CAQUQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQURE000000000-CAQURF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQURT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQURY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUSQ000000000-CAQUSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUTK000000000-CAQUTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUTP000000000-CAQUTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUUZ000000000-CAQUVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUVZ000000000-CAQUWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUWQ000000000-CAQUWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUXO000000000-CAQUXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUXU000000000-CAQUXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVAH000000000-CAQVAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVAK000000000-CAQVAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVAQ000000000-CAQVAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVBS000000000-CAQVBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVCS000000000-CAQVCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVCX000000000-CAQVCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVEB000000000-CAQVEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVFE000000000-CAQVFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVGA000000000-CAQVGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVGW000000000-CAQVGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVHA000000000-CAQVHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVHS000000000-CAQVHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVIC000000000-CAQVID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVIF000000000-CAQVIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVJD000000000-CAQVJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVJO000000000-CAQVJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVKK000000000-CAQVKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVNL000000000-CAQVNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVNP000000000-CAQVNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVNW000000000-CAQVNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVOC000000000-CAQVOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVOK000000000-CAQVOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVON000000000-CAQVOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVOZ000000000-CAQVPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVQB000000000-CAQVQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVQI000000000-CAQVQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVRA000000000-CAQVRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVRR000000000-CAQVRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVRV000000000-CAQVRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVSD000000000-CAQVSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSG000000000-CAQVSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSL000000000-CAQVSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVTF000000000-CAQVTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVTK000000000-CAQVTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVUW000000000-CAQVUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVVM000000000-CAQVVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVVS000000000-CAQVVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWC000000000-CAQVWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWW000000000-CAQVWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVXK000000000-CAQVXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVXP000000000-CAQVXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVXX000000000-CAQVXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVYK000000000-CAQVYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVYU000000000-CAQVYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVYZ000000000-CAQVZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVZZ000000000-CAQWAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWBD000000000-CAQWBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWBO000000000-CAQWBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWCR000000000-CAQWCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWCZ000000000-CAQWDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWFX000000000-CAQWFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWGJ000000000-CAQWGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWHM000000000-CAQWHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWIE000000000-CAQWIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWIH000000000-CAQWII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWIK000000000-CAQWIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWIU000000000-CAQWIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWJK000000000-CAQWJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWJZ000000000-CAQWKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWKT000000000-CAQWKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWML000000000-CAQWMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWMZ000000000-CAQWNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWNE000000000-CAQWNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWNK000000000-CAQWNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWNX000000000-CAQWNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWOR000000000-CAQWOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWPJ000000000-CAQWPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWPQ000000000-CAQWPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWQL000000000-CAQWQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWQP000000000-CAQWQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWRC000000000-CAQWRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWRW000000000-CAQWRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWSR000000000-CAQWSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWSV000000000-CAQWSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWTF000000000-CAQWTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWTM000000000-CAQWTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWUI000000000-CAQWUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWUM000000000-CAQWUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWUX000000000-CAQWVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWVK000000000-CAQWVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWXV000000000-CAQWXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWYN000000000-CAQWYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWZP000000000-CAQWZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXAH000000000-CAQXAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXAT000000000-CAQXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXBL000000000-CAQXBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXCM000000000-CAQXCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXCZ000000000-CAQXDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXEK000000000-CAQXEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEN000000000-CAQXEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEQ000000000-CAQXES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEV000000000-CAQXEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXGQ000000000-CAQXGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXHF000000000-CAQXHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXHP000000000-CAQXHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXIV000000000-CAQXIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXJE000000000-CAQXJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXJO000000000-CAQXJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXJV000000000-CAQXJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXKD000000000-CAQXKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXKK000000000-CAQXKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXKQ000000000-CAQXKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXLN000000000-CAQXLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXMF000000000-CAQXMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXMM000000000-CAQXMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXNC000000000-CAQXNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXNP000000000-CAQXNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNT000000000-CAQXNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNY000000000-CAQXOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXOE000000000-CAQXOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXOV000000000-CAQXOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXPH000000000-CAQXPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXPK000000000-CAQXPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXPR000000000-CAQXPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXQA000000000-CAQXQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXQD000000000-CAQXQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXQL000000000-CAQXQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXQZ000000000-CAQXRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXRK000000000-CAQXRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXRX000000000-CAQXRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXSG000000000-CAQXSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXSJ000000000-CAQXSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXSR000000000-CAQXSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXUG000000000-CAQXUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXUM000000000-CAQXUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXUU000000000-CAQXUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXVR000000000-CAQXVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXVY000000000-CAQXVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXWN000000000-CAQXWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXXG000000000-CAQXXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXYC000000000-CAQXYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXZI000000000-CAQXZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXZQ000000000-CAQXZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYAB000000000-CAQYAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAJ000000000-CAQYAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAN000000000-CAQYAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAT000000000-CAQYAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAW000000000-CAQYAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYBX000000000-CAQYBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYCO000000000-CAQYCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYDC000000000-CAQYDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYEF000000000-CAQYEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYEO000000000-CAQYEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYEZ000000000-CAQYFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYFT000000000-CAQYFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYHL000000000-CAQYHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYHU000000000-CAQYHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYID000000000-CAQYIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYIW000000000-CAQYIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYJB000000000-CAQYJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYJK000000000-CAQYJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYKK000000000-CAQYKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYKP000000000-CAQYKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYME000000000-CAQYMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYML000000000-CAQYMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYMZ000000000-CAQYNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYNV000000000-CAQYNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYOM000000000-CAQYOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYOU000000000-CAQYOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYPJ000000000-CAQYPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYQF000000000-CAQYQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYQL000000000-CAQYQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYRY000000000-CAQYSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTC000000000-CAQYTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTM000000000-CAQYTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTT000000000-CAQYTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYXV000000000-CAQYXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYYE000000000-CAQYYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYYT000000000-CAQYYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYZE000000000-CAQYZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYZT000000000-CAQYZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZBN000000000-CAQZBO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZCB000000000-CAQZCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZCU000000000-CAQZCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZDF000000000-CAQZDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZDR000000000-CAQZDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZDX000000000-CAQZDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZEL000000000-CAQZEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZER000000000-CAQZES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZFX000000000-CAQZFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZIE000000000-CAQZIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZIS000000000-CAQZIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZJU000000000-CAQZJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZKW000000000-CAQZKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZLX000000000-CAQZLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZNA000000000-CAQZNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZNP000000000-CAQZNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZNX000000000-CAQZNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZOE000000000-CAQZOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZOX000000000-CAQZOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZPE000000000-CAQZPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZPS000000000-CAQZPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZQN000000000-CAQZQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZSA000000000-CAQZSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZSH000000000-CAQZSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZTB000000000-CAQZTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZTV000000000-CAQZTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZTY000000000-CAQZTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZUD000000000-CAQZUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZVA000000000-CAQZVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZVO000000000-CAQZVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZWJ000000000-CAQZWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZWS000000000-CAQZWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZXI000000000-CAQZXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZZO000000000-CAQZZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAAG000000000-CARAAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAAS000000000-CARAAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARABM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARABQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARABU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARABW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARACC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARACP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARACR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARACU000000000-CARACV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARACX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARADH000000000-CARADI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARADM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAEF000000000-CARAEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAEM000000000-CARAEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAEW000000000-CARAEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAFD000000000-CARAFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAFL000000000-CARAFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAGQ000000000-CARAGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAHG000000000-CARAHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAHO000000000-CARAHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAIO000000000-CARAIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAKA000000000-CARAKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAKI000000000-CARAKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKU000000000-CARAKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARALB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARALG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARALJ000000000-CARALK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARALM000000000-CARALN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARALQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARALS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARALU000000000-CARALW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARALZ000000000-CARAMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMD000000000-CARAMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMJ000000000-CARAMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARANC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARANI000000000-CARANK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARANO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARANX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAPL000000000-CARAPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAQL000000000-CARAQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARARC000000000-CARARD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARARF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARARK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARARW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARARY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARASA000000000-CARASB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARASD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARASV000000000-CARASX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARASZ000000000-CARATA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARATH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARATP000000000-CARATQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARATS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARATW000000000-CARATY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAUC000000000-CARAUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAVI000000000-CARAVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAVS000000000-CARAVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAWB000000000-CARAWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAWF000000000-CARAWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAXM000000000-CARAXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAXR000000000-CARAXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAYA000000000-CARAYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAZF000000000-CARAZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAZK000000000-CARAZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAZO000000000-CARAZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBAI000000000-CARBAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBAQ000000000-CARBAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBBB000000000-CARBBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBBJ000000000-CARBBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBBO000000000-CARBBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBBX000000000-CARBBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBCC000000000-CARBCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBCI000000000-CARBCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDC000000000-CARBDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDH000000000-CARBDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDQ000000000-CARBDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDZ000000000-CARBEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBEG000000000-CARBEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBEN000000000-CARBEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBER000000000-CARBES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBGS000000000-CARBGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBGX000000000-CARBGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBHE000000000-CARBHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBHR000000000-CARBHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBIC000000000-CARBIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBKS000000000-CARBKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBKW000000000-CARBKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBLI000000000-CARBLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBMD000000000-CARBME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBMG000000000-CARBMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBMJ000000000-CARBMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBMT000000000-CARBMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBOP000000000-CARBOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBOS000000000-CARBOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBPH000000000-CARBPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBPM000000000-CARBPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBTG000000000-CARBTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBUN000000000-CARBUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBUW000000000-CARBUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBVT000000000-CARBVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBWJ000000000-CARBWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBWS000000000-CARBWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBXH000000000-CARBXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBXS000000000-CARBXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBXZ000000000-CARBYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYC000000000-CARBYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYH000000000-CARBYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYM000000000-CARBYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBZV000000000-CARBZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCAT000000000-CARCAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCBD000000000-CARCBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCCS000000000-CARCCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCDB000000000-CARCDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCDK000000000-CARCDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCDU000000000-CARCDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCEG000000000-CARCEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCEW000000000-CARCEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCFX000000000-CARCFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCIK000000000-CARCIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCJC000000000-CARCJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCJG000000000-CARCJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCJQ000000000-CARCJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCMM000000000-CARCMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCMR000000000-CARCMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCNL000000000-CARCNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCNX000000000-CARCNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCOK000000000-CARCOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCOV000000000-CARCOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCQF000000000-CARCQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCQO000000000-CARCQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCRF000000000-CARCRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCRO000000000-CARCRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCSV000000000-CARCSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCTN000000000-CARCTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCTT000000000-CARCTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCUL000000000-CARCUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCUU000000000-CARCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCVE000000000-CARCVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCVT000000000-CARCVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCWF000000000-CARCWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCWY000000000-CARCWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCXZ000000000-CARCYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCYN000000000-CARCYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCZA000000000-CARCZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCZK000000000-CARCZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCZZ000000000-CARDAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAC000000000-CARDAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDAZ000000000-CARDBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDCF000000000-CARDCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDCJ000000000-CARDCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDCY000000000-CARDDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDEO000000000-CARDEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDFC000000000-CARDFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFI000000000-CARDFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFN000000000-CARDFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDGP000000000-CARDGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHH000000000-CARDHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHS000000000-CARDHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHZ000000000-CARDIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDII000000000-CARDIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDIL000000000-CARDIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDIQ000000000-CARDIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDJA000000000-CARDJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDJG000000000-CARDJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDKL000000000-CARDKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDKO000000000-CARDKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDKZ000000000-CARDLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDLL000000000-CARDLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDLY000000000-CARDLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDMR000000000-CARDMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDMU000000000-CARDMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDMZ000000000-CARDNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDNO000000000-CARDNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDOE000000000-CARDOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDRJ000000000-CARDRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDSC000000000-CARDSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDSP000000000-CARDSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDTD000000000-CARDTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDTL000000000-CARDTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTO000000000-CARDTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTX000000000-CARDTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDUW000000000-CARDUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDVF000000000-CARDVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDVX000000000-CARDVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDWV000000000-CARDWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDYE000000000-CARDYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREAU000000000-CAREAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREBP000000000-CAREBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARECH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARECJ000000000-CARECK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARECN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARECT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARECV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARECX000000000-CARECY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREDE000000000-CAREDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREEA000000000-CAREEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREEP000000000-CAREEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREFN000000000-CAREFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREGQ000000000-CAREGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREGW000000000-CAREGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREIC000000000-CAREID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREIW000000000-CAREIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREJP000000000-CAREJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREKA000000000-CAREKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREKY000000000-CAREKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELF000000000-CARELG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELJ000000000-CARELK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELN000000000-CARELO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARELX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARENC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARENI000000000-CARENK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARENN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARENQ000000000-CARENR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARENW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARENY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREPB000000000-CAREPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREQA000000000-CAREQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREQF000000000-CAREQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREQL000000000-CAREQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARERB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARERD000000000-CARERE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARERG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARERJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARERL000000000-CARERM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARERR000000000-CARERS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARESJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARESQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARETC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARETG000000000-CARETH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARETL000000000-CARETM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARETO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARETQ000000000-CARETR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARETV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARETY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREUA000000000-CAREUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUD000000000-CAREUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUH000000000-CAREUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUO000000000-CAREUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREVL000000000-CAREVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREWG000000000-CAREWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWK000000000-CAREWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREXA000000000-CAREXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZB000000000-CAREZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREZG000000000-CAREZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZW000000000-CAREZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAC000000000-CARFAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFAI000000000-CARFAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAM000000000-CARFAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFAX000000000-CARFAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFBD000000000-CARFBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFBP000000000-CARFBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFCF000000000-CARFCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFCW000000000-CARFCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFDB000000000-CARFDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFEB000000000-CARFEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEE000000000-CARFEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEO000000000-CARFEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFER000000000-CARFES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEW000000000-CARFEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEZ000000000-CARFFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFFI000000000-CARFFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFGB000000000-CARFGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFGP000000000-CARFGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFGW000000000-CARFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFHF000000000-CARFHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFHU000000000-CARFHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFIC000000000-CARFID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIJ000000000-CARFIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIO000000000-CARFIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFJZ000000000-CARFKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFKS000000000-CARFKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFKY000000000-CARFKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFMA000000000-CARFMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFMG000000000-CARFMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFMV000000000-CARFMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFNB000000000-CARFNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFNF000000000-CARFNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFNL000000000-CARFNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFOB000000000-CARFOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFOR000000000-CARFOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFOW000000000-CARFOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFPT000000000-CARFPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFRB000000000-CARFRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFRS000000000-CARFRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFSD000000000-CARFSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFSV000000000-CARFSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFTH000000000-CARFTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFTS000000000-CARFTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFTV000000000-CARFTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFTY000000000-CARFUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFUU000000000-CARFUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFVE000000000-CARFVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFVP000000000-CARFVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFWD000000000-CARFWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFXL000000000-CARFXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFXW000000000-CARFXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFYD000000000-CARFYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFYK000000000-CARFYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFZL000000000-CARFZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFZY000000000-CARFZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGAI000000000-CARGAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGAP000000000-CARGAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGBP000000000-CARGBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGBV000000000-CARGBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGCE000000000-CARGCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGCM000000000-CARGCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGDU000000000-CARGDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGFB000000000-CARGFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGGB000000000-CARGGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGGI000000000-CARGGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGGM000000000-CARGGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGHF000000000-CARGHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGIE000000000-CARGIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGIO000000000-CARGIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGIT000000000-CARGIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGJQ000000000-CARGJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGMA000000000-CARGMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGNB000000000-CARGNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGNE000000000-CARGNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGNS000000000-CARGNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGOD000000000-CARGOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGOK000000000-CARGOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGQC000000000-CARGQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGQS000000000-CARGQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGQW000000000-CARGQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGSL000000000-CARGSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGUQ000000000-CARGUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGVC000000000-CARGVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGVS000000000-CARGVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGVY000000000-CARGVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGWT000000000-CARGWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGXD000000000-CARGXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGXR000000000-CARGXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGXU000000000-CARGXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGYE000000000-CARGYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGZJ000000000-CARGZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGZP000000000-CARGZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGZZ000000000-CARHAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHAP000000000-CARHAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHAX000000000-CARHAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHBL000000000-CARHBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHBZ000000000-CARHCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHCT000000000-CARHCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHDA000000000-CARHDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHEP000000000-CARHEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHFQ000000000-CARHFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHGV000000000-CARHGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHHA000000000-CARHHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHHE000000000-CARHHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHHM000000000-CARHHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHIB000000000-CARHIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHIR000000000-CARHIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHJD000000000-CARHJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHJN000000000-CARHJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHJR000000000-CARHJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHJX000000000-CARHJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHKI000000000-CARHKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHLG000000000-CARHLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHLZ000000000-CARHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHME000000000-CARHMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHMU000000000-CARHMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHNU000000000-CARHNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHNY000000000-CARHNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHOC000000000-CARHOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHOF000000000-CARHOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHOU000000000-CARHOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHPC000000000-CARHPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHQB000000000-CARHQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHQJ000000000-CARHQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHRE000000000-CARHRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHRK000000000-CARHRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHRT000000000-CARHRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHSD000000000-CARHSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHSM000000000-CARHSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHSV000000000-CARHSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHTP000000000-CARHTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHUA000000000-CARHUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHUF000000000-CARHUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHUO000000000-CARHUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHUZ000000000-CARHVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHVL000000000-CARHVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHXA000000000-CARHXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARHXY000000000-CARHXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHYB000000000-CARHYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARHYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARHZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIAE000000000-CARIAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIAL000000000-CARIAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIAT000000000-CARIAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIBO000000000-CARIBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIBY000000000-CARICB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARICD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARICI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARICK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARICQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARICU000000000-CARICW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARICY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIDY000000000-CARIEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIED000000000-CARIEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIFJ000000000-CARIFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIFO000000000-CARIFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIGA000000000-CARIGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIGJ000000000-CARIGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIGS000000000-CARIGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIHV000000000-CARIHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIIO000000000-CARIIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIIY000000000-CARIIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIJC000000000-CARIJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIJQ000000000-CARIJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIKF000000000-CARIKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIKL000000000-CARIKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARILA000000000-CARILC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARILI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARILN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARILR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARILT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARILW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIME000000000-CARIMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIMH000000000-CARIMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIMM000000000-CARIMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARINA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARINK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARINN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARINT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARINY000000000-CARINZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIPB000000000-CARIPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPN000000000-CARIPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPS000000000-CARIPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPV000000000-CARIPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPY000000000-CARIQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIQJ000000000-CARIQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIQR000000000-CARIQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIRE000000000-CARIRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIRN000000000-CARIRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIRT000000000-CARIRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARISE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARISJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARISM000000000-CARISO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARISQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARISY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARITA000000000-CARITB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARITD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARITH000000000-CARITI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARITL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARITR000000000-CARITS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARITU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARITW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIVC000000000-CARIVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIVM000000000-CARIVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIVW000000000-CARIVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIWM000000000-CARIWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIXH000000000-CARIXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIXW000000000-CARIXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARIZQ000000000-CARIZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARIZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARIZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJAH000000000-CARJAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJBK000000000-CARJBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJBN000000000-CARJBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJBU000000000-CARJBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJCM000000000-CARJCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJDH000000000-CARJDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJFM000000000-CARJFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJFT000000000-CARJFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJFW000000000-CARJFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJGO000000000-CARJGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJGZ000000000-CARJHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJIW000000000-CARJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJJD000000000-CARJJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJJU000000000-CARJJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJKG000000000-CARJKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJKT000000000-CARJKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJKW000000000-CARJLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJME000000000-CARJMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJMH000000000-CARJMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJMV000000000-CARJMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJNY000000000-CARJNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJOG000000000-CARJOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJOU000000000-CARJOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJOY000000000-CARJPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJPK000000000-CARJPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJPU000000000-CARJPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJQC000000000-CARJQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJRC000000000-CARJRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJSG000000000-CARJSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJSM000000000-CARJSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJST000000000-CARJSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJTV000000000-CARJTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJUB000000000-CARJUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJVP000000000-CARJVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJWA000000000-CARJWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJWI000000000-CARJWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJWO000000000-CARJWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJWY000000000-CARJWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJXD000000000-CARJXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJXN000000000-CARJXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJYG000000000-CARJYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJYR000000000-CARJYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARJZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARJZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARJZM000000000-CARJZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJZQ000000000-CARJZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJZU000000000-CARJZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJZZ000000000-CARKAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKAS000000000-CARKAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKAW000000000-CARKAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKBH000000000-CARKBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKCQ000000000-CARKCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKCT000000000-CARKCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKDC000000000-CARKDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKDI000000000-CARKDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKED000000000-CARKEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKET000000000-CARKEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKFC000000000-CARKFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKFH000000000-CARKFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKGY000000000-CARKGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKHR000000000-CARKHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKHZ000000000-CARKIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKIQ000000000-CARKIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKIT000000000-CARKIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKKK000000000-CARKKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKMB000000000-CARKMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKME000000000-CARKMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKMR000000000-CARKMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKNQ000000000-CARKNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKOH000000000-CARKOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKOS000000000-CARKOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKPJ000000000-CARKPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKQK000000000-CARKQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKQN000000000-CARKQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKQV000000000-CARKQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKRA000000000-CARKRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKRN000000000-CARKRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKSK000000000-CARKSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKSR000000000-CARKSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKTC000000000-CARKTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKVB000000000-CARKVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKVP000000000-CARKVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKVY000000000-CARKVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKXD000000000-CARKXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKYT000000000-CARKYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARKYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKZE000000000-CARKZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKZP000000000-CARKZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARKZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARKZV000000000-CARKZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLBJ000000000-CARLBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLBQ000000000-CARLBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLCK000000000-CARLCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLDA000000000-CARLDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLDZ000000000-CARLEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLEG000000000-CARLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLES000000000-CARLET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLFW000000000-CARLFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLHM000000000-CARLHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLIA000000000-CARLIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLIS000000000-CARLIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLLZ000000000-CARLMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLMC000000000-CARLMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLNJ000000000-CARLNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLNN000000000-CARLNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLNT000000000-CARLNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLOM000000000-CARLOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLOU000000000-CARLOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLPB000000000-CARLPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLPF000000000-CARLPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLPN000000000-CARLPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLPV000000000-CARLPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLQG000000000-CARLQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLQR000000000-CARLQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLRD000000000-CARLRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLRG000000000-CARLRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLRP000000000-CARLRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLSB000000000-CARLSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLSW000000000-CARLSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLTE000000000-CARLTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLTH000000000-CARLTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLUE000000000-CARLUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLUR000000000-CARLUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLWK000000000-CARLWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLWX000000000-CARLWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLXK000000000-CARLXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLYN000000000-CARLYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARLZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLZP000000000-CARLZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLZX000000000-CARLZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMAG000000000-CARMAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMAS000000000-CARMAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMBJ000000000-CARMBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMBM000000000-CARMBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMBW000000000-CARMBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMCU000000000-CARMCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMDA000000000-CARMDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMDF000000000-CARMDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMER000000000-CARMES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMFC000000000-CARMFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMFN000000000-CARMFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMFW000000000-CARMFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMGB000000000-CARMGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMGE000000000-CARMGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMGP000000000-CARMGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMGV000000000-CARMGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMHI000000000-CARMHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMHP000000000-CARMHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMIA000000000-CARMIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMIP000000000-CARMIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMJN000000000-CARMJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMJT000000000-CARMJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMJY000000000-CARMKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMKI000000000-CARMKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMKP000000000-CARMKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMLA000000000-CARMLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMLK000000000-CARMLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMMD000000000-CARMME999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMMQ000000000-CARMMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMMZ000000000-CARMNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMNO000000000-CARMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMNY000000000-CARMNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMPM000000000-CARMPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMPS000000000-CARMPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMQI000000000-CARMQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMQY000000000-CARMQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMRO000000000-CARMRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMRT000000000-CARMRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMRW000000000-CARMRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMSF000000000-CARMSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMSY000000000-CARMSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMUD000000000-CARMUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMVA000000000-CARMVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMVN000000000-CARMVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMVT000000000-CARMVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMVZ000000000-CARMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMWC000000000-CARMWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMWR000000000-CARMWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMWX000000000-CARMWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMXE000000000-CARMXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMYA000000000-CARMYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMYM000000000-CARMYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARMYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARMZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARMZO000000000-CARMZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNBU000000000-CARNBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNCT000000000-CARNCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNCX000000000-CARNCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNDA000000000-CARNDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNDH000000000-CARNDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNEI000000000-CARNEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNES000000000-CARNET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNFM000000000-CARNFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNFR000000000-CARNFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNFY000000000-CARNFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNGQ000000000-CARNGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNGW000000000-CARNGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNIB000000000-CARNIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNJC000000000-CARNJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNJO000000000-CARNJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNKI000000000-CARNKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNKQ000000000-CARNKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNLF000000000-CARNLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNLJ000000000-CARNLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNMJ000000000-CARNMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNOD000000000-CARNOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNOJ000000000-CARNOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNOZ000000000-CARNPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNPD000000000-CARNPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNPH000000000-CARNPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNQO000000000-CARNQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNQS000000000-CARNQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNRN000000000-CARNRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNTN000000000-CARNTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNUG000000000-CARNUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNUP000000000-CARNUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNXG000000000-CARNXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNXR000000000-CARNXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNYB000000000-CARNYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARNZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNZD000000000-CARNZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARNZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARNZT000000000-CARNZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROAS000000000-CAROAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROBG000000000-CAROBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROCE000000000-CAROCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARODB000000000-CARODD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARODF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARODH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARODM000000000-CARODN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARODR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARODT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARODX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROEK000000000-CAROEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROEX000000000-CAROEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROFF000000000-CAROFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROFZ000000000-CAROGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROGL000000000-CAROGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROGY000000000-CAROGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROHD000000000-CAROHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROHQ000000000-CAROHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROHX000000000-CAROHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROIR000000000-CAROIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROJD000000000-CAROJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROJQ000000000-CAROJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROKE000000000-CAROKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROKR000000000-CAROKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROLI000000000-CAROLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROLW000000000-CAROLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROMR000000000-CAROMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARONG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARONJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARONL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARONN000000000-CARONQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARONV000000000-CARONW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARONY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROOA000000000-CAROOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROOF000000000-CAROOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROOV000000000-CAROOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROPD000000000-CAROPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROPH000000000-CAROPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROPO000000000-CAROPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROPR000000000-CAROPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROQE000000000-CAROQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROQO000000000-CAROQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARORG000000000-CARORI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARORK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARORS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARORU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARORW000000000-CARORX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARORZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROSB000000000-CAROSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROSE000000000-CAROSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROTA000000000-CAROTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROTE000000000-CAROTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROTQ000000000-CAROTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROVF000000000-CAROVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROVV000000000-CAROVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROVZ000000000-CAROWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROWG000000000-CAROWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROWX000000000-CAROWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROXM000000000-CAROXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROZE000000000-CAROZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAROZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROZY000000000-CAROZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPBN000000000-CARPBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPBX000000000-CARPBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPDY000000000-CARPDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPEH000000000-CARPEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPES000000000-CARPET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPEX000000000-CARPEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPFB000000000-CARPFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPHI000000000-CARPHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPHQ000000000-CARPHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPIA000000000-CARPIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPIH000000000-CARPIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPIT000000000-CARPIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPJG000000000-CARPJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPJX000000000-CARPJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPKG000000000-CARPKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPKO000000000-CARPKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPLG000000000-CARPLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPML000000000-CARPMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPNX000000000-CARPNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPOY000000000-CARPOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPPP000000000-CARPPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPRD000000000-CARPRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPRM000000000-CARPRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPTC000000000-CARPTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPTX000000000-CARPTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPUQ000000000-CARPUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPVE000000000-CARPVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPVV000000000-CARPVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPXC000000000-CARPXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPXF000000000-CARPXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPXL000000000-CARPXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPXR000000000-CARPXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPYA000000000-CARPYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPYF000000000-CARPYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARPZI000000000-CARPZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARPZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARPZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQAQ000000000-CARQAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQAV000000000-CARQAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQBD000000000-CARQBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQBR000000000-CARQBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQCB000000000-CARQCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQDB000000000-CARQDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQDL000000000-CARQDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQDY000000000-CARQDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQFI000000000-CARQFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQGJ000000000-CARQGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQGP000000000-CARQGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQHN000000000-CARQHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQHT000000000-CARQHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQHZ000000000-CARQIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQII000000000-CARQIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQJM000000000-CARQJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQJU000000000-CARQJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQKF000000000-CARQKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQKS000000000-CARQKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQLB000000000-CARQLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQLE000000000-CARQLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQMF000000000-CARQMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQNU000000000-CARQNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQOD000000000-CARQOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQOK000000000-CARQOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQPH000000000-CARQPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQQP000000000-CARQQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQQZ000000000-CARQRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQRK000000000-CARQRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQRT000000000-CARQRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQSU000000000-CARQSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQSX000000000-CARQTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQTR000000000-CARQTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQTU000000000-CARQTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQUM000000000-CARQUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQUU000000000-CARQUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQVY000000000-CARQVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQWF000000000-CARQWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQXQ000000000-CARQXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQZC000000000-CARQZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARQZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARQZU000000000-CARQZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARQZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRAG000000000-CARRAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRAU000000000-CARRAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRBF000000000-CARRBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRBW000000000-CARRBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRCN000000000-CARRCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRCQ000000000-CARRCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRCV000000000-CARRCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRCY000000000-CARRCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRDI000000000-CARRDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARREB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARREP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARREU000000000-CARREW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRFF000000000-CARRFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRGA000000000-CARRGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRGM000000000-CARRGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRHO000000000-CARRHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRII000000000-CARRIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRIM000000000-CARRIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRJN000000000-CARRJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRKE000000000-CARRKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRLF000000000-CARRLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRME000000000-CARRMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRNT000000000-CARRNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARROF000000000-CARROG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARROP000000000-CARROQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARROU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARROY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRPE000000000-CARRPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRPH000000000-CARRPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRRA000000000-CARRRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRRI000000000-CARRRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRRR000000000-CARRRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRSQ000000000-CARRSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRTO000000000-CARRTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRTS000000000-CARRTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRUH000000000-CARRUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRVN000000000-CARRVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRWG000000000-CARRWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRXB000000000-CARRXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRXQ000000000-CARRXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRYD000000000-CARRYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRYL000000000-CARRYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRYR000000000-CARRYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRZI000000000-CARRZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARRZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSBT000000000-CARSBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSBX000000000-CARSBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSCC000000000-CARSCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSCM000000000-CARSCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSDH000000000-CARSDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSDK000000000-CARSDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSDR000000000-CARSDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSDY000000000-CARSDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSGP000000000-CARSGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSGT000000000-CARSGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSHU000000000-CARSHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSID000000000-CARSIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSIQ000000000-CARSIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSJI000000000-CARSJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSJO000000000-CARSJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSKB000000000-CARSKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSKM000000000-CARSKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSLS000000000-CARSLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSLY000000000-CARSLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSOY000000000-CARSPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSPE000000000-CARSPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSPN000000000-CARSPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSPT000000000-CARSPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSPX000000000-CARSPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSQS000000000-CARSQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSSF000000000-CARSSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSTE000000000-CARSTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSUL000000000-CARSUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSVV000000000-CARSVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSWH000000000-CARSWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSWU000000000-CARSWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSXF000000000-CARSXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARSXQ000000000-CARSXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARSXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARSZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTBR000000000-CARTBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTCG000000000-CARTCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTCT000000000-CARTCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTDC000000000-CARTDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTDP000000000-CARTDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTDY000000000-CARTEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTEN000000000-CARTEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTET000000000-CARTEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTFD000000000-CARTFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTGJ000000000-CARTGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTGM000000000-CARTGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTGV000000000-CARTGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTHP000000000-CARTHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTHS000000000-CARTHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTID000000000-CARTIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTIG000000000-CARTIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTIO000000000-CARTIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTJA000000000-CARTJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTJD000000000-CARTJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTJL000000000-CARTJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTJR000000000-CARTJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTJW000000000-CARTJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTJZ000000000-CARTKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTLL000000000-CARTLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTLV000000000-CARTLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTLY000000000-CARTLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTME000000000-CARTMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTNE000000000-CARTNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTNR000000000-CARTNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTOD000000000-CARTOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTOR000000000-CARTOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTQP000000000-CARTQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTSF000000000-CARTSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTSS000000000-CARTST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTUS000000000-CARTUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTVJ000000000-CARTVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTVP000000000-CARTVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTVY000000000-CARTVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTWL000000000-CARTWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTWV000000000-CARTWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTYK000000000-CARTYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTYN000000000-CARTYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTZD000000000-CARTZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARTZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTZO000000000-CARTZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUBH000000000-CARUBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUBZ000000000-CARUCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUCF000000000-CARUCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUDU000000000-CARUDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUED000000000-CARUEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUEJ000000000-CARUEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUEV000000000-CARUEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUFN000000000-CARUFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUGM000000000-CARUGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUGU000000000-CARUGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUHD000000000-CARUHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUIR000000000-CARUIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUKO000000000-CARUKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUKU000000000-CARUKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARULG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARULU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARULZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUOO000000000-CARUOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUPU000000000-CARUPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUPY000000000-CARUPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUQO000000000-CARUQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARURC000000000-CARURD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARURF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARURZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUSB000000000-CARUSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUTH000000000-CARUTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUTU000000000-CARUTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUWQ000000000-CARUWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUXX000000000-CARUXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUYP000000000-CARUYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUZD000000000-CARUZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUZL000000000-CARUZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUZO000000000-CARUZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVAO000000000-CARVAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVDI000000000-CARVDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVDT000000000-CARVDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVEC000000000-CARVED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVEM000000000-CARVEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVFA000000000-CARVFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVGD000000000-CARVGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVGR000000000-CARVGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVGW000000000-CARVGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVHV000000000-CARVHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVJQ000000000-CARVJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVKE000000000-CARVKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVKT000000000-CARVKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVLC000000000-CARVLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVLT000000000-CARVLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVMS000000000-CARVMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVOA000000000-CARVOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARVPZ000000000-CARVQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARVQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARVRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "specia